/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.TimeSpan;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] zzaIX = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String zzaIZ;
    private String zzacX;
    private int zzade;
    private HashMap<Integer, Result> zzaJD;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.zzade = dataHolder.getStatusCode();
        this.zzaJD = new HashMap();
        int n = dataHolder.getCount();
        zzx.zzac((n == 3 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = dataHolder.zzbH(i);
            if (i == 0) {
                this.zzaIZ = dataHolder.zzd("leaderboardId", i, n2);
                this.zzacX = dataHolder.zzd("playerId", i, n2);
            }
            if (!(bl = dataHolder.zze("hasResult", i, n2))) continue;
            Result result = new Result(dataHolder.zzb("rawScore", i, n2), dataHolder.zzd("formattedScore", i, n2), dataHolder.zzd("scoreTag", i, n2), dataHolder.zze("newBest", i, n2));
            this.zza(result, dataHolder.zzc("timeSpan", i, n2));
        }
    }

    public String getLeaderboardId() {
        return this.zzaIZ;
    }

    public String getPlayerId() {
        return this.zzacX;
    }

    public Result getScoreResult(int timeSpan) {
        return this.zzaJD.get(timeSpan);
    }

    private void zza(Result result, int n) {
        this.zzaJD.put(n, result);
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzy((Object)this).zzg("PlayerId", (Object)this.zzacX).zzg("StatusCode", (Object)this.zzade);
        for (int i = 0; i < 3; ++i) {
            Result result = this.zzaJD.get(i);
            zza2.zzg("TimesSpan", (Object)TimeSpan.zzgw(i));
            zza2.zzg("Result", (Object)(result == null ? "null" : result.toString()));
        }
        return zza2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return zzw.zzy((Object)this).zzg("RawScore", (Object)this.rawScore).zzg("FormattedScore", (Object)this.formattedScore).zzg("ScoreTag", (Object)this.scoreTag).zzg("NewBest", (Object)this.newBest).toString();
        }
    }
}

