/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.zzms;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzaFa;
    private final String zzWQ;
    private final Uri zzaCd;
    private final Uri zzaCe;
    private final int zzBc;
    private final String zzaDX;
    private final boolean zzaJM;
    private final PlayerEntity zzaDq;
    private final int zzaab;
    private final ParticipantResult zzaJN;
    private final String zzaCo;
    private final String zzaCp;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.zzaFa = participant.getParticipantId();
        this.zzWQ = participant.getDisplayName();
        this.zzaCd = participant.getIconImageUri();
        this.zzaCe = participant.getHiResImageUri();
        this.zzBc = participant.getStatus();
        this.zzaDX = participant.zzwt();
        this.zzaJM = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaDq = player == null ? null : new PlayerEntity(player);
        this.zzaab = participant.getCapabilities();
        this.zzaJN = participant.getResult();
        this.zzaCo = participant.getIconImageUrl();
        this.zzaCp = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.mVersionCode = versionCode;
        this.zzaFa = participantId;
        this.zzWQ = displayName;
        this.zzaCd = iconImageUri;
        this.zzaCe = hiResImageUri;
        this.zzBc = status;
        this.zzaDX = clientAddress;
        this.zzaJM = connectedToRoom;
        this.zzaDq = player;
        this.zzaab = capabilities;
        this.zzaJN = result;
        this.zzaCo = iconImageUrl;
        this.zzaCp = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzBc;
    }

    @Override
    public String zzwt() {
        return this.zzaDX;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzaJM;
    }

    @Override
    public String getDisplayName() {
        if (this.zzaDq == null) {
            return this.zzWQ;
        }
        return this.zzaDq.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaDq == null) {
            zzms.zzb((String)this.zzWQ, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzaDq.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzaDq == null) {
            return this.zzaCd;
        }
        return this.zzaDq.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzaDq == null) {
            return this.zzaCo;
        }
        return this.zzaDq.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzaDq == null) {
            return this.zzaCe;
        }
        return this.zzaDq.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzaDq == null) {
            return this.zzaCp;
        }
        return this.zzaDq.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzaFa;
    }

    @Override
    public Player getPlayer() {
        return this.zzaDq;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzaJN;
    }

    @Override
    public int getCapabilities() {
        return this.zzaab;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzw.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzwt(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzw.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzw.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzw.equal((Object)participant2.zzwt(), (Object)participant.zzwt()) && zzw.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzw.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzw.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzw.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzw.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzw.equal((Object)participant2.getResult(), (Object)participant.getResult()) && zzw.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzw.zzy((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzwt()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqC()) {
            ParticipantEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzaFa);
            dest.writeString(this.zzWQ);
            dest.writeString(this.zzaCd == null ? null : this.zzaCd.toString());
            dest.writeString(this.zzaCe == null ? null : this.zzaCe.toString());
            dest.writeInt(this.zzBc);
            dest.writeString(this.zzaDX);
            dest.writeInt(this.zzaJM ? 1 : 0);
            dest.writeInt(this.zzaDq == null ? 0 : 1);
            if (this.zzaDq != null) {
                this.zzaDq.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzes(Parcel parcel) {
            boolean bl = ParticipantEntity.zzd(ParticipantEntity.zzqB());
            if (bl || ParticipantEntity.zzcF((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzes(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            ParticipantResult participantResult = null;
            String string6 = null;
            String string7 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, n2, participantResult, string6, string7);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzes(parcel);
        }
    }
}

