/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantRef
extends zzc
implements Participant {
    private final PlayerRef zzaJO;

    public ParticipantRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
        this.zzaJO = new PlayerRef(holder, dataRow);
    }

    public Participant freeze() {
        return new ParticipantEntity(this);
    }

    @Override
    public int getStatus() {
        return this.getInteger("player_status");
    }

    @Override
    public String zzwt() {
        return this.getString("client_address");
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.getInteger("connected") > 0;
    }

    @Override
    public String getDisplayName() {
        if (this.zzcB("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzaJO.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzcB("external_player_id")) {
            this.zza("default_display_name", dataOut);
            return;
        }
        this.zzaJO.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzcB("external_player_id")) {
            return this.zzcA("default_display_image_uri");
        }
        return this.zzaJO.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzcB("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzaJO.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzcB("external_player_id")) {
            return this.zzcA("default_display_hi_res_image_uri");
        }
        return this.zzaJO.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzcB("external_player_id")) {
            return this.getString("default_display_hi_res_image_url");
        }
        return this.zzaJO.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.getString("external_participant_id");
    }

    @Override
    public Player getPlayer() {
        if (this.zzcB("external_player_id")) {
            return null;
        }
        return this.zzaJO;
    }

    @Override
    public ParticipantResult getResult() {
        if (this.zzcB("result_type")) {
            return null;
        }
        int n = this.getInteger("result_type");
        int n2 = this.getInteger("placing");
        return new ParticipantResult(this.getParticipantId(), n, n2);
    }

    @Override
    public int getCapabilities() {
        return this.getInteger("capabilities");
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParticipantEntity participantEntity = (ParticipantEntity)this.freeze();
        participantEntity.writeToParcel(dest, flags);
    }
}

