/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzaKe;
    private final TurnBasedMatchBuffer zzaKf;
    private final TurnBasedMatchBuffer zzaKg;
    private final TurnBasedMatchBuffer zzaKh;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.zza(matchData, 0);
        this.zzaKe = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(matchData, 1);
        this.zzaKf = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(matchData, 2);
        this.zzaKg = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(matchData, 3);
        this.zzaKh = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzgw(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzaKe;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzaKf;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzaKg;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzaKh;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzaKe != null) {
            this.zzaKe.release();
        }
        if (this.zzaKf != null) {
            this.zzaKf.release();
        }
        if (this.zzaKg != null) {
            this.zzaKg.release();
        }
        if (this.zzaKh != null) {
            this.zzaKh.release();
        }
    }

    public boolean hasData() {
        if (this.zzaKe != null && this.zzaKe.getCount() > 0) {
            return true;
        }
        if (this.zzaKf != null && this.zzaKf.getCount() > 0) {
            return true;
        }
        if (this.zzaKg != null && this.zzaKg.getCount() > 0) {
            return true;
        }
        return this.zzaKh != null && this.zzaKh.getCount() > 0;
    }
}

