/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.zzms;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR = new SnapshotMetadataEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaJE;
    private final PlayerEntity zzaKT;
    private final String zzaEp;
    private final Uri zzaKQ;
    private final String zzaKU;
    private final String zzapg;
    private final String zzaxl;
    private final long zzaKV;
    private final long zzaKW;
    private final float zzaKX;
    private final String zzaKY;
    private final boolean zzaKZ;
    private final long zzaLa;
    private final String zzaLb;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.mVersionCode = 6;
        this.zzaJE = new GameEntity(snapshotMetadata.getGame());
        this.zzaKT = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzaEp = snapshotMetadata.getSnapshotId();
        this.zzaKQ = snapshotMetadata.getCoverImageUri();
        this.zzaKU = snapshotMetadata.getCoverImageUrl();
        this.zzaKX = snapshotMetadata.getCoverImageAspectRatio();
        this.zzapg = snapshotMetadata.getTitle();
        this.zzaxl = snapshotMetadata.getDescription();
        this.zzaKV = snapshotMetadata.getLastModifiedTimestamp();
        this.zzaKW = snapshotMetadata.getPlayedTime();
        this.zzaKY = snapshotMetadata.getUniqueName();
        this.zzaKZ = snapshotMetadata.hasChangePending();
        this.zzaLa = snapshotMetadata.getProgressValue();
        this.zzaLb = snapshotMetadata.getDeviceName();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending, long progressValue, String deviceName) {
        this.mVersionCode = versionCode;
        this.zzaJE = game;
        this.zzaKT = owner;
        this.zzaEp = snapshotId;
        this.zzaKQ = coverImageUri;
        this.zzaKU = coverImageUrl;
        this.zzaKX = coverImageAspectRatio;
        this.zzapg = title;
        this.zzaxl = description;
        this.zzaKV = lastModifiedTimestamp;
        this.zzaKW = playedTime;
        this.zzaKY = uniqueName;
        this.zzaKZ = changePending;
        this.zzaLa = progressValue;
        this.zzaLb = deviceName;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaJE;
    }

    @Override
    public Player getOwner() {
        return this.zzaKT;
    }

    @Override
    public String getSnapshotId() {
        return this.zzaEp;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzaKQ;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzaKU;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzaKX;
    }

    @Override
    public String getUniqueName() {
        return this.zzaKY;
    }

    @Override
    public String getTitle() {
        return this.zzapg;
    }

    @Override
    public String getDescription() {
        return this.zzaxl;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaxl, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzaKV;
    }

    @Override
    public long getPlayedTime() {
        return this.zzaKW;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzaKZ;
    }

    @Override
    public long getProgressValue() {
        return this.zzaLa;
    }

    @Override
    public String getDeviceName() {
        return this.zzaLb;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzw.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue(), snapshotMetadata.getDeviceName()});
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzw.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && zzw.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && zzw.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && zzw.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && zzw.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzw.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && zzw.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && zzw.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && zzw.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && zzw.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && zzw.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && zzw.equal((Object)snapshotMetadata2.getProgressValue(), (Object)snapshotMetadata.getProgressValue()) && zzw.equal((Object)snapshotMetadata2.getDeviceName(), (Object)snapshotMetadata.getDeviceName());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzw.zzy((Object)snapshotMetadata).zzg("Game", (Object)snapshotMetadata.getGame()).zzg("Owner", (Object)snapshotMetadata.getOwner()).zzg("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", (Object)snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).zzg("UniqueName", (Object)snapshotMetadata.getUniqueName()).zzg("ChangePending", (Object)snapshotMetadata.hasChangePending()).zzg("ProgressValue", (Object)snapshotMetadata.getProgressValue()).zzg("DeviceName", (Object)snapshotMetadata.getDeviceName()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.zza(this, out, flags);
    }
}

