/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.video.Video;
import com.google.android.gms.games.video.VideoEntityCreator;

public final class VideoEntity
implements SafeParcelable,
Video {
    public static final Parcelable.Creator<VideoEntity> CREATOR = new VideoEntityCreator();
    private final int mVersionCode;
    private final int zzakd;
    private final String zzaLv;
    private final long zzaLw;
    private final long zzCv;
    private final String zzTJ;

    public VideoEntity(Video video) {
        this.mVersionCode = 1;
        this.zzakd = video.getDuration();
        this.zzaLv = video.zzxX();
        this.zzaLw = video.getFileSize();
        this.zzCv = video.getStartTime();
        this.zzTJ = video.getPackageName();
        zzb.zzv((Object)this.zzaLv);
        zzb.zzv((Object)this.zzTJ);
    }

    VideoEntity(int versionCode, int duration, String filePath, long fileSize, long startTime, String packageName) {
        this.mVersionCode = versionCode;
        this.zzakd = duration;
        this.zzaLv = filePath;
        this.zzaLw = fileSize;
        this.zzCv = startTime;
        this.zzTJ = packageName;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getDuration() {
        return this.zzakd;
    }

    @Override
    public String zzxX() {
        return this.zzaLv;
    }

    @Override
    public long getFileSize() {
        return this.zzaLw;
    }

    @Override
    public long getStartTime() {
        return this.zzCv;
    }

    @Override
    public String getPackageName() {
        return this.zzTJ;
    }

    public Video zzyg() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return VideoEntity.zza(this);
    }

    static int zza(Video video) {
        return zzw.hashCode((Object[])new Object[]{video.getDuration(), video.zzxX(), video.getFileSize(), video.getStartTime(), video.getPackageName()});
    }

    public boolean equals(Object obj) {
        return VideoEntity.zza(this, obj);
    }

    static boolean zza(Video video, Object object) {
        if (!(object instanceof Video)) {
            return false;
        }
        if (video == object) {
            return true;
        }
        Video video2 = (Video)object;
        return zzw.equal((Object)video2.getDuration(), (Object)video.getDuration()) && zzw.equal((Object)video2.zzxX(), (Object)video.zzxX()) && zzw.equal((Object)video2.getFileSize(), (Object)video.getFileSize()) && zzw.equal((Object)video2.getStartTime(), (Object)video.getStartTime()) && zzw.equal((Object)video2.getPackageName(), (Object)video.getPackageName());
    }

    public String toString() {
        return VideoEntity.zzb(this);
    }

    static String zzb(Video video) {
        zzw.zza zza2 = zzw.zzy((Object)video).zzg("Duration", (Object)video.getDuration()).zzg("File path", (Object)video.zzxX()).zzg("File size", (Object)video.getFileSize()).zzg("Start time", (Object)video.getStartTime()).zzg("Package name", (Object)video.getPackageName());
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        VideoEntityCreator.zza(this, dest, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzyg();
    }
}

