/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private String zzahz;
    private String zzaco;
    private final Uri zzaIU;
    private final Uri zzaIV;
    private final long zzaJE;
    private final int zzaJF;
    private final long zzaJG;
    private final String zzaJf;
    private final String zzaJg;
    private final String zzavG;
    private final MostRecentGameInfoEntity zzaJH;
    private final PlayerLevelInfo zzaJI;
    private final boolean zzaJJ;
    private final boolean zzaJK;
    private final String zzaJL;
    private final String mName;
    private final Uri zzaJM;
    private final String zzaJN;
    private final Uri zzaJO;
    private final String zzaJP;
    private final int zzaJQ;
    private final long zzaJR;
    private final boolean zzST;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean bl) {
        this.mVersionCode = 14;
        this.zzahz = bl ? player.getPlayerId() : null;
        this.zzaco = player.getDisplayName();
        this.zzaIU = player.getIconImageUri();
        this.zzaJf = player.getIconImageUrl();
        this.zzaIV = player.getHiResImageUri();
        this.zzaJg = player.getHiResImageUrl();
        this.zzaJE = player.getRetrievedTimestamp();
        this.zzaJF = player.zzyS();
        this.zzaJG = player.getLastPlayedWithTimestamp();
        this.zzavG = player.getTitle();
        this.zzaJJ = player.zzyT();
        MostRecentGameInfo mostRecentGameInfo = player.zzyU();
        this.zzaJH = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzaJI = player.getLevelInfo();
        this.zzaJK = player.zzyR();
        this.zzaJL = player.zzyQ();
        this.mName = player.getName();
        this.zzaJM = player.getBannerImageLandscapeUri();
        this.zzaJN = player.getBannerImageLandscapeUrl();
        this.zzaJO = player.getBannerImagePortraitUri();
        this.zzaJP = player.getBannerImagePortraitUrl();
        this.zzaJQ = player.zzyV();
        this.zzaJR = player.zzyW();
        this.zzST = player.isMuted();
        if (bl) {
            zzb.zzv((Object)this.zzahz);
        }
        zzb.zzv((Object)this.zzaco);
        zzb.zzai((this.zzaJE > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int n, String string, String string2, Uri uri, Uri uri2, long l, int n2, long l2, String string3, String string4, String string5, MostRecentGameInfoEntity mostRecentGameInfoEntity, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n3, long l3, boolean bl3) {
        this.mVersionCode = n;
        this.zzahz = string;
        this.zzaco = string2;
        this.zzaIU = uri;
        this.zzaJf = string3;
        this.zzaIV = uri2;
        this.zzaJg = string4;
        this.zzaJE = l;
        this.zzaJF = n2;
        this.zzaJG = l2;
        this.zzavG = string5;
        this.zzaJJ = bl;
        this.zzaJH = mostRecentGameInfoEntity;
        this.zzaJI = playerLevelInfo;
        this.zzaJK = bl2;
        this.zzaJL = string6;
        this.mName = string7;
        this.zzaJM = uri3;
        this.zzaJN = string8;
        this.zzaJO = uri4;
        this.zzaJP = string9;
        this.zzaJQ = n3;
        this.zzaJR = l3;
        this.zzST = bl3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.zzahz;
    }

    @Override
    public String getDisplayName() {
        return this.zzaco;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaco, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String zzyQ() {
        return this.zzaJL;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzyR() {
        return this.zzaJK;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaIU;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaJf;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaIV;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaJg;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzaJE;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzaJG;
    }

    @Override
    public int zzyS() {
        return this.zzaJF;
    }

    @Override
    public boolean zzyT() {
        return this.zzaJJ;
    }

    @Override
    public String getTitle() {
        return this.zzavG;
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzavG, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaJI;
    }

    @Override
    public MostRecentGameInfo zzyU() {
        return this.zzaJH;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzaJM;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.zzaJN;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzaJO;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.zzaJP;
    }

    @Override
    public int zzyV() {
        return this.zzaJQ;
    }

    @Override
    public long zzyW() {
        return this.zzaJR;
    }

    @Override
    public boolean isMuted() {
        return this.zzST;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzz.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzyR(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzyQ(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzyV(), player.zzyW(), player.isMuted()});
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzz.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzz.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzz.equal((Object)player2.zzyR(), (Object)player.zzyR()) && zzz.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzz.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzz.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzz.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzz.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzz.equal((Object)player2.zzyQ(), (Object)player.zzyQ()) && zzz.equal((Object)player2.getName(), (Object)player.getName()) && zzz.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzz.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzz.equal((Object)player2.zzyV(), (Object)player.zzyV()) && zzz.equal((Object)player2.zzyW(), (Object)player.zzyW()) && zzz.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzz.zzy((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzyR()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzyQ()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzyV()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzyW()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zztG()) {
            PlayerEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.zzahz);
            parcel.writeString(this.zzaco);
            parcel.writeString(this.zzaIU == null ? null : this.zzaIU.toString());
            parcel.writeString(this.zzaIV == null ? null : this.zzaIV.toString());
            parcel.writeLong(this.zzaJE);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzeb(Parcel parcel) {
            boolean bl = PlayerEntity.zzf(PlayerEntity.zztF());
            if (bl || PlayerEntity.zzde((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzeb(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            int n = -1;
            long l2 = -1L;
            Object var16_14 = null;
            Object var17_15 = null;
            Object var18_16 = null;
            Object var19_17 = null;
            Object var20_18 = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Object var23_21 = null;
            Object var24_22 = null;
            Object var25_23 = null;
            Object var26_24 = null;
            int n2 = -1;
            long l3 = -1L;
            boolean bl4 = false;
            return new PlayerEntity(14, string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeb(parcel);
        }
    }
}

