/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;

public final class AchievementEntity
extends AbstractSafeParcelable
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String zzaKb;
    private final int zzagd;
    private final String mName;
    private final String zzVw;
    private final Uri zzaKc;
    private final String zzaKd;
    private final Uri zzaKe;
    private final String zzaKf;
    private final int zzaKg;
    private final String zzaKh;
    private final PlayerEntity zzaKi;
    private final int mState;
    private final int zzaKj;
    private final String zzaKk;
    private final long zzaKl;
    private final long zzaKm;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.zzaKb = achievement.getAchievementId();
        this.zzagd = achievement.getType();
        this.mName = achievement.getName();
        this.zzVw = achievement.getDescription();
        this.zzaKc = achievement.getUnlockedImageUri();
        this.zzaKd = achievement.getUnlockedImageUrl();
        this.zzaKe = achievement.getRevealedImageUri();
        this.zzaKf = achievement.getRevealedImageUrl();
        this.zzaKi = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzaKl = achievement.getLastUpdatedTimestamp();
        this.zzaKm = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzaKg = achievement.getTotalSteps();
            this.zzaKh = achievement.getFormattedTotalSteps();
            this.zzaKj = achievement.getCurrentSteps();
            this.zzaKk = achievement.getFormattedCurrentSteps();
        } else {
            this.zzaKg = 0;
            this.zzaKh = null;
            this.zzaKj = 0;
            this.zzaKk = null;
        }
        zzb.zzv((Object)this.zzaKb);
        zzb.zzv((Object)this.zzVw);
    }

    AchievementEntity(int n, String string, int n2, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n3, String string6, PlayerEntity playerEntity, int n4, int n5, String string7, long l, long l2) {
        this.mVersionCode = n;
        this.zzaKb = string;
        this.zzagd = n2;
        this.mName = string2;
        this.zzVw = string3;
        this.zzaKc = uri;
        this.zzaKd = string4;
        this.zzaKe = uri2;
        this.zzaKf = string5;
        this.zzaKg = n3;
        this.zzaKh = string6;
        this.zzaKi = playerEntity;
        this.mState = n4;
        this.zzaKj = n5;
        this.zzaKk = string7;
        this.zzaKl = l;
        this.zzaKm = l2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.zzaKb;
    }

    @Override
    public int getType() {
        return this.zzagd;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzVw;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzVw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzaKc;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzaKd;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzaKe;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzaKf;
    }

    public int zzzd() {
        return this.zzaKg;
    }

    @Override
    public int getTotalSteps() {
        zzb.zzai((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzzd();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzb.zzai((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzze();
    }

    public String zzze() {
        return this.zzaKh;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        zzb.zzai((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzaKh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Player getPlayer() {
        return this.zzaKi;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzb.zzai((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzzf();
    }

    public int zzzf() {
        return this.zzaKj;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzb.zzai((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzzg();
    }

    public String zzzg() {
        return this.zzaKk;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        zzb.zzai((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzaKk, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaKl;
    }

    @Override
    public long getXpValue() {
        return this.zzaKm;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzz.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object object) {
        return AchievementEntity.zza(this, object);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzz.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzz.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzz.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzz.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzz.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzz.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzz.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzz.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzz.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzz.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzz.zza zza2 = zzz.zzy((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        AchievementEntityCreator.zza(this, parcel, n);
    }
}

