/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.player.ProfileSettingsEntity;
import com.google.android.gms.games.internal.player.StockProfileImageBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.OnSocialInviteUpdateReceivedListener;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.social.SocialInvite;
import com.google.android.gms.games.social.SocialInviteBuffer;
import com.google.android.gms.games.social.SocialInviteEntity;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.signin.internal.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends zzk<IGamesService> {
    EventIncrementManager zzaKQ = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzAn() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String zzaKR;
    private PlayerEntity zzaKS;
    private GameEntity zzaKT;
    private final PopupManager zzaKU;
    private boolean zzaKV = false;
    private final Binder zzaKW;
    private final long zzaKX;
    private final Games.GamesOptions zzaKY;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzg zzg2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaKR = zzg2.zzty();
        this.zzaKW = new Binder();
        this.zzaKU = PopupManager.zza(this, zzg2.zztu());
        this.zzr(zzg2.zztA());
        this.zzaKX = ((Object)((Object)this)).hashCode();
        this.zzaKY = gamesOptions;
    }

    public boolean zzpd() {
        return true;
    }

    public void zza(@NonNull IGamesService iGamesService) {
        super.zza((IInterface)iGamesService);
        if (this.zzaKV) {
            this.zzaKU.zzAB();
            this.zzaKV = false;
        }
        if (!this.zzaKY.zzaJt && !this.zzaKY.zzaJB) {
            this.zzb(iGamesService);
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzaKV = false;
    }

    public void zzgO(int n) {
        this.zzaKU.setGravity(n);
    }

    public void zzr(View view) {
        this.zzaKU.zzs(view);
    }

    protected Set<Scope> zzb(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzaa.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzaa.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(zzd.zzf zzf2) {
        this.zzzO();
        super.zza(zzf2);
    }

    public void disconnect() {
        this.zzaKV = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zztm();
                iGamesService.zzAm();
                this.zzaKQ.flush();
                iGamesService.zzI(this.zzaKX);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzD("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzhT() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzhU() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzcd(IBinder iBinder) {
        return IGamesService.Stub.zzcg(iBinder);
    }

    public Bundle zzqr() {
        try {
            Bundle bundle = ((IGamesService)this.zztm()).zzqr();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zzzO() {
        this.zzaKS = null;
        this.zzaKT = null;
    }

    protected Bundle zzoO() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzaKY.zzyP();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzaKR);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzaKU.zzAD()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 4);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzg.zza((com.google.android.gms.common.internal.zzg)this.zztH()));
        return bundle;
    }

    public void zzb(IGamesService iGamesService) {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.zzaKU);
            iGamesService.zza(popupLocationInfoBinderCallbacks, this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zzzP() {
        try {
            return ((IGamesService)this.zztm()).zzzP();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzd(zznt.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzj(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public void zzb(String string, zznt.zzb<Games.GetServerAuthCodeResult> zzb2) throws RemoteException {
        zzaa.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((IGamesService)this.zztm()).zza(string, new GetServerAuthCodeBinderCallbacks(zzb2));
    }

    public String zzao(boolean bl) {
        if (bl && this.zzaKS != null) {
            return this.zzaKS.getPlayerId();
        }
        try {
            return ((IGamesService)this.zztm()).zzAo();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzzQ() {
        this.zztl();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaKS == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zztm()).zzAp());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzaKS = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzaKS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzzR() {
        this.zztl();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaKT == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zztm()).zzAr());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzaKT = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzaKT;
    }

    public void zza(zznt.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zznt.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zznt.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zznt.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zztm()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zznt.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                String string3 = String.valueOf(string);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid player collection: ".concat(string3) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zznt.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzzS() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzzS();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zznt.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zznt.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zznt.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zznt.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zznt.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zznt.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzBn().asBundle(), n, n2);
    }

    public void zza(zznt.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzzT() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzzT();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zznt.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zznt.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaKU.zzAD(), this.zzaKU.zzAC());
    }

    public void zzb(zznt.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaKU.zzAD(), this.zzaKU.zzAC());
    }

    public void zza(zznt.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaKU.zzAD(), this.zzaKU.zzAC());
    }

    public void zzb(zznt.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaKU.zzAD(), this.zzaKU.zzAC());
    }

    public void zzd(zznt.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zznt.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzn(String string, int n) {
        this.zzaKQ.zzn(string, n);
    }

    public Intent zzzU() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzzU();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzzV() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzzV();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzou<OnInvitationReceivedListener> zzou2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzou2);
            ((IGamesService)this.zztm()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzzW() {
        try {
            ((IGamesService)this.zztm()).zzJ(this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzou<OnTurnBasedMatchUpdateReceivedListener> zzou2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzou2);
            ((IGamesService)this.zztm()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzzX() {
        try {
            ((IGamesService)this.zztm()).zzK(this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzou<QuestUpdateListener> zzou2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzou2);
            ((IGamesService)this.zztm()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzzY() {
        try {
            ((IGamesService)this.zztm()).zzM(this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzou<OnRequestReceivedListener> zzou2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzou2);
            ((IGamesService)this.zztm()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzzZ() {
        try {
            ((IGamesService)this.zztm()).zzL(this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzAa() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzAa();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzAb() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzAb();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zze(zznt.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzf(zznt.zzb<Status> zzb2) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzAc() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zztm()).zzAc();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zziC() {
        try {
            return ((IGamesService)this.zztm()).zziC();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zza(zznt.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzo(String string, int n) {
        try {
            ((IGamesService)this.zztm()).zzo(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzp(String string, int n) {
        try {
            ((IGamesService)this.zztm()).zzp(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zznt.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzBt(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zznt.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzk((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zznt.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzl((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzAd() {
        int n = -1;
        try {
            n = ((IGamesService)this.zztm()).zzAd();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zznt.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zznt.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zznt.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzn(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zznt.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zznt.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzm((IGamesCallbacks)new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzei(String string) {
        try {
            ((IGamesService)this.zztm()).zzeq(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zznt.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zznt.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzo(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzou<RoomUpdateListener> zzou2, zzou<RoomStatusUpdateListener> zzou3, zzou<RealTimeMessageReceivedListener> zzou4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzou2, zzou3, zzou4);
            ((IGamesService)this.zztm()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaKW, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzou<RoomUpdateListener> zzou2, zzou<RoomStatusUpdateListener> zzou3, zzou<RealTimeMessageReceivedListener> zzou4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzou2, zzou3, zzou4);
            ((IGamesService)this.zztm()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaKW, roomConfig.getInvitationId(), false, this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzou<RoomUpdateListener> zzou2, String string) {
        try {
            ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzou2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzou<RealTimeMultiplayer.ReliableMessageSentCallback> zzou2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zztm()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzou2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzaa.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zztm()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zze(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zztm()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzgP(int n) {
        try {
            ((IGamesService)this.zztm()).zzgP(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzAe() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzAe();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zza(n, byArray, n2, string);
            zzaa.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzAf() {
        int n = -1;
        try {
            n = ((IGamesService)this.zztm()).zzAf();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzAg() {
        int n = -1;
        try {
            n = ((IGamesService)this.zztm()).zzAg();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zznt.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zznt.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zznt.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zznt.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zznt.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzb(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzb(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzej(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzej(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zznt.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zzt(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zznt.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zznt.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zznt.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzek(String string) {
        try {
            ((IGamesService)this.zztm()).zza(string, this.zzaKU.zzAD(), this.zzaKU.zzAC());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zznt.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zznt.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaKQ.flush();
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzAh() {
        int n = -1;
        try {
            n = ((IGamesService)this.zztm()).zzAh();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzAi() {
        int n = -1;
        try {
            n = ((IGamesService)this.zztm()).zzAi();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zznt.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zznt.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zznt.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzaa.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzBy();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzvG();
        snapshotContents.close();
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzaa.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzvG();
        snapshotContents.close();
        try {
            ((IGamesService)this.zztm()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zznt.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzq(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zznt.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzaa.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzBy();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzvG();
        snapshotContents.close();
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zzg(zznt.zzb<Videos.CaptureCapabilitiesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzl(new CaptureCapabilitiesBinderCallback(zzb2));
    }

    public Intent zzAj() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zztm()).zzAx();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zznt.zzb<Videos.CaptureStateResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzv(new CaptureStateBinderCallbacks(zzb2));
    }

    public void zzi(zznt.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzs(new CaptureStreamingAvailabilityBinderCallback(zzb2));
    }

    public void zzj(zznt.zzb<Videos.CaptureStreamingMetadataResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzq(new CaptureStreamingMetadataBinderCallback(zzb2));
    }

    public void zzk(zznt.zzb<Videos.CaptureStreamingUrlResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzr(new CaptureStreamingUrlBinderCallback(zzb2));
    }

    public void zzl(zznt.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzt(new HeadlessCaptureEnabledBinderCallback(zzb2));
    }

    public void zzb(zznt.zzb<Videos.CaptureAvailableResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new CaptureAvailableBinderCallback(zzb2), n);
    }

    public boolean zzAk() {
        boolean bl = false;
        try {
            bl = ((IGamesService)this.zztm()).zzAk();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return bl;
    }

    public void zzm(zznt.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzo(new CaptureStreamingEnabledBinderCallback(zzb2));
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new CaptureLaunchGameAndOverlayBinderCallback(baseGamesApiMethodImpl), string, videoConfiguration);
    }

    public void zzn(zznt.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzk(new ListVideosBinderCallback(zzb2));
    }

    public void zzc(zznt.zzb<Videos.ListVideosResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zzd((IGamesCallbacks)new ListVideosBinderCallback(zzb2), string, n);
    }

    public void zze(zzou<Videos.CaptureOverlayStateListener> zzou2) {
        try {
            CaptureOverlayStateBinderCallback captureOverlayStateBinderCallback = new CaptureOverlayStateBinderCallback(zzou2);
            ((IGamesService)this.zztm()).zzf((IGamesCallbacks)captureOverlayStateBinderCallback, this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzg(zznt.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzm((IGamesCallbacks)new CapturePausedBinderCallback(zzb2), bl);
    }

    public void zza(zznt.zzb<Status> zzb2, VideoConfiguration videoConfiguration, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new CaptureStartedBinderCallbacks(zzb2, captureRuntimeErrorCallback), videoConfiguration);
    }

    public void zzo(zznt.zzb<Videos.CaptureStoppedResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzu(new CaptureStoppedBinderCallbacks(zzb2));
    }

    public void zzAl() {
        try {
            ((IGamesService)this.zztm()).zzP(this.zzaKX);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zznt.zzb<Status> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzh(new UpdateHeadlessCapturePermissionBinderCallback(zzb2), string, bl);
    }

    public void zzj(zznt.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zznt.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzp(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zznt.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zznt.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zznt.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zznt.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zznt.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zznt.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zznt.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zztm()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zznt.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zznt.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zznt.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzr(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zznt.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zze(zznt.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zza(zznt.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl, bl2);
    }

    public void zzh(zznt.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zza(zznt.zzb<Players.LoadPlayersResult> zzb2, Account account) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), account);
    }

    public void zzp(zznt.zzb<Players.LoadStockProfileImagesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzp(new StockProfileImagesLoadedBinderCallback(zzb2));
    }

    public void zza(zznt.zzb<Players.UpdateGamerProfileResult> zzb2, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new GamerProfileUpdatedBinderCallback(zzb2), string, bl, string2, bl2, bl3);
    }

    public void zzi(zznt.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzj((IGamesCallbacks)new DeletePlayerBinderCallback(zzb2), bl);
    }

    public void zzj(zznt.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzk((IGamesCallbacks)new UpdateAutoSignInBinderCallback(zzb2), bl);
    }

    public void zzk(zznt.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzl((IGamesCallbacks)new UpdateProfileDiscoverabilityBinderCallback(zzb2), bl);
    }

    public void zzb(zznt.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zznt.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zztm()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zznt.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zztm()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zznt.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zznt.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzj((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zznt.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zze(zznt.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzn(zznt.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzl(zznt.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zznt.zzb<Status> zzb2, boolean bl, boolean bl2, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bl2, bundle);
    }

    public void zzq(zznt.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zztm()).zzs(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zznt.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zznt.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zznt.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzg(zznt.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zznt.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zztm()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzAm() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zztm()).zzAm();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzb("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzai(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzaKV = bundle.getBoolean("show_welcome_popup");
            this.zzaKS = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzaKT = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zzo(zznt.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzu(new SendFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzp(zznt.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzv(new AcceptFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzq(zznt.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzw(new IgnoreFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzr(zznt.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzx(new CancelFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zze(zznt.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zztm()).zzf(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzs(zznt.zzb<Players.LoadPlayersResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zztm()).zzy(new PlayerUnfriendedBinderCallback(zzb2), string);
    }

    public void zzf(zznt.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zztm()).zzg(new SetPlayerMutedBinderCallback(zzb2), string, bl);
    }

    public void zzc(zznt.zzb<Social.LoadInvitesResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zztm()).zzb((IGamesCallbacks)new InvitesLoadedBinderCallback(zzb2), n);
    }

    public void zza(Account account, byte[] byArray) throws RemoteException {
        ((IGamesService)this.zztm()).zza(account, byArray);
    }

    public void zzd(Account account) throws RemoteException {
        ((IGamesService)this.zztm()).zzd(account);
    }

    protected /* synthetic */ IInterface zzab(IBinder iBinder) {
        return this.zzcd(iBinder);
    }

    private static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer zzaLw;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLw = new VideoBuffer(dataHolder);
        }
    }

    private static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status zzaaO;
        private final String zzE;

        CaptureStreamingUrlResultImpl(Status status, String string) {
            this.zzaaO = status;
            this.zzE = string;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public String getUrl() {
            return this.zzE;
        }
    }

    private static final class CaptureStreamingMetadataResultImpl
    implements Videos.CaptureStreamingMetadataResult {
        private final Status zzaaO;
        private final String zzavG;
        private final String zzVw;

        CaptureStreamingMetadataResultImpl(Status status, String string, String string2) {
            this.zzaaO = status;
            this.zzavG = string;
            this.zzVw = string2;
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class CaptureStreamingEnabledResultImpl
    implements Result {
        public Status getStatus() {
            return null;
        }
    }

    private static final class CaptureStreamingAvailabilityResultImpl
    implements Videos.CaptureStreamingAvailabilityResult {
        private final Status zzaaO;
        private final boolean zzaLe;
        private final boolean zzaLl;

        CaptureStreamingAvailabilityResultImpl(Status status, boolean bl, boolean bl2) {
            this.zzaaO = status;
            this.zzaLe = bl;
            this.zzaLl = bl2;
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class CaptureStoppedResultImpl
    implements Videos.CaptureStoppedResult {
        private final Status zzaaO;
        private final Uri zzaLk;

        CaptureStoppedResultImpl(Status status, Uri uri) {
            this.zzaaO = status;
            this.zzaLk = uri;
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class CaptureStateResultImpl
    implements Videos.CaptureStateResult {
        private final Status zzaaO;
        private final CaptureState zzaLj;

        CaptureStateResultImpl(Status status, CaptureState captureState) {
            this.zzaaO = status;
            this.zzaLj = captureState;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public CaptureState getCaptureState() {
            return this.zzaLj;
        }
    }

    private static final class CaptureCapabilitiesResultImpl
    implements Videos.CaptureCapabilitiesResult {
        private final Status zzaaO;
        private final VideoCapabilities zzaLf;

        CaptureCapabilitiesResultImpl(Status status, VideoCapabilities videoCapabilities) {
            this.zzaaO = status;
            this.zzaLf = videoCapabilities;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public VideoCapabilities getCapabilities() {
            return this.zzaLf;
        }
    }

    private static final class CaptureAvailableResultImpl
    implements Videos.CaptureAvailableResult {
        private final Status zzaaO;
        private final boolean zzaLe;

        CaptureAvailableResultImpl(Status status, boolean bl) {
            this.zzaaO = status;
            this.zzaLe = bl;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public boolean isAvailable() {
            return this.zzaLe;
        }
    }

    private static final class InviteUpdateResultImpl
    extends GamesDataHolderResult
    implements Social.InviteUpdateResult {
        private final SocialInvite zzaLt;

        InviteUpdateResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            try {
                this.zzaLt = socialInviteBuffer.getCount() > 0 ? new SocialInviteEntity((SocialInvite)socialInviteBuffer.get(0)) : null;
            }
            finally {
                socialInviteBuffer.release();
            }
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status zzaaO;
        private final String zzaLo;

        DeleteSnapshotResultImpl(int n, String string) {
            this.zzaaO = GamesStatusCodes.zzgs(n);
            this.zzaLo = string;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public String getSnapshotId() {
            return this.zzaLo;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzaLn;

        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzaLn = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.zzaLn;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzaLT;
        private final String zzaLU;
        private final Snapshot zzaLV;
        private final Contents zzaLW;
        private final SnapshotContents zzaLX;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents contents) {
            this(dataHolder, null, contents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzaLT = null;
                    this.zzaLV = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzb.zzai((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzaLT = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    this.zzaLV = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzaLT = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzaLV = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(contents2));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzaLU = string;
            this.zzaLW = contents3;
            this.zzaLX = new SnapshotContentsEntity(contents3);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.zzaLT;
        }

        @Override
        public String getConflictId() {
            return this.zzaLU;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.zzaLV;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzaLX;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzamz);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzaLH;

        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzaLH = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity((PlayerStats)playerStatsBuffer.get(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.zzaLH;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> zzaLy;

        LoadAppContentsResultImpl(DataHolder[] dataHolderArray) {
            super(dataHolderArray[0]);
            this.zzaLy = new ArrayList<DataHolder>(Arrays.asList(dataHolderArray));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzaLm;
        private final Quest zzaLb;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzaLb = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzaLb.zzBv();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzaLm = list.get(i);
                        return;
                    }
                    this.zzaLm = null;
                } else {
                    this.zzaLm = null;
                    this.zzaLb = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.zzaLm;
        }

        @Override
        public Quest getQuest() {
            return this.zzaLb;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest zzaLb;

        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzaLb = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.zzaLb;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zzamz;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzamz = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zzamz);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status zzaaO;
        private final Bundle zzaLJ;

        LoadRequestsResultImpl(Status status, Bundle bundle) {
            this.zzaaO = status;
            this.zzaLJ = bundle;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public GameRequestBuffer getRequests(int n) {
            String string = RequestType.zzgS(n);
            if (!this.zzaLJ.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzaLJ.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.zzaLJ.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzaLJ.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes zzaMA;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaMA = RequestUpdateOutcomes.zzal(dataHolder);
        }

        @Override
        public int getRequestOutcome(String string) {
            return this.zzaMA.getRequestOutcome(string);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.zzaMA.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest zzaMg;

        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.zzaMg = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status zzaaO;
        private final Bundle zzaLr;

        InboxCountResultImpl(Status status, Bundle bundle) {
            this.zzaaO = status;
            this.zzaLr = bundle;
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class GetServerAuthCodeResultImpl
    implements Games.GetServerAuthCodeResult {
        private final Status zzaaO;
        private final String zzaLq;

        GetServerAuthCodeResultImpl(Status status, String string) {
            this.zzaaO = status;
            this.zzaLq = string;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public String getCode() {
            return this.zzaLq;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status zzaaO;
        private final String zzabf;

        GetTokenResultImpl(Status status, String string) {
            this.zzaaO = status;
            this.zzabf = string;
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status zzaaO;
        private final String zzaLp;
        private final boolean zzST;

        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.zzaaO = GamesStatusCodes.zzgs(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.zzaLp = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzST = dataHolder.zze("muted", 0, 0);
                } else {
                    this.zzaLp = null;
                    this.zzST = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status zzaaO;
        private final String zzaLp;
        private final boolean zzST;

        public GameMuteStatusChangeResultImpl(int n, String string, boolean bl) {
            this.zzaaO = GamesStatusCodes.zzgs(n);
            this.zzaLp = string;
            this.zzST = bl;
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zzaaO;
        private final String zzaLd;

        CancelMatchResultImpl(Status status, String string) {
            this.zzaaO = status;
            this.zzaLd = string;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public String getMatchId() {
            return this.zzaLd;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch zzaLR;

        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzaLR = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzaLR;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzaMs;

        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzaMs = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.zzaMs;
        }
    }

    private static final class UpdateGamerProfileResultImpl
    implements Players.UpdateGamerProfileResult {
        private final Status zzaaO;
        private final Bundle zzaMz;

        UpdateGamerProfileResultImpl(int n, Bundle bundle) {
            this.zzaaO = new Status(n);
            this.zzaMz = bundle;
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class LoadStockProfileImagesResultImpl
    extends GamesDataHolderResult
    implements Players.LoadStockProfileImagesResult {
        private final StockProfileImageBuffer zzaLM;

        LoadStockProfileImagesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLM = new StockProfileImageBuffer(dataHolder);
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer zzaLP;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLP = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status zzaaO;
        private final List<String> zzaLN;
        private final Bundle zzaLO;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle bundle) {
            this.zzaaO = status;
            this.zzaLN = bundle.getStringArrayList("game_category_list");
            this.zzaLO = bundle;
        }

        public Status getStatus() {
            return this.zzaaO;
        }
    }

    private static final class LoadInvitesResultImpl
    extends GamesDataHolderResult
    implements Social.LoadInvitesResult {
        private final SocialInviteBuffer zzaLE;

        LoadInvitesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLE = new SocialInviteBuffer(dataHolder);
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzaLI;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLI = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.zzaLI;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zzaaO;
        private final LoadMatchesResponse zzaLF;

        LoadMatchesResultImpl(Status status, Bundle bundle) {
            this.zzaaO = status;
            this.zzaLF = new LoadMatchesResponse(bundle);
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.zzaLF;
        }

        public void release() {
            this.zzaLF.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzaLD;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLD = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.zzaLD;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzaLG;

        LoadPlayerScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzaLG = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.zzaLG;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzaLK;
        private final LeaderboardScoreBuffer zzaLL;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzaLK = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzaLL = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.zzaLK;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.zzaLL;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzaLu;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLu = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.zzaLu;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer zzaLB;

        LoadGameSearchSuggestionsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLB = new GameSearchSuggestionBuffer(dataHolder);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer zzaLA;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLA = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzaLC;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLC = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.zzaLC;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer zzaLz;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLz = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.zzaLz;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status zzaaO;
        private final String zzaKb;

        UpdateAchievementResultImpl(int n, String string) {
            this.zzaaO = GamesStatusCodes.zzgs(n);
            this.zzaKb = string;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public String getAchievementId() {
            return this.zzaKb;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzaLx;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaLx = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.zzaLx;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzoa {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzgs(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzou.zzb<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzahG;
        private final String zzaMd;
        private final int zzaMe;

        RealTimeMessageSentNotifier(int n, int n2, String string) {
            this.zzahG = n;
            this.zzaMe = n2;
            this.zzaMd = string;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.zzahG, this.zzaMe, this.zzaMd);
            }
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzou.zzb<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzaLS;

        MessageReceivedNotifier(RealTimeMessage realTimeMessage) {
            this.zzaLS = realTimeMessage;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.zzaLS);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzou.zzb<RoomStatusUpdateListener> {
        private final String zzaLY;

        P2PDisconnectedNotifier(String string) {
            this.zzaLY = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.zzaLY);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzou.zzb<RoomStatusUpdateListener> {
        private final String zzaLY;

        P2PConnectedNotifier(String string) {
            this.zzaLY = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.zzaLY);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzou.zzb<RoomUpdateListener> {
        private final int zzahG;
        private final String zzaLv;

        LeftRoomNotifier(int n, String string) {
            this.zzahG = n;
            this.zzaLv = string;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.zzahG, this.zzaLv);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> zzaLa = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzaLa.add(stringArray[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzaLa);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zznz<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzai(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zznz<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzai(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzou.zzb<OnNearbyPlayerDetectedListener> {
        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(null);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class SocialInviteRemovedNotifier
    implements zzou.zzb<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite zzaMr;

        SocialInviteRemovedNotifier(SocialInvite socialInvite) {
            this.zzaMr = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zzb(this.zzaMr);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class SocialInviteUpdateReceivedNotifier
    implements zzou.zzb<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite zzaMr;

        SocialInviteUpdateReceivedNotifier(SocialInvite socialInvite) {
            this.zzaMr = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zza(this.zzaMr);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzou.zzb<OnRequestReceivedListener> {
        private final String zzII;

        RequestRemovedNotifier(String string) {
            this.zzII = string;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzII);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzou.zzb<OnRequestReceivedListener> {
        private final GameRequest zzaMg;

        RequestReceivedNotifier(GameRequest gameRequest) {
            this.zzaMg = gameRequest;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.zzaMg);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzou.zzb<QuestUpdateListener> {
        private final Quest zzaLb;

        QuestCompletedNotifier(Quest quest) {
            this.zzaLb = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.zzaLb);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzou.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzaLQ;

        MatchRemovedNotifier(String string) {
            this.zzaLQ = string;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.zzaLQ);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzou.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzaLR;

        MatchUpdateReceivedNotifier(TurnBasedMatch turnBasedMatch) {
            this.zzaLR = turnBasedMatch;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.zzaLR);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzou.zzb<OnInvitationReceivedListener> {
        private final String zzaaF;

        InvitationRemovedNotifier(String string) {
            this.zzaaF = string;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.zzaaF);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzou.zzb<OnInvitationReceivedListener> {
        private final Invitation zzaLs;

        InvitationReceivedNotifier(Invitation invitation) {
            this.zzaLs = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.zzaLs);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class CaptureOverlayStateChangedNotifier
    implements zzou.zzb<Videos.CaptureOverlayStateListener> {
        private final int zzaLh;

        CaptureOverlayStateChangedNotifier(int n) {
            this.zzaLh = n;
        }

        public void zza(Videos.CaptureOverlayStateListener captureOverlayStateListener) {
            captureOverlayStateListener.onCaptureOverlayStateChanged(this.zzaLh);
        }

        public void zzrV() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((Videos.CaptureOverlayStateListener)object);
        }
    }

    private static final class SetPlayerMutedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Players.LoadPlayersResult> zzasz;

        SetPlayerMutedBinderCallback(zznt.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzag(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class PlayerUnfriendedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Players.LoadPlayersResult> zzasz;

        PlayerUnfriendedBinderCallback(zznt.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaf(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class CancelFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Social.InviteUpdateResult> zzasz;

        CancelFriendInviteFirstPartyBinderCallback(zznt.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzae(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class IgnoreFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Social.InviteUpdateResult> zzasz;

        IgnoreFriendInviteFirstPartyBinderCallback(zznt.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzad(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class AcceptFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Social.InviteUpdateResult> zzasz;

        AcceptFriendInviteFirstPartyBinderCallback(zznt.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaa(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class SendFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Social.InviteUpdateResult> zzasz;

        SendFriendInviteFirstPartyBinderCallback(zznt.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzZ(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class UpdateHeadlessCapturePermissionBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        UpdateHeadlessCapturePermissionBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzae(Status status) {
            this.zzasz.setResult((Object)status);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Videos.ListVideosResult> zzasz;

        ListVideosBinderCallback(zznt.zzb<Videos.ListVideosResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzX(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class CaptureStreamingUrlBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Videos.CaptureStreamingUrlResult> zzasz;

        CaptureStreamingUrlBinderCallback(zznt.zzb<Videos.CaptureStreamingUrlResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(int n, String string) {
            this.zzasz.setResult((Object)new CaptureStreamingUrlResultImpl(new Status(n), string));
        }
    }

    private static final class CaptureStreamingMetadataBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Videos.CaptureStreamingMetadataResult> zzasz;

        CaptureStreamingMetadataBinderCallback(zznt.zzb<Videos.CaptureStreamingMetadataResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, String string, String string2) {
            this.zzasz.setResult((Object)new CaptureStreamingMetadataResultImpl(new Status(n), string, string2));
        }
    }

    private static final class CaptureStreamingEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        CaptureStreamingEnabledBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzgH(int n) {
            this.zzasz.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureStreamingAvailabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Videos.CaptureStreamingAvailabilityResult> zzasz;

        CaptureStreamingAvailabilityBinderCallback(zznt.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, boolean bl, boolean bl2) {
            this.zzasz.setResult((Object)new CaptureStreamingAvailabilityResultImpl(new Status(n), bl, bl2));
        }
    }

    private static final class CaptureStoppedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Videos.CaptureStoppedResult> zzasz;

        public CaptureStoppedBinderCallbacks(zznt.zzb<Videos.CaptureStoppedResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, Uri uri) {
            this.zzasz.setResult((Object)new CaptureStoppedResultImpl(new Status(n), uri));
        }
    }

    private static final class CaptureStateBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Videos.CaptureStateResult> zzasz;

        public CaptureStateBinderCallbacks(zznt.zzb<Videos.CaptureStateResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            this.zzasz.setResult((Object)new CaptureStateResultImpl(new Status(n), CaptureState.zzy(bundle)));
        }
    }

    private static final class CaptureStartedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;
        private final Videos.CaptureRuntimeErrorCallback zzaLi;

        public CaptureStartedBinderCallbacks(zznt.zzb<Status> zzb2, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
            this.zzaLi = (Videos.CaptureRuntimeErrorCallback)zzaa.zzb((Object)captureRuntimeErrorCallback, (Object)"Callback must not be null");
        }

        @Override
        public void zzaf(Status status) {
            this.zzasz.setResult((Object)status);
        }

        @Override
        public void zzgL(int n) {
            this.zzaLi.zzhD(n);
        }
    }

    private static final class CapturePausedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        public CapturePausedBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzgM(int n) {
            this.zzasz.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureOverlayStateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzou<Videos.CaptureOverlayStateListener> zzaxJ;

        CaptureOverlayStateBinderCallback(zzou<Videos.CaptureOverlayStateListener> zzou2) {
            this.zzaxJ = (zzou)zzaa.zzb(zzou2, (Object)"Callback must not be null");
        }

        @Override
        public void onCaptureOverlayStateChanged(int n) {
            this.zzaxJ.zza((zzou.zzb)new CaptureOverlayStateChangedNotifier(n));
        }
    }

    private static final class CaptureLaunchGameAndOverlayBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> zzaLg;

        CaptureLaunchGameAndOverlayBinderCallback(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl) {
            this.zzaLg = (Games.BaseGamesApiMethodImpl)((Object)zzaa.zzb(baseGamesApiMethodImpl, (Object)"Holder must not be null"));
        }

        @Override
        public void zzgG(int n) {
            this.zzaLg.zzb((Result)new Status(n));
        }

        @Override
        public void zzac(Status status) {
            this.zzaLg.zzb((Result)status);
        }
    }

    private static final class CaptureCapabilitiesBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Videos.CaptureCapabilitiesResult> zzasz;

        CaptureCapabilitiesBinderCallback(zznt.zzb<Videos.CaptureCapabilitiesResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzasz.setResult((Object)new CaptureCapabilitiesResultImpl(new Status(n), videoCapabilities));
        }
    }

    private static final class CaptureAvailableBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Videos.CaptureAvailableResult> zzasz;

        CaptureAvailableBinderCallback(zznt.zzb<Videos.CaptureAvailableResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, boolean bl) {
            this.zzasz.setResult((Object)new CaptureAvailableResultImpl(new Status(n), bl));
        }
    }

    private static final class HeadlessCaptureEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        HeadlessCaptureEnabledBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzad(Status status) {
            this.zzasz.setResult((Object)status);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Snapshots.DeleteSnapshotResult> zzasz;

        public SnapshotDeletedBinderCallbacks(zznt.zzb<Snapshots.DeleteSnapshotResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(int n, String string) {
            this.zzasz.setResult((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Snapshots.CommitSnapshotResult> zzaMo;

        public SnapshotCommittedBinderCallbacks(zznt.zzb<Snapshots.CommitSnapshotResult> zzb2) {
            this.zzaMo = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzO(DataHolder dataHolder) {
            this.zzaMo.setResult((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Snapshots.OpenSnapshotResult> zzaMp;

        public SnapshotOpenedBinderCallbacks(zznt.zzb<Snapshots.OpenSnapshotResult> zzb2) {
            this.zzaMp = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.zzaMp.setResult((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.zzaMp.setResult((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Snapshots.LoadSnapshotsResult> zzaMq;

        public SnapshotsLoadedBinderCallbacks(zznt.zzb<Snapshots.LoadSnapshotsResult> zzb2) {
            this.zzaMq = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzN(DataHolder dataHolder) {
            this.zzaMq.setResult((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Stats.LoadPlayerStatsResult> zzasz;

        public PlayerStatsLoadedBinderCallbacks(zznt.zzb<Stats.LoadPlayerStatsResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzW(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<AppContents.LoadAppContentResult> zzaLc;

        public AppContentLoadedBinderCallbacks(zznt.zzb<AppContents.LoadAppContentResult> zzb2) {
            this.zzaLc = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.zzaLc.setResult((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Quests.LoadQuestsResult> zzaMc;

        public QuestsLoadedBinderCallbacks(zznt.zzb<Quests.LoadQuestsResult> zzb2) {
            this.zzaMc = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzT(DataHolder dataHolder) {
            this.zzaMc.setResult((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Quests.ClaimMilestoneResult> zzaMa;
        private final String zzaMb;

        public QuestMilestoneClaimBinderCallbacks(zznt.zzb<Quests.ClaimMilestoneResult> zzb2, String string) {
            this.zzaMa = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
            this.zzaMb = (String)zzaa.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzP(DataHolder dataHolder) {
            this.zzaMa.setResult((Object)new ClaimMilestoneResultImpl(dataHolder, this.zzaMb));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Quests.AcceptQuestResult> zzaLZ;

        public QuestAcceptedBinderCallbacks(zznt.zzb<Quests.AcceptQuestResult> zzb2) {
            this.zzaLZ = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzQ(DataHolder dataHolder) {
            this.zzaLZ.setResult((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Requests.LoadRequestSummariesResult> zzaMi;

        public RequestSummariesLoadedBinderCallbacks(zznt.zzb<Requests.LoadRequestSummariesResult> zzb2) {
            this.zzaMi = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzM(DataHolder dataHolder) {
            this.zzaMi.setResult((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Requests.LoadRequestsResult> zzaMj;

        public RequestsLoadedBinderCallbacks(zznt.zzb<Requests.LoadRequestsResult> zzb2) {
            this.zzaMj = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzgs(n);
            this.zzaMj.setResult((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Requests.SendRequestResult> zzaMh;

        public RequestSentBinderCallbacks(zznt.zzb<Requests.SendRequestResult> zzb2) {
            this.zzaMh = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzL(DataHolder dataHolder) {
            this.zzaMh.setResult((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Requests.UpdateRequestsResult> zzaMk;

        public RequestsUpdatedBinderCallbacks(zznt.zzb<Requests.UpdateRequestsResult> zzb2) {
            this.zzaMk = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzK(DataHolder dataHolder) {
            this.zzaMk.setResult((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager zzaKU;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.zzaKU = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzzL() {
            return new PopupLocationInfoParcelable(this.zzaKU.zzAE());
        }
    }

    private static final class GetServerAuthCodeBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Games.GetServerAuthCodeResult> zzasz;

        public GetServerAuthCodeBinderCallbacks(zznt.zzb<Games.GetServerAuthCodeResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzgs(n);
            this.zzasz.setResult((Object)new GetServerAuthCodeResultImpl(status, string));
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Games.GetTokenResult> zzasz;

        public GetAuthTokenBinderCallbacks(zznt.zzb<Games.GetTokenResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzgs(n);
            this.zzasz.setResult((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        public SignOutCompleteBinderCallbacks(zznt.zzb<Status> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzzK() {
            Status status = GamesStatusCodes.zzgs(0);
            this.zzasz.setResult((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Notifications.InboxCountResult> zzasz;

        InboxCountsLoadedBinderCallback(zznt.zzb<Notifications.InboxCountResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzgs(n);
            this.zzasz.setResult((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        ContactSettingsUpdatedBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzgE(int n) {
            this.zzasz.setResult((Object)GamesStatusCodes.zzgs(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Notifications.ContactSettingLoadResult> zzasz;

        ContactSettingsLoadedBinderCallback(zznt.zzb<Notifications.ContactSettingLoadResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzI(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Notifications.GameMuteStatusLoadResult> zzasz;

        GameMuteStatusLoadedBinderCallback(zznt.zzb<Notifications.GameMuteStatusLoadResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzG(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Notifications.GameMuteStatusChangeResult> zzasz;

        GameMuteStatusChangedBinderCallback(zznt.zzb<Notifications.GameMuteStatusChangeResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zzasz.setResult((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzou<RealTimeMultiplayer.ReliableMessageSentCallback> zzaMf;

        public RealTimeReliableMessageBinderCallbacks(zzou<RealTimeMultiplayer.ReliableMessageSentCallback> zzou2) {
            this.zzaMf = zzou2;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.zzaMf != null) {
                this.zzaMf.zza((zzou.zzb)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzou<? extends RoomUpdateListener> zzaMl;
        private final zzou<? extends RoomStatusUpdateListener> zzaMm;
        private final zzou<RealTimeMessageReceivedListener> zzaMn;

        public RoomBinderCallbacks(zzou<RoomUpdateListener> zzou2) {
            this.zzaMl = (zzou)zzaa.zzb(zzou2, (Object)"Callbacks must not be null");
            this.zzaMm = null;
            this.zzaMn = null;
        }

        public RoomBinderCallbacks(zzou<? extends RoomUpdateListener> zzou2, zzou<? extends RoomStatusUpdateListener> zzou3, zzou<RealTimeMessageReceivedListener> zzou4) {
            this.zzaMl = (zzou)zzaa.zzb(zzou2, (Object)"Callbacks must not be null");
            this.zzaMm = zzou3;
            this.zzaMn = zzou4;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.zzaMl.zza((zzou.zzb)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzA(DataHolder dataHolder) {
            this.zzaMl.zza((zzou.zzb)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int n, String string) {
            this.zzaMl.zza((zzou.zzb)new LeftRoomNotifier(n, string));
        }

        @Override
        public void zzD(DataHolder dataHolder) {
            this.zzaMl.zza((zzou.zzb)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzB(DataHolder dataHolder) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzC(DataHolder dataHolder) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzE(DataHolder dataHolder) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzF(DataHolder dataHolder) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String string) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new P2PConnectedNotifier(string));
            }
        }

        @Override
        public void onP2PDisconnected(String string) {
            if (this.zzaMm != null) {
                this.zzaMm.zza((zzou.zzb)new P2PDisconnectedNotifier(string));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzaMn != null) {
                this.zzaMn.zza((zzou.zzb)new MessageReceivedNotifier(realTimeMessage));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<TurnBasedMultiplayer.CancelMatchResult> zzaMt;

        public TurnBasedMatchCanceledBinderCallbacks(zznt.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2) {
            this.zzaMt = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            Status status = GamesStatusCodes.zzgs(n);
            this.zzaMt.setResult((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzaMv;

        public TurnBasedMatchLeftBinderCallbacks(zznt.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2) {
            this.zzaMv = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.zzaMv.setResult((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzaMx;

        public TurnBasedMatchUpdatedBinderCallbacks(zznt.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2) {
            this.zzaMx = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.zzaMx.setResult((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzaMu;

        public TurnBasedMatchInitiatedBinderCallbacks(zznt.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2) {
            this.zzaMu = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.zzaMu.setResult((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<TurnBasedMultiplayer.LoadMatchResult> zzaMw;

        public TurnBasedMatchLoadedBinderCallbacks(zznt.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2) {
            this.zzaMw = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.zzaMw.setResult((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzaMy;

        public TurnBasedMatchesLoadedBinderCallbacks(zznt.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2) {
            this.zzaMy = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzgs(n);
            this.zzaMy.setResult((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Leaderboards.SubmitScoreResult> zzasz;

        public SubmitScoreBinderCallbacks(zznt.zzb<Leaderboards.SubmitScoreResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class UpdateProfileDiscoverabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        UpdateProfileDiscoverabilityBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zzgK(int n) {
            this.zzasz.setResult((Object)new Status(n));
        }
    }

    private static final class UpdateAutoSignInBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        UpdateAutoSignInBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zzgJ(int n) {
            this.zzasz.setResult((Object)new Status(n));
        }
    }

    private static final class DeletePlayerBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        DeletePlayerBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zzgI(int n) {
            this.zzasz.setResult((Object)new Status(n));
        }
    }

    private static final class GamerProfileUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Players.UpdateGamerProfileResult> zzasz;

        GamerProfileUpdatedBinderCallback(zznt.zzb<Players.UpdateGamerProfileResult> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            this.zzasz.setResult((Object)new UpdateGamerProfileResultImpl(n, bundle));
        }
    }

    private static final class StockProfileImagesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Players.LoadStockProfileImagesResult> zzasz;

        StockProfileImagesLoadedBinderCallback(zznt.zzb<Players.LoadStockProfileImagesResult> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zzY(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadStockProfileImagesResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Status> zzasz;

        ProfileSettingsUpdatedBinderCallback(zznt.zzb<Status> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzgF(int n) {
            this.zzasz.setResult((Object)GamesStatusCodes.zzgs(n));
        }
    }

    private static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Players.LoadProfileSettingsResult> zzasz;

        ProfileSettingsLoadedBinderCallback(zznt.zzb<Players.LoadProfileSettingsResult> zzb2) {
            this.zzasz = zzb2;
        }

        @Override
        public void zzV(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new ProfileSettingsEntity(dataHolder));
            dataHolder.close();
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Players.LoadXpStreamResult> zzasz;

        PlayerXpStreamLoadedBinderCallback(zznt.zzb<Players.LoadXpStreamResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzU(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Players.LoadXpForGameCategoriesResult> zzasz;

        PlayerXpForGameCategoriesLoadedBinderCallback(zznt.zzb<Players.LoadXpForGameCategoriesResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzgs(n);
            this.zzasz.setResult((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class InvitesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Social.LoadInvitesResult> zzasz;

        InvitesLoadedBinderCallback(zznt.zzb<Social.LoadInvitesResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzah(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadInvitesResultImpl(dataHolder));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Players.LoadPlayersResult> zzasz;

        PlayersLoadedBinderCallback(zznt.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class SocialInviteUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzab(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzou.zzb)new SocialInviteUpdateReceivedNotifier(socialInvite));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzac(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzou.zzb)new SocialInviteRemovedNotifier(socialInvite));
            }
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzou<OnRequestReceivedListener> zzaxJ;

        RequestReceivedBinderCallback(zzou<OnRequestReceivedListener> zzou2) {
            this.zzaxJ = zzou2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzaxJ.zza((zzou.zzb)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String string) {
            this.zzaxJ.zza((zzou.zzb)new RequestRemovedNotifier(string));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzou<QuestUpdateListener> zzaxJ;

        QuestUpdateBinderCallback(zzou<QuestUpdateListener> zzou2) {
            this.zzaxJ = zzou2;
        }

        @Override
        public void zzR(DataHolder dataHolder) {
            Quest quest = this.zzak(dataHolder);
            if (quest != null) {
                this.zzaxJ.zza((zzou.zzb)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzak(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzou<OnTurnBasedMatchUpdateReceivedListener> zzaxJ;

        MatchUpdateReceivedBinderCallback(zzou<OnTurnBasedMatchUpdateReceivedListener> zzou2) {
            this.zzaxJ = zzou2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzaxJ.zza((zzou.zzb)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String string) {
            this.zzaxJ.zza((zzou.zzb)new MatchRemovedNotifier(string));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzou<OnInvitationReceivedListener> zzaxJ;

        InvitationReceivedBinderCallback(zzou<OnInvitationReceivedListener> zzou2) {
            this.zzaxJ = zzou2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzaxJ.zza((zzou.zzb)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String string) {
            this.zzaxJ.zza((zzou.zzb)new InvitationRemovedNotifier(string));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Invitations.LoadInvitationsResult> zzasz;

        InvitationsLoadedBinderCallback(zznt.zzb<Invitations.LoadInvitationsResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Leaderboards.LoadPlayerScoreResult> zzasz;

        PlayerLeaderboardScoreLoadedBinderCallback(zznt.zzb<Leaderboards.LoadPlayerScoreResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzJ(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Leaderboards.LoadScoresResult> zzasz;

        LeaderboardScoresLoadedBinderCallback(zznt.zzb<Leaderboards.LoadScoresResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzasz.setResult((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Leaderboards.LeaderboardMetadataResult> zzasz;

        LeaderboardsLoadedBinderCallback(zznt.zzb<Leaderboards.LeaderboardMetadataResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzasz;

        GameSearchSuggestionsLoadedBinderCallback(zznt.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<GamesMetadata.LoadGameInstancesResult> zzasz;

        GameInstancesLoadedBinderCallback(zznt.zzb<GamesMetadata.LoadGameInstancesResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Events.LoadEventsResult> zzasz;

        EventsLoadedBinderCallback(zznt.zzb<Events.LoadEventsResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<GamesMetadata.LoadGamesResult> zzasz;

        GamesLoadedBinderCallback(zznt.zzb<GamesMetadata.LoadGamesResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Achievements.UpdateAchievementResult> zzasz;

        AchievementUpdatedBinderCallback(zznt.zzb<Achievements.UpdateAchievementResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            this.zzasz.setResult((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zznt.zzb<Achievements.LoadAchievementsResult> zzasz;

        AchievementsLoadedBinderCallback(zznt.zzb<Achievements.LoadAchievementsResult> zzb2) {
            this.zzasz = (zznt.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zzasz.setResult((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzq(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zztm()).zzn(string, n);
                } else {
                    GamesLog.zzE("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

