/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzou;

public final class QuestsImpl
implements Quests {
    @Override
    public Intent getQuestsIntent(GoogleApiClient googleApiClient, int[] nArray) {
        return Games.zzh(googleApiClient).zzb(nArray);
    }

    @Override
    public Intent getQuestIntent(GoogleApiClient googleApiClient, String string) {
        return Games.zzh(googleApiClient).zzej(string);
    }

    @Override
    public void registerQuestUpdateListener(GoogleApiClient googleApiClient, QuestUpdateListener questUpdateListener) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            zzou zzou2 = googleApiClient.zzs((Object)questUpdateListener);
            gamesClientImpl.zzc((zzou<QuestUpdateListener>)zzou2);
        }
    }

    @Override
    public void unregisterQuestUpdateListener(GoogleApiClient googleApiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzzY();
        }
    }

    @Override
    public PendingResult<Quests.AcceptQuestResult> accept(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzd((zznt.zza)new AcceptImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzh((zznt.zzb<Quests.AcceptQuestResult>)this, string);
            }
        });
    }

    @Override
    public PendingResult<Quests.ClaimMilestoneResult> claim(GoogleApiClient googleApiClient, final String string, final String string2) {
        return googleApiClient.zzd((zznt.zza)new ClaimImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zznt.zzb<Quests.ClaimMilestoneResult>)this, string, string2);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> load(GoogleApiClient googleApiClient, final int[] nArray, final int n, final boolean bl) {
        return googleApiClient.zzc((zznt.zza)new LoadsImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zznt.zzb<Quests.LoadQuestsResult>)this, nArray, n, bl);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> loadByIds(GoogleApiClient googleApiClient, final boolean bl, final String ... stringArray) {
        return googleApiClient.zzc((zznt.zza)new LoadsImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zznt.zzb<Quests.LoadQuestsResult>)this, bl, stringArray);
            }
        });
    }

    @Override
    public void showStateChangedPopup(GoogleApiClient googleApiClient, String string) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzek(string);
        }
    }

    private static abstract class LoadsImpl
    extends Games.BaseGamesApiMethodImpl<Quests.LoadQuestsResult> {
        private LoadsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.LoadQuestsResult zzaE(final Status status) {
            return new Quests.LoadQuestsResult(){

                public void release() {
                }

                public Status getStatus() {
                    return status;
                }

                @Override
                public QuestBuffer getQuests() {
                    int n = status.getStatusCode();
                    return new QuestBuffer(DataHolder.zzbQ((int)n));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaE(status);
        }
    }

    private static abstract class ClaimImpl
    extends Games.BaseGamesApiMethodImpl<Quests.ClaimMilestoneResult> {
        private ClaimImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.ClaimMilestoneResult zzaD(final Status status) {
            return new Quests.ClaimMilestoneResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Milestone getMilestone() {
                    return null;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaD(status);
        }
    }

    private static abstract class AcceptImpl
    extends Games.BaseGamesApiMethodImpl<Quests.AcceptQuestResult> {
        private AcceptImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.AcceptQuestResult zzaC(final Status status) {
            return new Quests.AcceptQuestResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaC(status);
        }
    }
}

