/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.player;

import android.net.Uri;
import android.os.Parcel;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.player.ProfileSettingsEntityCreator;
import com.google.android.gms.games.internal.player.StockProfileImage;
import com.google.android.gms.games.internal.player.StockProfileImageEntity;

public class ProfileSettingsEntity
extends AbstractSafeParcelable
implements Players.LoadProfileSettingsResult {
    public static final ProfileSettingsEntityCreator CREATOR = new ProfileSettingsEntityCreator();
    private final int mVersionCode;
    private final Status zzaaO;
    private final String zzaJL;
    private final boolean zzaPT;
    private final boolean zzaJJ;
    private final boolean zzaPU;
    private final StockProfileImageEntity zzaPV;
    private final boolean zzaPW;
    private final boolean zzaPX;

    public ProfileSettingsEntity(DataHolder dataHolder) {
        this.mVersionCode = 3;
        this.zzaaO = new Status(dataHolder.getStatusCode());
        if (this.zzaaO.isSuccess() && dataHolder.getCount() > 0) {
            int n = dataHolder.zzbP(0);
            this.zzaJL = dataHolder.zzd("gamer_tag", 0, n);
            this.zzaPT = dataHolder.zze("gamer_tag_explicitly_set", 0, n);
            this.zzaJJ = dataHolder.zze("profile_visible", 0, n);
            this.zzaPU = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
            String string = dataHolder.zzd("stock_avatar_url", 0, n);
            String string2 = dataHolder.zzd("stock_avatar_uri", 0, n);
            this.zzaPV = !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) ? new StockProfileImageEntity(string, Uri.parse((String)string2)) : null;
            this.zzaPW = dataHolder.zze("profile_discoverable", 0, n);
            this.zzaPX = dataHolder.zze("auto_sign_in", 0, n);
        } else {
            this.zzaJL = null;
            this.zzaPT = false;
            this.zzaJJ = false;
            this.zzaPU = false;
            this.zzaPV = null;
            this.zzaPW = false;
            this.zzaPX = false;
        }
    }

    ProfileSettingsEntity(int n, Status status, String string, boolean bl, boolean bl2, boolean bl3, StockProfileImageEntity stockProfileImageEntity, boolean bl4, boolean bl5) {
        this.mVersionCode = n;
        this.zzaaO = status;
        this.zzaJL = string;
        this.zzaPT = bl;
        this.zzaJJ = bl2;
        this.zzaPU = bl3;
        this.zzaPV = stockProfileImageEntity;
        this.zzaPW = bl4;
        this.zzaPX = bl5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String zzyQ() {
        return this.zzaJL;
    }

    @Override
    public boolean zzza() {
        return this.zzaPT;
    }

    @Override
    public boolean zzyT() {
        return this.zzaJJ;
    }

    @Override
    public boolean zzyY() {
        return this.zzaPU;
    }

    @Override
    public StockProfileImage zzyZ() {
        return this.zzaPV;
    }

    @Override
    public boolean zzzb() {
        return this.zzaPW;
    }

    @Override
    public boolean zzzc() {
        return this.zzaPX;
    }

    public Status getStatus() {
        return this.zzaaO;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaJL, this.zzaPT, this.zzaJJ, this.zzaPU, this.zzaaO, this.zzaPV, this.zzaPW, this.zzaPX});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Players.LoadProfileSettingsResult)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Players.LoadProfileSettingsResult loadProfileSettingsResult = (Players.LoadProfileSettingsResult)object;
        return zzz.equal((Object)this.zzaJL, (Object)loadProfileSettingsResult.zzyQ()) && zzz.equal((Object)this.zzaPT, (Object)loadProfileSettingsResult.zzza()) && zzz.equal((Object)this.zzaJJ, (Object)loadProfileSettingsResult.zzyT()) && zzz.equal((Object)this.zzaPU, (Object)loadProfileSettingsResult.zzyY()) && zzz.equal((Object)this.zzaaO, (Object)loadProfileSettingsResult.getStatus()) && zzz.equal((Object)this.zzaPV, (Object)loadProfileSettingsResult.zzyZ()) && zzz.equal((Object)this.zzaPW, (Object)loadProfileSettingsResult.zzzb()) && zzz.equal((Object)this.zzaPX, (Object)loadProfileSettingsResult.zzzc());
    }

    public String toString() {
        return zzz.zzy((Object)this).zzg("GamerTag", (Object)this.zzaJL).zzg("IsGamerTagExplicitlySet", (Object)this.zzaPT).zzg("IsProfileVisible", (Object)this.zzaJJ).zzg("IsVisibilityExplicitlySet", (Object)this.zzaPU).zzg("Status", (Object)this.zzaaO).zzg("StockProfileImage", (Object)this.zzaPV).zzg("IsProfileDiscoverable", (Object)this.zzaPW).zzg("AutoSignIn", (Object)this.zzaPX).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ProfileSettingsEntityCreator.zza(this, parcel, n);
    }
}

