/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntity;
import java.util.ArrayList;

public final class TurnBasedMatchRef
extends zzc
implements TurnBasedMatch {
    private final Game zzaQf;
    private final int zzaKH;

    TurnBasedMatchRef(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.zzaQf = new GameRef(dataHolder, n);
        this.zzaKH = n2;
    }

    @Override
    public Game getGame() {
        return this.zzaQf;
    }

    @Override
    public String getMatchId() {
        return this.getString("external_match_id");
    }

    @Override
    public String getCreatorId() {
        return this.getString("creator_external");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    @Override
    public int getTurnStatus() {
        return this.getInteger("user_match_status");
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("description", charArrayBuffer);
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.getString("description_participant_id");
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.zzaKH);
        for (int i = 0; i < this.zzaKH; ++i) {
            arrayList.add(new ParticipantRef(this.zzamz, this.zzapa + i));
        }
        return arrayList;
    }

    @Override
    public String getLastUpdaterId() {
        return this.getString("last_updater_external");
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.getLong("last_updated_timestamp");
    }

    @Override
    public String getPendingParticipantId() {
        return this.getString("pending_participant_external");
    }

    @Override
    public byte[] getData() {
        return this.getByteArray("data");
    }

    @Override
    public int getVersion() {
        return this.getInteger("version");
    }

    @Override
    public String getRematchId() {
        return this.getString("rematch_id");
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.getByteArray("previous_match_data");
    }

    @Override
    public int getMatchNumber() {
        return this.getInteger("match_number");
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return null;
        }
        int n = this.getInteger("automatch_min_players");
        int n2 = this.getInteger("automatch_max_players");
        long l = this.getLong("automatch_bit_mask");
        return TurnBasedMatchConfig.createAutoMatchCriteria(n, n2, l);
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return 0;
        }
        return this.getInteger("automatch_max_players");
    }

    @Override
    public boolean canRematch() {
        return this.getTurnStatus() == 3 && this.getRematchId() == null && this.getParticipants().size() > 1;
    }

    @Override
    public boolean isLocallyModified() {
        return this.getBoolean("upsync_required");
    }

    @Override
    public int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    public TurnBasedMatch freeze() {
        return new TurnBasedMatchEntity(this);
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    public boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        TurnBasedMatchEntity turnBasedMatchEntity = (TurnBasedMatchEntity)((TurnBasedMatch)this.freeze());
        turnBasedMatchEntity.writeToParcel(parcel, n);
    }
}

