/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
extends AbstractSafeParcelable
implements Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new MilestoneEntityCreator();
    private final int mVersionCode;
    private final String zzaMb;
    private final long zzaRv;
    private final long zzaRw;
    private final byte[] zzaRx;
    private final int mState;
    private final String zzaKM;

    public MilestoneEntity(Milestone milestone) {
        this.mVersionCode = 4;
        this.zzaMb = milestone.getMilestoneId();
        this.zzaRv = milestone.getCurrentProgress();
        this.zzaRw = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.zzaKM = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.zzaRx = null;
        } else {
            this.zzaRx = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzaRx, 0, byArray.length);
        }
    }

    MilestoneEntity(int n, String string, long l, long l2, byte[] byArray, int n2, String string2) {
        this.mVersionCode = n;
        this.zzaMb = string;
        this.zzaRv = l;
        this.zzaRw = l2;
        this.zzaRx = byArray;
        this.mState = n2;
        this.zzaKM = string2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzaKM;
    }

    @Override
    public String getMilestoneId() {
        return this.zzaMb;
    }

    @Override
    public long getCurrentProgress() {
        return this.zzaRv;
    }

    @Override
    public long getTargetProgress() {
        return this.zzaRw;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.zzaRx;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzz.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object object) {
        return MilestoneEntity.zza(this, object);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzz.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzz.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzz.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzz.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzz.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzz.zzy((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        MilestoneEntityCreator.zza(this, parcel, n);
    }
}

