/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
extends AbstractSafeParcelable
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaOX;
    private final PlayerEntity zzaRH;
    private final byte[] zzaRo;
    private final String zzII;
    private final ArrayList<PlayerEntity> zzaRI;
    private final int zzagd;
    private final long zzaQH;
    private final long zzaRJ;
    private final Bundle zzaRK;
    private final int zzDO;

    public GameRequestEntity(GameRequest gameRequest) {
        this.mVersionCode = 2;
        this.zzaOX = new GameEntity(gameRequest.getGame());
        this.zzaRH = new PlayerEntity(gameRequest.getSender());
        this.zzII = gameRequest.getRequestId();
        this.zzagd = gameRequest.getType();
        this.zzaQH = gameRequest.getCreationTimestamp();
        this.zzaRJ = gameRequest.getExpirationTimestamp();
        this.zzDO = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzaRo = null;
        } else {
            this.zzaRo = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzaRo, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzaRI = new ArrayList(n);
        this.zzaRK = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzaRI.add((PlayerEntity)player);
            this.zzaRK.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int n, GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n2, long l, long l2, Bundle bundle, int n3) {
        this.mVersionCode = n;
        this.zzaOX = gameEntity;
        this.zzaRH = playerEntity;
        this.zzaRo = byArray;
        this.zzII = string;
        this.zzaRI = arrayList;
        this.zzagd = n2;
        this.zzaQH = l;
        this.zzaRJ = l2;
        this.zzaRK = bundle;
        this.zzDO = n3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzII;
    }

    @Override
    public Game getGame() {
        return this.zzaOX;
    }

    @Override
    public Player getSender() {
        return this.zzaRH;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzaRI);
    }

    @Override
    public boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzaRo;
    }

    @Override
    public int getType() {
        return this.zzagd;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaQH;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzaRJ;
    }

    @Override
    public int getRecipientStatus(String string) {
        return this.zzaRK.getInt(string, 0);
    }

    @Override
    public int getStatus() {
        return this.zzDO;
    }

    public Bundle zzBx() {
        return this.zzaRK;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzz.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzz.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzz.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzz.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzz.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzz.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzz.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzz.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzz.zzy((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameRequestEntityCreator.zza(this, parcel, n);
    }
}

