/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.video.VideoCapabilitiesCreator;
import com.google.android.gms.games.video.VideoConfiguration;

public final class VideoCapabilities
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new VideoCapabilitiesCreator();
    private final int mVersionCode;
    private final boolean zzaSw;
    private final boolean zzaSx;
    private final boolean zzaSy;
    private final boolean[] zzaSz;
    private final boolean[] zzaSA;

    public VideoCapabilities(int n, boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.mVersionCode = n;
        this.zzaSw = bl;
        this.zzaSx = bl2;
        this.zzaSy = bl3;
        this.zzaSz = blArray;
        this.zzaSA = blArray2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean isMicSupported() {
        return this.zzaSx;
    }

    public boolean isCameraSupported() {
        return this.zzaSw;
    }

    public boolean isWriteStorageSupported() {
        return this.zzaSy;
    }

    public boolean[] zzBE() {
        return this.zzaSz;
    }

    public boolean[] zzBF() {
        return this.zzaSA;
    }

    public boolean supportsCaptureMode(int n) {
        zzaa.zzai((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzaSz[n];
    }

    public boolean supportsQualityLevel(int n) {
        zzaa.zzai((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zzaSA[n];
    }

    public boolean isFullySupported(int n, int n2) {
        return this.zzaSw && this.zzaSx && this.zzaSy && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzBE(), this.zzBF(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzz.equal((Object)videoCapabilities.zzBE(), (Object)this.zzBE()) && zzz.equal((Object)videoCapabilities.zzBF(), (Object)this.zzBF()) && zzz.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzz.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzz.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.zzBE()).zzg("SupportedQualityLevels", (Object)this.zzBF()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoCapabilitiesCreator.zza(this, parcel, n);
    }
}

