/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzaQc;
    private final String zzaco;
    private final Uri zzaIU;
    private final int zzaQd;
    private final ArrayList<LeaderboardVariantEntity> zzaQe;
    private final Game zzaQf;
    private final String zzaJf;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzaQc = leaderboard.getLeaderboardId();
        this.zzaco = leaderboard.getDisplayName();
        this.zzaIU = leaderboard.getIconImageUri();
        this.zzaJf = leaderboard.getIconImageUrl();
        this.zzaQd = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzaQf = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzaQe = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaQe.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.zzaQc;
    }

    @Override
    public String getDisplayName() {
        return this.zzaco;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaco, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaIU;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaJf;
    }

    @Override
    public int getScoreOrder() {
        return this.zzaQd;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzaQe);
    }

    @Override
    public Game getGame() {
        return this.zzaQf;
    }

    public Leaderboard zzBm() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzz.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzz.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzz.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzz.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzz.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzz.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzz.zzy((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzBm();
    }
}

