/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzaQh;
    private final String zzaQi;
    private final String zzaQj;
    private final long zzaQk;
    private final long zzaQl;
    private final String zzaQm;
    private final Uri zzaQn;
    private final Uri zzaQo;
    private final PlayerEntity zzaQp;
    private final String zzaQq;
    private final String zzaQr;
    private final String zzaQs;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzaQh = leaderboardScore.getRank();
        this.zzaQi = (String)zzaa.zzz((Object)leaderboardScore.getDisplayRank());
        this.zzaQj = (String)zzaa.zzz((Object)leaderboardScore.getDisplayScore());
        this.zzaQk = leaderboardScore.getRawScore();
        this.zzaQl = leaderboardScore.getTimestampMillis();
        this.zzaQm = leaderboardScore.getScoreHolderDisplayName();
        this.zzaQn = leaderboardScore.getScoreHolderIconImageUri();
        this.zzaQo = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzaQp = player == null ? null : (PlayerEntity)player.freeze();
        this.zzaQq = leaderboardScore.getScoreTag();
        this.zzaQr = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzaQs = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzaQh;
    }

    @Override
    public String getDisplayRank() {
        return this.zzaQi;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaQi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.zzaQj;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaQj, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.zzaQk;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzaQl;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzaQp == null) {
            return this.zzaQm;
        }
        return this.zzaQp.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzaQp == null) {
            zzg.zzb((String)this.zzaQm, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzaQp.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzaQp == null) {
            return this.zzaQn;
        }
        return this.zzaQp.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzaQp == null) {
            return this.zzaQr;
        }
        return this.zzaQp.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzaQp == null) {
            return this.zzaQo;
        }
        return this.zzaQp.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzaQp == null) {
            return this.zzaQs;
        }
        return this.zzaQp.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzaQp;
    }

    @Override
    public String getScoreTag() {
        return this.zzaQq;
    }

    public LeaderboardScore zzBo() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzz.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzz.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzz.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzz.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzz.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzz.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzz.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzz.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzz.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzz.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzz.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzz.zzy((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzBo();
    }
}

