/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzaLY;
    private final String zzaco;
    private final Uri zzaIU;
    private final Uri zzaIV;
    private final int zzDO;
    private final String zzaKO;
    private final boolean zzaQO;
    private final PlayerEntity zzaKi;
    private final int zzaeF;
    private final ParticipantResult zzaQP;
    private final String zzaJf;
    private final String zzaJg;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.zzaLY = participant.getParticipantId();
        this.zzaco = participant.getDisplayName();
        this.zzaIU = participant.getIconImageUri();
        this.zzaIV = participant.getHiResImageUri();
        this.zzDO = participant.getStatus();
        this.zzaKO = participant.zzzM();
        this.zzaQO = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaKi = player == null ? null : new PlayerEntity(player);
        this.zzaeF = participant.getCapabilities();
        this.zzaQP = participant.getResult();
        this.zzaJf = participant.getIconImageUrl();
        this.zzaJg = participant.getHiResImageUrl();
    }

    ParticipantEntity(int n, String string, String string2, Uri uri, Uri uri2, int n2, String string3, boolean bl, PlayerEntity playerEntity, int n3, ParticipantResult participantResult, String string4, String string5) {
        this.mVersionCode = n;
        this.zzaLY = string;
        this.zzaco = string2;
        this.zzaIU = uri;
        this.zzaIV = uri2;
        this.zzDO = n2;
        this.zzaKO = string3;
        this.zzaQO = bl;
        this.zzaKi = playerEntity;
        this.zzaeF = n3;
        this.zzaQP = participantResult;
        this.zzaJf = string4;
        this.zzaJg = string5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzDO;
    }

    @Override
    public String zzzM() {
        return this.zzaKO;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzaQO;
    }

    @Override
    public String getDisplayName() {
        if (this.zzaKi == null) {
            return this.zzaco;
        }
        return this.zzaKi.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzaKi == null) {
            zzg.zzb((String)this.zzaco, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzaKi.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzaKi == null) {
            return this.zzaIU;
        }
        return this.zzaKi.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzaKi == null) {
            return this.zzaJf;
        }
        return this.zzaKi.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzaKi == null) {
            return this.zzaIV;
        }
        return this.zzaKi.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzaKi == null) {
            return this.zzaJg;
        }
        return this.zzaKi.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzaLY;
    }

    @Override
    public Player getPlayer() {
        return this.zzaKi;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzaQP;
    }

    @Override
    public int getCapabilities() {
        return this.zzaeF;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzz.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzzM(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzz.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzz.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzz.equal((Object)participant2.zzzM(), (Object)participant.zzzM()) && zzz.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzz.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzz.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzz.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzz.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzz.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzz.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzz.zzy((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzzM()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zztG()) {
            ParticipantEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.zzaLY);
            parcel.writeString(this.zzaco);
            parcel.writeString(this.zzaIU == null ? null : this.zzaIU.toString());
            parcel.writeString(this.zzaIV == null ? null : this.zzaIV.toString());
            parcel.writeInt(this.zzDO);
            parcel.writeString(this.zzaKO);
            parcel.writeInt(this.zzaQO ? 1 : 0);
            parcel.writeInt(this.zzaKi == null ? 0 : 1);
            if (this.zzaKi != null) {
                this.zzaKi.writeToParcel(parcel, n);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzev(Parcel parcel) {
            boolean bl = ParticipantEntity.zzf(ParticipantEntity.zztF());
            if (bl || ParticipantEntity.zzde((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzev(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            Object var14_14 = null;
            Object var15_15 = null;
            Object var16_16 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, 7, null, null, null);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzev(parcel);
        }
    }
}

