/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String gs;
    private final String dH;
    private final String QB;
    private final String QC;
    private final String zzcvi;
    private final String QD;
    private final Uri QE;
    private final Uri QF;
    private final Uri QG;
    private final boolean QH;
    private final boolean QI;
    private final String QJ;
    private final int QK;
    private final int QL;
    private final int QM;
    private final boolean QN;
    private final boolean QO;
    private final String QP;
    private final String QQ;
    private final String QR;
    private final boolean zzbsi;
    private final boolean QS;
    private final boolean QT;
    private final String QU;
    private final boolean QV;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.gs = game.getApplicationId();
        this.QB = game.getPrimaryCategory();
        this.QC = game.getSecondaryCategory();
        this.zzcvi = game.getDescription();
        this.QD = game.getDeveloperName();
        this.dH = game.getDisplayName();
        this.QE = game.getIconImageUri();
        this.QP = game.getIconImageUrl();
        this.QF = game.getHiResImageUri();
        this.QQ = game.getHiResImageUrl();
        this.QG = game.getFeaturedImageUri();
        this.QR = game.getFeaturedImageUrl();
        this.QH = game.zzbfw();
        this.QI = game.zzbfy();
        this.QJ = game.zzbfz();
        this.QK = 1;
        this.QL = game.getAchievementTotalCount();
        this.QM = game.getLeaderboardCount();
        this.QN = game.isRealTimeMultiplayerEnabled();
        this.QO = game.isTurnBasedMultiplayerEnabled();
        this.zzbsi = game.isMuted();
        this.QS = game.zzbfx();
        this.QT = game.areSnapshotsEnabled();
        this.QU = game.getThemeColor();
        this.QV = game.hasGamepadSupport();
    }

    GameEntity(int n, String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n2, int n3, int n4, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.mVersionCode = n;
        this.gs = string;
        this.dH = string2;
        this.QB = string3;
        this.QC = string4;
        this.zzcvi = string5;
        this.QD = string6;
        this.QE = uri;
        this.QP = string8;
        this.QF = uri2;
        this.QQ = string9;
        this.QG = uri3;
        this.QR = string10;
        this.QH = bl;
        this.QI = bl2;
        this.QJ = string7;
        this.QK = n2;
        this.QL = n3;
        this.QM = n4;
        this.QN = bl3;
        this.QO = bl4;
        this.zzbsi = bl5;
        this.QS = bl6;
        this.QT = bl7;
        this.QU = string11;
        this.QV = bl8;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.gs;
    }

    @Override
    public String getDisplayName() {
        return this.dH;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.dH, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getPrimaryCategory() {
        return this.QB;
    }

    @Override
    public String getSecondaryCategory() {
        return this.QC;
    }

    @Override
    public String getDescription() {
        return this.zzcvi;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDeveloperName() {
        return this.QD;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.QD, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.QE;
    }

    @Override
    public String getIconImageUrl() {
        return this.QP;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.QF;
    }

    @Override
    public String getHiResImageUrl() {
        return this.QQ;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.QG;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.QR;
    }

    @Override
    public boolean isMuted() {
        return this.zzbsi;
    }

    @Override
    public boolean zzbfx() {
        return this.QS;
    }

    @Override
    public boolean zzbfw() {
        return this.QH;
    }

    @Override
    public boolean zzbfy() {
        return this.QI;
    }

    @Override
    public String zzbfz() {
        return this.QJ;
    }

    public int zzbga() {
        return this.QK;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.QL;
    }

    @Override
    public int getLeaderboardCount() {
        return this.QM;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.QN;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.QO;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.QT;
    }

    @Override
    public String getThemeColor() {
        return this.QU;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.QV;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzaa.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzbfw(), game.zzbfy(), game.zzbfz(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzbfx(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzaa.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzaa.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzaa.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzaa.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzaa.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzaa.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzaa.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzaa.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzaa.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzaa.equal((Object)game2.zzbfw(), (Object)game.zzbfw()) && zzaa.equal((Object)game2.zzbfy(), (Object)game.zzbfy()) && zzaa.equal((Object)game2.zzbfz(), (Object)game.zzbfz()) && zzaa.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzaa.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzaa.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzaa.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzaa.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzaa.equal((Object)game2.zzbfx(), (Object)game.zzbfx()) ? 1 : 0)) && zzaa.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzaa.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzaa.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzaa.zzz((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzbfw()).zzg("InstanceInstalled", (Object)game.zzbfy()).zzg("InstancePackageName", (Object)game.zzbfz()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzasq()) {
            GameEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.gs);
            parcel.writeString(this.dH);
            parcel.writeString(this.QB);
            parcel.writeString(this.QC);
            parcel.writeString(this.zzcvi);
            parcel.writeString(this.QD);
            parcel.writeString(this.QE == null ? null : this.QE.toString());
            parcel.writeString(this.QF == null ? null : this.QF.toString());
            parcel.writeString(this.QG == null ? null : this.QG.toString());
            parcel.writeInt(this.QH ? 1 : 0);
            parcel.writeInt(this.QI ? 1 : 0);
            parcel.writeString(this.QJ);
            parcel.writeInt(this.QK);
            parcel.writeInt(this.QL);
            parcel.writeInt(this.QM);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzkt(Parcel parcel) {
            boolean bl = GameEntity.zzf(GameEntity.zzasp());
            if (bl || GameEntity.zzhl((String)GameEntity.class.getCanonicalName())) {
                return super.zzkt(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            Object var23_23 = null;
            Object var24_24 = null;
            Object var25_25 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            Object var29_29 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzkt(parcel);
        }
    }
}

