/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AppContentsImpl;
import com.google.android.gms.games.internal.api.EventsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.QuestsImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.SnapshotsImpl;
import com.google.android.gms.games.internal.api.SocialImpl;
import com.google.android.gms.games.internal.api.StatsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.api.VideosImpl;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzpr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzf<GamesClientImpl> bN = new Api.zzf();
    private static final Api.zza<GamesClientImpl, GamesOptions> bO = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(SCOPE_GAMES);
        }

        public /* synthetic */ List zzq(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    private static final Api.zza<GamesClientImpl, GamesOptions> QW = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(QX);
        }

        public /* synthetic */ List zzq(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api("Games.API", bO, bN);
    public static final Scope QX = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> QY = new Api("Games.API_1P", QW, bN);
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final AppContents QZ = new AppContentsImpl();
    public static final Events Events = new EventsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer Ra = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Quests Quests = new QuestsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Snapshots Snapshots = new SnapshotsImpl();
    public static final Stats Stats = new StatsImpl();
    public static final Videos Videos = new VideosImpl();
    public static final Social Rb = new SocialImpl();

    private Games() {
    }

    public static GamesClientImpl zzi(GoogleApiClient googleApiClient) {
        return Games.zzb(googleApiClient, true);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzab.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzab.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzc(googleApiClient, bl);
    }

    public static GamesClientImpl zzc(GoogleApiClient googleApiClient, boolean bl) {
        zzab.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        return bl2 ? (GamesClientImpl)googleApiClient.zza(bN) : null;
    }

    public static void setGravityForPopups(GoogleApiClient googleApiClient, int n) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzqo(n);
        }
    }

    public static void setViewForPopups(GoogleApiClient googleApiClient, View view) {
        zzab.zzaa((Object)view);
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzq(view);
        }
    }

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public static String getCurrentAccountName(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzbic();
    }

    @Deprecated
    public static PendingResult<GetServerAuthCodeResult> getGamesServerAuthCode(GoogleApiClient googleApiClient, final String string) {
        zzab.zzh((String)string, (Object)"Please provide a valid serverClientId");
        return googleApiClient.zzd((zzpr.zza)new GetServerAuthCodeImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(string, (zzpr.zzb<GetServerAuthCodeResult>)this);
            }
        });
    }

    public static String getAppId(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzsi();
    }

    public static Intent getSettingsIntent(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzbio();
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzpr.zza)new SignOutImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzh((zzpr.zzb<Status>)this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzbip();
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class GetServerAuthCodeImpl
    extends BaseGamesApiMethodImpl<GetServerAuthCodeResult> {
        private GetServerAuthCodeImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public GetServerAuthCodeResult zzbf(final Status status) {
            return new GetServerAuthCodeResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getCode() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzbf(status);
        }
    }

    private static abstract class GetTokenImpl
    extends BaseGamesApiMethodImpl<GetTokenResult> {
        public GetTokenResult zzbg(final Status status) {
            return new GetTokenResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzbg(status);
        }
    }

    @Deprecated
    public static interface GetServerAuthCodeResult
    extends Result {
        public String getCode();
    }

    public static interface GetTokenResult
    extends Result {
    }

    public static abstract class StatusImpl
    extends BaseGamesApiMethodImpl<Status> {
        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends zzpr.zza<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl(GoogleApiClient googleApiClient) {
            super(bN, googleApiClient);
        }
    }

    private static abstract class GamesClientBuilder
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private GamesClientBuilder() {
        }

        public GamesClientImpl zza(Context context, Looper looper, zzg zzg2, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, zzg2, gamesOptions, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 1;
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        public final boolean Rd;
        public final boolean Re;
        public final int Rf;
        public final boolean Rg;
        public final int Rh;
        public final String Ri;
        public final ArrayList<String> Rj;
        public final boolean Rk;
        public final boolean Rl;

        private GamesOptions() {
            this.Rd = false;
            this.Re = true;
            this.Rf = 17;
            this.Rg = false;
            this.Rh = 4368;
            this.Ri = null;
            this.Rj = new ArrayList();
            this.Rk = false;
            this.Rl = false;
        }

        private GamesOptions(Builder builder) {
            this.Rd = false;
            this.Re = builder.Re;
            this.Rf = builder.Rf;
            this.Rg = false;
            this.Rh = builder.Rh;
            this.Ri = null;
            this.Rj = builder.Rj;
            this.Rk = builder.Rk;
            this.Rl = false;
        }

        public Bundle zzbgc() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.Rd);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.Re);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.Rf);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.Rg);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.Rh);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.Ri);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.Rj);
            bundle.putBoolean("com.google.android.gms.games.key.requireGooglePlus", this.Rk);
            bundle.putBoolean("com.google.android.gms.games.key.unauthenticated", this.Rl);
            return bundle;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean Rd = false;
            boolean Re = true;
            int Rf = 17;
            boolean Rg = false;
            int Rh = 4368;
            String Ri = null;
            ArrayList<String> Rj = new ArrayList();
            boolean Rk = false;
            boolean Rl = false;

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean bl) {
                this.Re = bl;
                this.Rf = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean bl, int n) {
                this.Re = bl;
                this.Rf = n;
                return this;
            }

            public Builder setRequireGooglePlus(boolean bl) {
                this.Rk = bl;
                return this;
            }

            public Builder setSdkVariant(int n) {
                this.Rh = n;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

