/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames RJ;
    private final PlayerLevelInfo Rs;
    private final MostRecentGameInfoRef RK;

    public PlayerRef(DataHolder dataHolder, int n) {
        this(dataHolder, n, null);
    }

    public PlayerRef(DataHolder dataHolder, int n, String string) {
        super(dataHolder, n);
        this.RJ = new PlayerColumnNames(string);
        this.RK = new MostRecentGameInfoRef(dataHolder, n, this.RJ);
        if (this.zzbgk()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.RJ.Xf);
            int n3 = this.getInteger(this.RJ.Xi);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.RJ.Xg), this.getLong(this.RJ.Xh));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.RJ.Xh), this.getLong(this.RJ.Xj));
            }
            this.Rs = new PlayerLevelInfo(this.getLong(this.RJ.Xe), this.getLong(this.RJ.Xk), playerLevel, playerLevel2);
        } else {
            this.Rs = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.RJ.WV);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.RJ.WW);
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        this.zza(this.RJ.WW, charArrayBuffer);
    }

    @Override
    public String zzbgd() {
        return this.getString(this.RJ.Xu);
    }

    @Override
    public String getName() {
        return this.getString(this.RJ.name);
    }

    @Override
    public boolean zzbge() {
        return this.getBoolean(this.RJ.Xt);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzhg(this.RJ.WX);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.RJ.WY);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzhg(this.RJ.WZ);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.RJ.Xa);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.RJ.Xb);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzhf(this.RJ.Xd) || this.zzhh(this.RJ.Xd)) {
            return -1L;
        }
        return this.getLong(this.RJ.Xd);
    }

    @Override
    public int zzbgf() {
        return this.getInteger(this.RJ.Xc);
    }

    @Override
    public boolean zzbgg() {
        return this.getBoolean(this.RJ.Xm);
    }

    @Override
    public String getTitle() {
        return this.getString(this.RJ.title);
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        this.zza(this.RJ.title, charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.Rs;
    }

    @Override
    public MostRecentGameInfo zzbgh() {
        if (this.zzhh(this.RJ.Xn)) {
            return null;
        }
        return this.RK;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzhg(this.RJ.Xv);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.RJ.Xw);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzhg(this.RJ.Xx);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.RJ.Xy);
    }

    @Override
    public int zzbgi() {
        return this.getInteger(this.RJ.Xz);
    }

    @Override
    public long zzbgj() {
        return this.getLong(this.RJ.XA);
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean(this.RJ.XB);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntity playerEntity = (PlayerEntity)((Player)this.freeze());
        playerEntity.writeToParcel(parcel, n);
    }

    private boolean zzbgk() {
        if (this.zzhh(this.RJ.Xe)) {
            return false;
        }
        return this.getLong(this.RJ.Xe) != -1L;
    }
}

