/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;

public final class AchievementEntity
extends AbstractSafeParcelable
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String RL;
    private final int it;
    private final String mName;
    private final String zzcvi;
    private final Uri RM;
    private final String RN;
    private final Uri RO;
    private final String RP;
    private final int RQ;
    private final String RR;
    private final PlayerEntity RS;
    private final int mState;
    private final int RT;
    private final String RU;
    private final long RV;
    private final long RW;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.RL = achievement.getAchievementId();
        this.it = achievement.getType();
        this.mName = achievement.getName();
        this.zzcvi = achievement.getDescription();
        this.RM = achievement.getUnlockedImageUri();
        this.RN = achievement.getUnlockedImageUrl();
        this.RO = achievement.getRevealedImageUri();
        this.RP = achievement.getRevealedImageUrl();
        this.RS = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.RV = achievement.getLastUpdatedTimestamp();
        this.RW = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.RQ = achievement.getTotalSteps();
            this.RR = achievement.getFormattedTotalSteps();
            this.RT = achievement.getCurrentSteps();
            this.RU = achievement.getFormattedCurrentSteps();
        } else {
            this.RQ = 0;
            this.RR = null;
            this.RT = 0;
            this.RU = null;
        }
        zzb.zzw((Object)this.RL);
        zzb.zzw((Object)this.zzcvi);
    }

    AchievementEntity(int n, String string, int n2, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n3, String string6, PlayerEntity playerEntity, int n4, int n5, String string7, long l, long l2) {
        this.mVersionCode = n;
        this.RL = string;
        this.it = n2;
        this.mName = string2;
        this.zzcvi = string3;
        this.RM = uri;
        this.RN = string4;
        this.RO = uri2;
        this.RP = string5;
        this.RQ = n3;
        this.RR = string6;
        this.RS = playerEntity;
        this.mState = n4;
        this.RT = n5;
        this.RU = string7;
        this.RV = l;
        this.RW = l2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.RL;
    }

    @Override
    public int getType() {
        return this.it;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzcvi;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.RM;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.RN;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.RO;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.RP;
    }

    public int zzbgq() {
        return this.RQ;
    }

    @Override
    public int getTotalSteps() {
        zzb.zzbm((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbgq();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzb.zzbm((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbgr();
    }

    public String zzbgr() {
        return this.RR;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        zzb.zzbm((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.RR, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Player getPlayer() {
        return this.RS;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzb.zzbm((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbgs();
    }

    public int zzbgs() {
        return this.RT;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzb.zzbm((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzbgt();
    }

    public String zzbgt() {
        return this.RU;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        zzb.zzbm((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.RU, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.RV;
    }

    @Override
    public long getXpValue() {
        return this.RW;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzaa.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object object) {
        return AchievementEntity.zza(this, object);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzaa.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzaa.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzaa.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzaa.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzaa.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzaa.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzaa.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzaa.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzaa.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzaa.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzaa.zza zza2 = zzaa.zzz((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        AchievementEntityCreator.zza(this, parcel, n);
    }
}

