/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.player.ProfileSettingsEntity;
import com.google.android.gms.games.internal.player.StockProfileImageBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.OnSocialInviteUpdateReceivedListener;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.social.SocialInvite;
import com.google.android.gms.games.social.SocialInviteBuffer;
import com.google.android.gms.games.social.SocialInviteEntity;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.signin.internal.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends zzk<IGamesService> {
    EventIncrementManager Sz = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzbja() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String SA;
    private PlayerEntity SB;
    private GameEntity SC;
    private final PopupManager SD;
    private boolean SE = false;
    private final Binder SF;
    private final long SG;
    private final Games.GamesOptions SH;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzg zzg2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.SA = zzg2.zzasi();
        this.SF = new Binder();
        this.SD = PopupManager.zza(this, zzg2.zzase());
        this.zzq(zzg2.zzask());
        this.SG = ((Object)((Object)this)).hashCode();
        this.SH = gamesOptions;
    }

    public boolean zzafk() {
        return true;
    }

    public void zza(@NonNull IGamesService iGamesService) {
        super.zza((IInterface)iGamesService);
        if (this.SE) {
            this.SD.zzbjo();
            this.SE = false;
        }
        if (!this.SH.Rd && !this.SH.Rl) {
            this.zzb(iGamesService);
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.SE = false;
    }

    public void zzqo(int n) {
        this.SD.setGravity(n);
    }

    public void zzq(View view) {
        this.SD.zzr(view);
    }

    protected Set<Scope> zzc(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzab.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzab.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(zzd.zzf zzf2) {
        this.zzbib();
        super.zza(zzf2);
    }

    public void disconnect() {
        this.SE = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzarw();
                iGamesService.zzbiz();
                this.Sz.flush();
                iGamesService.zzak(this.SG);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzaf("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzra() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzrb() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzgg(IBinder iBinder) {
        return IGamesService.Stub.zzgj(iBinder);
    }

    public Bundle zzamc() {
        try {
            Bundle bundle = ((IGamesService)this.zzarw()).zzamc();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zzbib() {
        this.SB = null;
        this.SC = null;
    }

    protected Bundle zzaeu() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.SH.zzbgc();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.SA);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.SD.zzbjq()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 4);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzg.zza((com.google.android.gms.common.internal.zzg)this.zzasr()));
        return bundle;
    }

    public void zzb(IGamesService iGamesService) {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.SD);
            iGamesService.zza(popupLocationInfoBinderCallbacks, this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zzbic() {
        try {
            return ((IGamesService)this.zzarw()).zzbic();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzf(zzpr.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzj(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public void zzb(String string, zzpr.zzb<Games.GetServerAuthCodeResult> zzb2) throws RemoteException {
        zzab.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((IGamesService)this.zzarw()).zza(string, new GetServerAuthCodeBinderCallbacks(zzb2));
    }

    public String zzbs(boolean bl) {
        if (bl && this.SB != null) {
            return this.SB.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzarw()).zzbjb();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzbid() {
        this.zzarv();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.SB == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzarw()).zzbjc());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.SB = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.SB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzbie() {
        this.zzarv();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.SC == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzarw()).zzbje());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.SC = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.SC;
    }

    public void zza(zzpr.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzpr.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zzpr.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zzpr.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzarw()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zzpr.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                String string3 = String.valueOf(string);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid player collection: ".concat(string3) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zzpr.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzbif() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzbif();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zzpr.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zzpr.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzpr.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zzpr.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zzpr.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zzpr.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzbla().asBundle(), n, n2);
    }

    public void zza(zzpr.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzbig() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzbig();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzpr.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzpr.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.SD.zzbjq(), this.SD.zzbjp());
    }

    public void zzb(zzpr.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.SD.zzbjq(), this.SD.zzbjp());
    }

    public void zza(zzpr.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.SD.zzbjq(), this.SD.zzbjp());
    }

    public void zzb(zzpr.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.SD.zzbjq(), this.SD.zzbjp());
    }

    public void zzd(zzpr.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzpr.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzn(String string, int n) {
        this.Sz.zzn(string, n);
    }

    public Intent zzbih() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzbih();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbii() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzbii();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzqs<OnInvitationReceivedListener> zzqs2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzqs2);
            ((IGamesService)this.zzarw()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbij() {
        try {
            ((IGamesService)this.zzarw()).zzal(this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzqs<OnTurnBasedMatchUpdateReceivedListener> zzqs2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzqs2);
            ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbik() {
        try {
            ((IGamesService)this.zzarw()).zzam(this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzqs<QuestUpdateListener> zzqs2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzqs2);
            ((IGamesService)this.zzarw()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbil() {
        try {
            ((IGamesService)this.zzarw()).zzao(this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzqs<OnRequestReceivedListener> zzqs2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzqs2);
            ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbim() {
        try {
            ((IGamesService)this.zzarw()).zzan(this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbin() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzbin();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbio() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzbio();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzg(zzpr.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzh(zzpr.zzb<Status> zzb2) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzbip() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzarw()).zzbip();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zzsi() {
        try {
            return ((IGamesService)this.zzarw()).zzsi();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zza(zzpr.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzo(String string, int n) {
        try {
            ((IGamesService)this.zzarw()).zzo(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzp(String string, int n) {
        try {
            ((IGamesService)this.zzarw()).zzp(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzpr.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzblg(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zzpr.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzk((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zzpr.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzl((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzbiq() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzarw()).zzbiq();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zzpr.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zzpr.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zzpr.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzn(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zzpr.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzpr.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzm((IGamesCallbacks)new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzjm(String string) {
        try {
            ((IGamesService)this.zzarw()).zzju(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzpr.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zzpr.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzo(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzqs<RoomUpdateListener> zzqs2, zzqs<RoomStatusUpdateListener> zzqs3, zzqs<RealTimeMessageReceivedListener> zzqs4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzqs2, zzqs3, zzqs4);
            ((IGamesService)this.zzarw()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.SF, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzqs<RoomUpdateListener> zzqs2, zzqs<RoomStatusUpdateListener> zzqs3, zzqs<RealTimeMessageReceivedListener> zzqs4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzqs2, zzqs3, zzqs4);
            ((IGamesService)this.zzarw()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.SF, roomConfig.getInvitationId(), false, this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzqs<RoomUpdateListener> zzqs2, String string) {
        try {
            ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzqs2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzqs<RealTimeMultiplayer.ReliableMessageSentCallback> zzqs2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzqs2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzab.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzarw()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zze(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzarw()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzqp(int n) {
        try {
            ((IGamesService)this.zzarw()).zzqp(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzbir() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzbir();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zza(n, byArray, n2, string);
            zzab.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzbis() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzarw()).zzbis();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzbit() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzarw()).zzbit();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zzpr.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zzpr.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zzpr.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zzpr.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zzpr.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzc(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzc(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzjn(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzjn(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zzpr.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zzt(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zzpr.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zzpr.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zzpr.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzjo(String string) {
        try {
            ((IGamesService)this.zzarw()).zza(string, this.SD.zzbjq(), this.SD.zzbjp());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzpr.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zzpr.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.Sz.flush();
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzbiu() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzarw()).zzbiu();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzbiv() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzarw()).zzbiv();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzpr.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zzpr.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zzpr.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzab.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzbll();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzazu();
        snapshotContents.close();
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzab.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzazu();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzarw()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zzpr.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzq(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zzpr.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzab.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzbll();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzazu();
        snapshotContents.close();
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zzi(zzpr.zzb<Videos.CaptureCapabilitiesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzl(new CaptureCapabilitiesBinderCallback(zzb2));
    }

    public Intent zzbiw() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzarw()).zzbjk();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzj(zzpr.zzb<Videos.CaptureStateResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzv(new CaptureStateBinderCallbacks(zzb2));
    }

    public void zzk(zzpr.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzs(new CaptureStreamingAvailabilityBinderCallback(zzb2));
    }

    public void zzl(zzpr.zzb<Videos.CaptureStreamingMetadataResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzq(new CaptureStreamingMetadataBinderCallback(zzb2));
    }

    public void zzm(zzpr.zzb<Videos.CaptureStreamingUrlResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzr(new CaptureStreamingUrlBinderCallback(zzb2));
    }

    public void zzn(zzpr.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzt(new HeadlessCaptureEnabledBinderCallback(zzb2));
    }

    public void zzb(zzpr.zzb<Videos.CaptureAvailableResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new CaptureAvailableBinderCallback(zzb2), n);
    }

    public boolean zzbix() {
        boolean bl = false;
        try {
            bl = ((IGamesService)this.zzarw()).zzbix();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return bl;
    }

    public void zzo(zzpr.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzo(new CaptureStreamingEnabledBinderCallback(zzb2));
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new CaptureLaunchGameAndOverlayBinderCallback(baseGamesApiMethodImpl), string, videoConfiguration);
    }

    public void zzp(zzpr.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzk(new ListVideosBinderCallback(zzb2));
    }

    public void zzc(zzpr.zzb<Videos.ListVideosResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zzd((IGamesCallbacks)new ListVideosBinderCallback(zzb2), string, n);
    }

    public void zze(zzqs<Videos.CaptureOverlayStateListener> zzqs2) {
        try {
            CaptureOverlayStateBinderCallback captureOverlayStateBinderCallback = new CaptureOverlayStateBinderCallback(zzqs2);
            ((IGamesService)this.zzarw()).zzf((IGamesCallbacks)captureOverlayStateBinderCallback, this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzg(zzpr.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzm((IGamesCallbacks)new CapturePausedBinderCallback(zzb2), bl);
    }

    public void zza(zzpr.zzb<Status> zzb2, VideoConfiguration videoConfiguration, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new CaptureStartedBinderCallbacks(zzb2, captureRuntimeErrorCallback), videoConfiguration);
    }

    public void zzq(zzpr.zzb<Videos.CaptureStoppedResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzu(new CaptureStoppedBinderCallbacks(zzb2));
    }

    public void zzbiy() {
        try {
            ((IGamesService)this.zzarw()).zzar(this.SG);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzpr.zzb<Status> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzh(new UpdateHeadlessCapturePermissionBinderCallback(zzb2), string, bl);
    }

    public void zzj(zzpr.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zzpr.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzp(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzpr.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzpr.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zzpr.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzpr.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzpr.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zzpr.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zzpr.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzarw()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zzpr.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zzpr.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zzpr.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzr(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzpr.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zze(zzpr.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zza(zzpr.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl, bl2);
    }

    public void zzh(zzpr.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zza(zzpr.zzb<Players.LoadPlayersResult> zzb2, Account account) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), account);
    }

    public void zzr(zzpr.zzb<Players.LoadStockProfileImagesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzp(new StockProfileImagesLoadedBinderCallback(zzb2));
    }

    public void zza(zzpr.zzb<Players.UpdateGamerProfileResult> zzb2, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new GamerProfileUpdatedBinderCallback(zzb2), string, bl, string2, bl2, bl3);
    }

    public void zzi(zzpr.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzj((IGamesCallbacks)new DeletePlayerBinderCallback(zzb2), bl);
    }

    public void zzj(zzpr.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzk((IGamesCallbacks)new UpdateAutoSignInBinderCallback(zzb2), bl);
    }

    public void zzk(zzpr.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzl((IGamesCallbacks)new UpdateProfileDiscoverabilityBinderCallback(zzb2), bl);
    }

    public void zzb(zzpr.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zzpr.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zzpr.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzarw()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzpr.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zzpr.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzj((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zzpr.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zze(zzpr.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzn(zzpr.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzl(zzpr.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzpr.zzb<Status> zzb2, boolean bl, boolean bl2, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bl2, bundle);
    }

    public void zzs(zzpr.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzs(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zzpr.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zzpr.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zzpr.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzg(zzpr.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zzpr.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzarw()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzbiz() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzarw()).zzbiz();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzbi(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.SE = bundle.getBoolean("show_welcome_popup");
            this.SB = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.SC = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zzo(zzpr.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzu(new SendFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzp(zzpr.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzv(new AcceptFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzq(zzpr.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzw(new IgnoreFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzr(zzpr.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzx(new CancelFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zze(zzpr.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzarw()).zzf(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzs(zzpr.zzb<Players.LoadPlayersResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzarw()).zzy(new PlayerUnfriendedBinderCallback(zzb2), string);
    }

    public void zzf(zzpr.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzarw()).zzg(new SetPlayerMutedBinderCallback(zzb2), string, bl);
    }

    public void zzc(zzpr.zzb<Social.LoadInvitesResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzarw()).zzb((IGamesCallbacks)new InvitesLoadedBinderCallback(zzb2), n);
    }

    public void zza(Account account, byte[] byArray) throws RemoteException {
        ((IGamesService)this.zzarw()).zza(account, byArray);
    }

    public void zze(Account account) throws RemoteException {
        ((IGamesService)this.zzarw()).zze(account);
    }

    protected /* synthetic */ IInterface zzbb(IBinder iBinder) {
        return this.zzgg(iBinder);
    }

    private static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer Tf;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tf = new VideoBuffer(dataHolder);
        }
    }

    private static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status cc;
        private final String zzae;

        CaptureStreamingUrlResultImpl(Status status, String string) {
            this.cc = status;
            this.zzae = string;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public String getUrl() {
            return this.zzae;
        }
    }

    private static final class CaptureStreamingMetadataResultImpl
    implements Videos.CaptureStreamingMetadataResult {
        private final Status cc;
        private final String Fx;
        private final String zzcvi;

        CaptureStreamingMetadataResultImpl(Status status, String string, String string2) {
            this.cc = status;
            this.Fx = string;
            this.zzcvi = string2;
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class CaptureStreamingEnabledResultImpl
    implements Result {
        public Status getStatus() {
            return null;
        }
    }

    private static final class CaptureStreamingAvailabilityResultImpl
    implements Videos.CaptureStreamingAvailabilityResult {
        private final Status cc;
        private final boolean SN;
        private final boolean SU;

        CaptureStreamingAvailabilityResultImpl(Status status, boolean bl, boolean bl2) {
            this.cc = status;
            this.SN = bl;
            this.SU = bl2;
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class CaptureStoppedResultImpl
    implements Videos.CaptureStoppedResult {
        private final Status cc;
        private final Uri ST;

        CaptureStoppedResultImpl(Status status, Uri uri) {
            this.cc = status;
            this.ST = uri;
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class CaptureStateResultImpl
    implements Videos.CaptureStateResult {
        private final Status cc;
        private final CaptureState SS;

        CaptureStateResultImpl(Status status, CaptureState captureState) {
            this.cc = status;
            this.SS = captureState;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public CaptureState getCaptureState() {
            return this.SS;
        }
    }

    private static final class CaptureCapabilitiesResultImpl
    implements Videos.CaptureCapabilitiesResult {
        private final Status cc;
        private final VideoCapabilities SO;

        CaptureCapabilitiesResultImpl(Status status, VideoCapabilities videoCapabilities) {
            this.cc = status;
            this.SO = videoCapabilities;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public VideoCapabilities getCapabilities() {
            return this.SO;
        }
    }

    private static final class CaptureAvailableResultImpl
    implements Videos.CaptureAvailableResult {
        private final Status cc;
        private final boolean SN;

        CaptureAvailableResultImpl(Status status, boolean bl) {
            this.cc = status;
            this.SN = bl;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public boolean isAvailable() {
            return this.SN;
        }
    }

    private static final class InviteUpdateResultImpl
    extends GamesDataHolderResult
    implements Social.InviteUpdateResult {
        private final SocialInvite Tc;

        InviteUpdateResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            try {
                this.Tc = socialInviteBuffer.getCount() > 0 ? new SocialInviteEntity((SocialInvite)socialInviteBuffer.get(0)) : null;
            }
            finally {
                socialInviteBuffer.release();
            }
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status cc;
        private final String SX;

        DeleteSnapshotResultImpl(int n, String string) {
            this.cc = GamesStatusCodes.zzps(n);
            this.SX = string;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public String getSnapshotId() {
            return this.SX;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata SW;

        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.SW = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.SW;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot TC;
        private final String TD;
        private final Snapshot TE;
        private final Contents TF;
        private final SnapshotContents TG;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents contents) {
            this(dataHolder, null, contents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.TC = null;
                    this.TE = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzb.zzbm((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.TC = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    this.TE = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.TC = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.TE = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(contents2));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.TD = string;
            this.TF = contents3;
            this.TG = new SnapshotContentsEntity(contents3);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.TC;
        }

        @Override
        public String getConflictId() {
            return this.TD;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.TE;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.TG;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.tk);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats Tq;

        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.Tq = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity((PlayerStats)playerStatsBuffer.get(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.Tq;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> Th;

        LoadAppContentsResultImpl(DataHolder[] dataHolderArray) {
            super(dataHolderArray[0]);
            this.Th = new ArrayList<DataHolder>(Arrays.asList(dataHolderArray));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone SV;
        private final Quest SK;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.SK = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.SK.zzbli();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.SV = list.get(i);
                        return;
                    }
                    this.SV = null;
                } else {
                    this.SV = null;
                    this.SK = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.SV;
        }

        @Override
        public Quest getQuest() {
            return this.SK;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest SK;

        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.SK = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.SK;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder tk;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.tk = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.tk);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status cc;
        private final Bundle Ts;

        LoadRequestsResultImpl(Status status, Bundle bundle) {
            this.cc = status;
            this.Ts = bundle;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public GameRequestBuffer getRequests(int n) {
            String string = RequestType.zzqs(n);
            if (!this.Ts.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.Ts.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.Ts.keySet()) {
                DataHolder dataHolder = (DataHolder)this.Ts.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes Uj;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Uj = RequestUpdateOutcomes.zzbl(dataHolder);
        }

        @Override
        public int getRequestOutcome(String string) {
            return this.Uj.getRequestOutcome(string);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.Uj.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest TP;

        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.TP = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status cc;
        private final Bundle Ta;

        InboxCountResultImpl(Status status, Bundle bundle) {
            this.cc = status;
            this.Ta = bundle;
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class GetServerAuthCodeResultImpl
    implements Games.GetServerAuthCodeResult {
        private final Status cc;
        private final String SZ;

        GetServerAuthCodeResultImpl(Status status, String string) {
            this.cc = status;
            this.SZ = string;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public String getCode() {
            return this.SZ;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status cc;
        private final String ct;

        GetTokenResultImpl(Status status, String string) {
            this.cc = status;
            this.ct = string;
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status cc;
        private final String SY;
        private final boolean zzcqf;

        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.cc = GamesStatusCodes.zzps(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.SY = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzcqf = dataHolder.zze("muted", 0, 0);
                } else {
                    this.SY = null;
                    this.zzcqf = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status cc;
        private final String SY;
        private final boolean zzcqf;

        public GameMuteStatusChangeResultImpl(int n, String string, boolean bl) {
            this.cc = GamesStatusCodes.zzps(n);
            this.SY = string;
            this.zzcqf = bl;
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status cc;
        private final String SM;

        CancelMatchResultImpl(Status status, String string) {
            this.cc = status;
            this.SM = string;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public String getMatchId() {
            return this.SM;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch TA;

        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.TA = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.TA;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData Ub;

        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.Ub = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.Ub;
        }
    }

    private static final class UpdateGamerProfileResultImpl
    implements Players.UpdateGamerProfileResult {
        private final Status cc;
        private final Bundle Ui;

        UpdateGamerProfileResultImpl(int n, Bundle bundle) {
            this.cc = new Status(n);
            this.Ui = bundle;
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class LoadStockProfileImagesResultImpl
    extends GamesDataHolderResult
    implements Players.LoadStockProfileImagesResult {
        private final StockProfileImageBuffer Tv;

        LoadStockProfileImagesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tv = new StockProfileImageBuffer(dataHolder);
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer Ty;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Ty = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status cc;
        private final List<String> Tw;
        private final Bundle Tx;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle bundle) {
            this.cc = status;
            this.Tw = bundle.getStringArrayList("game_category_list");
            this.Tx = bundle;
        }

        public Status getStatus() {
            return this.cc;
        }
    }

    private static final class LoadInvitesResultImpl
    extends GamesDataHolderResult
    implements Social.LoadInvitesResult {
        private final SocialInviteBuffer Tn;

        LoadInvitesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tn = new SocialInviteBuffer(dataHolder);
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer Tr;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tr = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.Tr;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status cc;
        private final LoadMatchesResponse To;

        LoadMatchesResultImpl(Status status, Bundle bundle) {
            this.cc = status;
            this.To = new LoadMatchesResponse(bundle);
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.To;
        }

        public void release() {
            this.To.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer Tm;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tm = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.Tm;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity Tp;

        LoadPlayerScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.Tp = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.Tp;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity Tt;
        private final LeaderboardScoreBuffer Tu;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.Tt = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.Tu = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.Tt;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.Tu;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer Td;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Td = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.Td;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer Tk;

        LoadGameSearchSuggestionsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tk = new GameSearchSuggestionBuffer(dataHolder);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer Tj;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tj = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer Tl;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tl = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.Tl;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer Ti;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Ti = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.Ti;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status cc;
        private final String RL;

        UpdateAchievementResultImpl(int n, String string) {
            this.cc = GamesStatusCodes.zzps(n);
            this.RL = string;
        }

        public Status getStatus() {
            return this.cc;
        }

        @Override
        public String getAchievementId() {
            return this.RL;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer Tg;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Tg = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.Tg;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzpy {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzps(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzqs.zzb<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int ob;
        private final String TM;
        private final int TN;

        RealTimeMessageSentNotifier(int n, int n2, String string) {
            this.ob = n;
            this.TN = n2;
            this.TM = string;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.ob, this.TN, this.TM);
            }
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzqs.zzb<RealTimeMessageReceivedListener> {
        private final RealTimeMessage TB;

        MessageReceivedNotifier(RealTimeMessage realTimeMessage) {
            this.TB = realTimeMessage;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.TB);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzqs.zzb<RoomStatusUpdateListener> {
        private final String TH;

        P2PDisconnectedNotifier(String string) {
            this.TH = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.TH);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzqs.zzb<RoomStatusUpdateListener> {
        private final String TH;

        P2PConnectedNotifier(String string) {
            this.TH = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.TH);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzqs.zzb<RoomUpdateListener> {
        private final int ob;
        private final String Te;

        LeftRoomNotifier(int n, String string) {
            this.ob = n;
            this.Te = string;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.ob, this.Te);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> SJ = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.SJ.add(stringArray[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.SJ);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzpx<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzbi(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzpx<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzbi(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzqs.zzb<OnNearbyPlayerDetectedListener> {
        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(null);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class SocialInviteRemovedNotifier
    implements zzqs.zzb<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite Ua;

        SocialInviteRemovedNotifier(SocialInvite socialInvite) {
            this.Ua = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zzb(this.Ua);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class SocialInviteUpdateReceivedNotifier
    implements zzqs.zzb<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite Ua;

        SocialInviteUpdateReceivedNotifier(SocialInvite socialInvite) {
            this.Ua = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zza(this.Ua);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzqs.zzb<OnRequestReceivedListener> {
        private final String zzbvu;

        RequestRemovedNotifier(String string) {
            this.zzbvu = string;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzbvu);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzqs.zzb<OnRequestReceivedListener> {
        private final GameRequest TP;

        RequestReceivedNotifier(GameRequest gameRequest) {
            this.TP = gameRequest;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.TP);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzqs.zzb<QuestUpdateListener> {
        private final Quest SK;

        QuestCompletedNotifier(Quest quest) {
            this.SK = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.SK);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzqs.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final String Tz;

        MatchRemovedNotifier(String string) {
            this.Tz = string;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.Tz);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzqs.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch TA;

        MatchUpdateReceivedNotifier(TurnBasedMatch turnBasedMatch) {
            this.TA = turnBasedMatch;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.TA);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzqs.zzb<OnInvitationReceivedListener> {
        private final String bT;

        InvitationRemovedNotifier(String string) {
            this.bT = string;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.bT);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzqs.zzb<OnInvitationReceivedListener> {
        private final Invitation Tb;

        InvitationReceivedNotifier(Invitation invitation) {
            this.Tb = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.Tb);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class CaptureOverlayStateChangedNotifier
    implements zzqs.zzb<Videos.CaptureOverlayStateListener> {
        private final int SQ;

        CaptureOverlayStateChangedNotifier(int n) {
            this.SQ = n;
        }

        public void zza(Videos.CaptureOverlayStateListener captureOverlayStateListener) {
            captureOverlayStateListener.onCaptureOverlayStateChanged(this.SQ);
        }

        public void zzapg() {
        }

        public /* synthetic */ void zzu(Object object) {
            this.zza((Videos.CaptureOverlayStateListener)object);
        }
    }

    private static final class SetPlayerMutedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Players.LoadPlayersResult> zj;

        SetPlayerMutedBinderCallback(zzpr.zzb<Players.LoadPlayersResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbg(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class PlayerUnfriendedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Players.LoadPlayersResult> zj;

        PlayerUnfriendedBinderCallback(zzpr.zzb<Players.LoadPlayersResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbf(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class CancelFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Social.InviteUpdateResult> zj;

        CancelFriendInviteFirstPartyBinderCallback(zzpr.zzb<Social.InviteUpdateResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbe(DataHolder dataHolder) {
            this.zj.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class IgnoreFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Social.InviteUpdateResult> zj;

        IgnoreFriendInviteFirstPartyBinderCallback(zzpr.zzb<Social.InviteUpdateResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbd(DataHolder dataHolder) {
            this.zj.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class AcceptFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Social.InviteUpdateResult> zj;

        AcceptFriendInviteFirstPartyBinderCallback(zzpr.zzb<Social.InviteUpdateResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzba(DataHolder dataHolder) {
            this.zj.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class SendFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Social.InviteUpdateResult> zj;

        SendFriendInviteFirstPartyBinderCallback(zzpr.zzb<Social.InviteUpdateResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaz(DataHolder dataHolder) {
            this.zj.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class UpdateHeadlessCapturePermissionBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        UpdateHeadlessCapturePermissionBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbj(Status status) {
            this.zj.setResult((Object)status);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Videos.ListVideosResult> zj;

        ListVideosBinderCallback(zzpr.zzb<Videos.ListVideosResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzax(DataHolder dataHolder) {
            this.zj.setResult((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class CaptureStreamingUrlBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Videos.CaptureStreamingUrlResult> zj;

        CaptureStreamingUrlBinderCallback(zzpr.zzb<Videos.CaptureStreamingUrlResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzm(int n, String string) {
            this.zj.setResult((Object)new CaptureStreamingUrlResultImpl(new Status(n), string));
        }
    }

    private static final class CaptureStreamingMetadataBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Videos.CaptureStreamingMetadataResult> zj;

        CaptureStreamingMetadataBinderCallback(zzpr.zzb<Videos.CaptureStreamingMetadataResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, String string, String string2) {
            this.zj.setResult((Object)new CaptureStreamingMetadataResultImpl(new Status(n), string, string2));
        }
    }

    private static final class CaptureStreamingEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        CaptureStreamingEnabledBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzqh(int n) {
            this.zj.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureStreamingAvailabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Videos.CaptureStreamingAvailabilityResult> zj;

        CaptureStreamingAvailabilityBinderCallback(zzpr.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, boolean bl, boolean bl2) {
            this.zj.setResult((Object)new CaptureStreamingAvailabilityResultImpl(new Status(n), bl, bl2));
        }
    }

    private static final class CaptureStoppedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Videos.CaptureStoppedResult> zj;

        public CaptureStoppedBinderCallbacks(zzpr.zzb<Videos.CaptureStoppedResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, Uri uri) {
            this.zj.setResult((Object)new CaptureStoppedResultImpl(new Status(n), uri));
        }
    }

    private static final class CaptureStateBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Videos.CaptureStateResult> zj;

        public CaptureStateBinderCallbacks(zzpr.zzb<Videos.CaptureStateResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            this.zj.setResult((Object)new CaptureStateResultImpl(new Status(n), CaptureState.zzaa(bundle)));
        }
    }

    private static final class CaptureStartedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;
        private final Videos.CaptureRuntimeErrorCallback SR;

        public CaptureStartedBinderCallbacks(zzpr.zzb<Status> zzb2, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
            this.SR = (Videos.CaptureRuntimeErrorCallback)zzab.zzb((Object)captureRuntimeErrorCallback, (Object)"Callback must not be null");
        }

        @Override
        public void zzbk(Status status) {
            this.zj.setResult((Object)status);
        }

        @Override
        public void zzql(int n) {
            this.SR.zzsd(n);
        }
    }

    private static final class CapturePausedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        public CapturePausedBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzqm(int n) {
            this.zj.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureOverlayStateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqs<Videos.CaptureOverlayStateListener> HA;

        CaptureOverlayStateBinderCallback(zzqs<Videos.CaptureOverlayStateListener> zzqs2) {
            this.HA = (zzqs)zzab.zzb(zzqs2, (Object)"Callback must not be null");
        }

        @Override
        public void onCaptureOverlayStateChanged(int n) {
            this.HA.zza((zzqs.zzb)new CaptureOverlayStateChangedNotifier(n));
        }
    }

    private static final class CaptureLaunchGameAndOverlayBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> SP;

        CaptureLaunchGameAndOverlayBinderCallback(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl) {
            this.SP = (Games.BaseGamesApiMethodImpl)((Object)zzab.zzb(baseGamesApiMethodImpl, (Object)"Holder must not be null"));
        }

        @Override
        public void zzqg(int n) {
            this.SP.zzc((Result)new Status(n));
        }

        @Override
        public void zzbh(Status status) {
            this.SP.zzc((Result)status);
        }
    }

    private static final class CaptureCapabilitiesBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Videos.CaptureCapabilitiesResult> zj;

        CaptureCapabilitiesBinderCallback(zzpr.zzb<Videos.CaptureCapabilitiesResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, VideoCapabilities videoCapabilities) {
            this.zj.setResult((Object)new CaptureCapabilitiesResultImpl(new Status(n), videoCapabilities));
        }
    }

    private static final class CaptureAvailableBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Videos.CaptureAvailableResult> zj;

        CaptureAvailableBinderCallback(zzpr.zzb<Videos.CaptureAvailableResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, boolean bl) {
            this.zj.setResult((Object)new CaptureAvailableResultImpl(new Status(n), bl));
        }
    }

    private static final class HeadlessCaptureEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        HeadlessCaptureEnabledBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbi(Status status) {
            this.zj.setResult((Object)status);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Snapshots.DeleteSnapshotResult> zj;

        public SnapshotDeletedBinderCallbacks(zzpr.zzb<Snapshots.DeleteSnapshotResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(int n, String string) {
            this.zj.setResult((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Snapshots.CommitSnapshotResult> TX;

        public SnapshotCommittedBinderCallbacks(zzpr.zzb<Snapshots.CommitSnapshotResult> zzb2) {
            this.TX = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzao(DataHolder dataHolder) {
            this.TX.setResult((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Snapshots.OpenSnapshotResult> TY;

        public SnapshotOpenedBinderCallbacks(zzpr.zzb<Snapshots.OpenSnapshotResult> zzb2) {
            this.TY = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.TY.setResult((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.TY.setResult((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Snapshots.LoadSnapshotsResult> TZ;

        public SnapshotsLoadedBinderCallbacks(zzpr.zzb<Snapshots.LoadSnapshotsResult> zzb2) {
            this.TZ = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzan(DataHolder dataHolder) {
            this.TZ.setResult((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Stats.LoadPlayerStatsResult> zj;

        public PlayerStatsLoadedBinderCallbacks(zzpr.zzb<Stats.LoadPlayerStatsResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaw(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<AppContents.LoadAppContentResult> SL;

        public AppContentLoadedBinderCallbacks(zzpr.zzb<AppContents.LoadAppContentResult> zzb2) {
            this.SL = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.SL.setResult((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Quests.LoadQuestsResult> TL;

        public QuestsLoadedBinderCallbacks(zzpr.zzb<Quests.LoadQuestsResult> zzb2) {
            this.TL = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzat(DataHolder dataHolder) {
            this.TL.setResult((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Quests.ClaimMilestoneResult> TJ;
        private final String TK;

        public QuestMilestoneClaimBinderCallbacks(zzpr.zzb<Quests.ClaimMilestoneResult> zzb2, String string) {
            this.TJ = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
            this.TK = (String)zzab.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzap(DataHolder dataHolder) {
            this.TJ.setResult((Object)new ClaimMilestoneResultImpl(dataHolder, this.TK));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Quests.AcceptQuestResult> TI;

        public QuestAcceptedBinderCallbacks(zzpr.zzb<Quests.AcceptQuestResult> zzb2) {
            this.TI = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaq(DataHolder dataHolder) {
            this.TI.setResult((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Requests.LoadRequestSummariesResult> TR;

        public RequestSummariesLoadedBinderCallbacks(zzpr.zzb<Requests.LoadRequestSummariesResult> zzb2) {
            this.TR = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzam(DataHolder dataHolder) {
            this.TR.setResult((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Requests.LoadRequestsResult> TS;

        public RequestsLoadedBinderCallbacks(zzpr.zzb<Requests.LoadRequestsResult> zzb2) {
            this.TS = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzps(n);
            this.TS.setResult((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Requests.SendRequestResult> TQ;

        public RequestSentBinderCallbacks(zzpr.zzb<Requests.SendRequestResult> zzb2) {
            this.TQ = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzal(DataHolder dataHolder) {
            this.TQ.setResult((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Requests.UpdateRequestsResult> TT;

        public RequestsUpdatedBinderCallbacks(zzpr.zzb<Requests.UpdateRequestsResult> zzb2) {
            this.TT = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzak(DataHolder dataHolder) {
            this.TT.setResult((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager SD;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.SD = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzbhy() {
            return new PopupLocationInfoParcelable(this.SD.zzbjr());
        }
    }

    private static final class GetServerAuthCodeBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Games.GetServerAuthCodeResult> zj;

        public GetServerAuthCodeBinderCallbacks(zzpr.zzb<Games.GetServerAuthCodeResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzps(n);
            this.zj.setResult((Object)new GetServerAuthCodeResultImpl(status, string));
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Games.GetTokenResult> zj;

        public GetAuthTokenBinderCallbacks(zzpr.zzb<Games.GetTokenResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzps(n);
            this.zj.setResult((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        public SignOutCompleteBinderCallbacks(zzpr.zzb<Status> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbhx() {
            Status status = GamesStatusCodes.zzps(0);
            this.zj.setResult((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Notifications.InboxCountResult> zj;

        InboxCountsLoadedBinderCallback(zzpr.zzb<Notifications.InboxCountResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzps(n);
            this.zj.setResult((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        ContactSettingsUpdatedBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzqe(int n) {
            this.zj.setResult((Object)GamesStatusCodes.zzps(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Notifications.ContactSettingLoadResult> zj;

        ContactSettingsLoadedBinderCallback(zzpr.zzb<Notifications.ContactSettingLoadResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzai(DataHolder dataHolder) {
            this.zj.setResult((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Notifications.GameMuteStatusLoadResult> zj;

        GameMuteStatusLoadedBinderCallback(zzpr.zzb<Notifications.GameMuteStatusLoadResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzag(DataHolder dataHolder) {
            this.zj.setResult((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Notifications.GameMuteStatusChangeResult> zj;

        GameMuteStatusChangedBinderCallback(zzpr.zzb<Notifications.GameMuteStatusChangeResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zj.setResult((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzqs<RealTimeMultiplayer.ReliableMessageSentCallback> TO;

        public RealTimeReliableMessageBinderCallbacks(zzqs<RealTimeMultiplayer.ReliableMessageSentCallback> zzqs2) {
            this.TO = zzqs2;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.TO != null) {
                this.TO.zza((zzqs.zzb)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqs<? extends RoomUpdateListener> TU;
        private final zzqs<? extends RoomStatusUpdateListener> TV;
        private final zzqs<RealTimeMessageReceivedListener> TW;

        public RoomBinderCallbacks(zzqs<RoomUpdateListener> zzqs2) {
            this.TU = (zzqs)zzab.zzb(zzqs2, (Object)"Callbacks must not be null");
            this.TV = null;
            this.TW = null;
        }

        public RoomBinderCallbacks(zzqs<? extends RoomUpdateListener> zzqs2, zzqs<? extends RoomStatusUpdateListener> zzqs3, zzqs<RealTimeMessageReceivedListener> zzqs4) {
            this.TU = (zzqs)zzab.zzb(zzqs2, (Object)"Callbacks must not be null");
            this.TV = zzqs3;
            this.TW = zzqs4;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.TU.zza((zzqs.zzb)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzaa(DataHolder dataHolder) {
            this.TU.zza((zzqs.zzb)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int n, String string) {
            this.TU.zza((zzqs.zzb)new LeftRoomNotifier(n, string));
        }

        @Override
        public void zzad(DataHolder dataHolder) {
            this.TU.zza((zzqs.zzb)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzab(DataHolder dataHolder) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzac(DataHolder dataHolder) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzae(DataHolder dataHolder) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzaf(DataHolder dataHolder) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String string) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new P2PConnectedNotifier(string));
            }
        }

        @Override
        public void onP2PDisconnected(String string) {
            if (this.TV != null) {
                this.TV.zza((zzqs.zzb)new P2PDisconnectedNotifier(string));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.TW != null) {
                this.TW.zza((zzqs.zzb)new MessageReceivedNotifier(realTimeMessage));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<TurnBasedMultiplayer.CancelMatchResult> Uc;

        public TurnBasedMatchCanceledBinderCallbacks(zzpr.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2) {
            this.Uc = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(int n, String string) {
            Status status = GamesStatusCodes.zzps(n);
            this.Uc.setResult((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<TurnBasedMultiplayer.LeaveMatchResult> Ue;

        public TurnBasedMatchLeftBinderCallbacks(zzpr.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2) {
            this.Ue = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.Ue.setResult((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<TurnBasedMultiplayer.UpdateMatchResult> Ug;

        public TurnBasedMatchUpdatedBinderCallbacks(zzpr.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2) {
            this.Ug = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.Ug.setResult((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<TurnBasedMultiplayer.InitiateMatchResult> Ud;

        public TurnBasedMatchInitiatedBinderCallbacks(zzpr.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2) {
            this.Ud = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.Ud.setResult((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<TurnBasedMultiplayer.LoadMatchResult> Uf;

        public TurnBasedMatchLoadedBinderCallbacks(zzpr.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2) {
            this.Uf = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.Uf.setResult((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<TurnBasedMultiplayer.LoadMatchesResult> Uh;

        public TurnBasedMatchesLoadedBinderCallbacks(zzpr.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2) {
            this.Uh = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzps(n);
            this.Uh.setResult((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Leaderboards.SubmitScoreResult> zj;

        public SubmitScoreBinderCallbacks(zzpr.zzb<Leaderboards.SubmitScoreResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zj.setResult((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class UpdateProfileDiscoverabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        UpdateProfileDiscoverabilityBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = zzb2;
        }

        @Override
        public void zzqk(int n) {
            this.zj.setResult((Object)new Status(n));
        }
    }

    private static final class UpdateAutoSignInBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        UpdateAutoSignInBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = zzb2;
        }

        @Override
        public void zzqj(int n) {
            this.zj.setResult((Object)new Status(n));
        }
    }

    private static final class DeletePlayerBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        DeletePlayerBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = zzb2;
        }

        @Override
        public void zzqi(int n) {
            this.zj.setResult((Object)new Status(n));
        }
    }

    private static final class GamerProfileUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Players.UpdateGamerProfileResult> zj;

        GamerProfileUpdatedBinderCallback(zzpr.zzb<Players.UpdateGamerProfileResult> zzb2) {
            this.zj = zzb2;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            this.zj.setResult((Object)new UpdateGamerProfileResultImpl(n, bundle));
        }
    }

    private static final class StockProfileImagesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Players.LoadStockProfileImagesResult> zj;

        StockProfileImagesLoadedBinderCallback(zzpr.zzb<Players.LoadStockProfileImagesResult> zzb2) {
            this.zj = zzb2;
        }

        @Override
        public void zzay(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadStockProfileImagesResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Status> zj;

        ProfileSettingsUpdatedBinderCallback(zzpr.zzb<Status> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzqf(int n) {
            this.zj.setResult((Object)GamesStatusCodes.zzps(n));
        }
    }

    private static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Players.LoadProfileSettingsResult> zj;

        ProfileSettingsLoadedBinderCallback(zzpr.zzb<Players.LoadProfileSettingsResult> zzb2) {
            this.zj = zzb2;
        }

        @Override
        public void zzav(DataHolder dataHolder) {
            this.zj.setResult((Object)new ProfileSettingsEntity(dataHolder));
            dataHolder.close();
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Players.LoadXpStreamResult> zj;

        PlayerXpStreamLoadedBinderCallback(zzpr.zzb<Players.LoadXpStreamResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzau(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Players.LoadXpForGameCategoriesResult> zj;

        PlayerXpForGameCategoriesLoadedBinderCallback(zzpr.zzb<Players.LoadXpForGameCategoriesResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzps(n);
            this.zj.setResult((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class InvitesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Social.LoadInvitesResult> zj;

        InvitesLoadedBinderCallback(zzpr.zzb<Social.LoadInvitesResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbh(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadInvitesResultImpl(dataHolder));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Players.LoadPlayersResult> zj;

        PlayersLoadedBinderCallback(zzpr.zzb<Players.LoadPlayersResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class SocialInviteUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbb(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzqs.zzb)new SocialInviteUpdateReceivedNotifier(socialInvite));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbc(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzqs.zzb)new SocialInviteRemovedNotifier(socialInvite));
            }
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqs<OnRequestReceivedListener> HA;

        RequestReceivedBinderCallback(zzqs<OnRequestReceivedListener> zzqs2) {
            this.HA = zzqs2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.HA.zza((zzqs.zzb)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String string) {
            this.HA.zza((zzqs.zzb)new RequestRemovedNotifier(string));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqs<QuestUpdateListener> HA;

        QuestUpdateBinderCallback(zzqs<QuestUpdateListener> zzqs2) {
            this.HA = zzqs2;
        }

        @Override
        public void zzar(DataHolder dataHolder) {
            Quest quest = this.zzbk(dataHolder);
            if (quest != null) {
                this.HA.zza((zzqs.zzb)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzbk(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqs<OnTurnBasedMatchUpdateReceivedListener> HA;

        MatchUpdateReceivedBinderCallback(zzqs<OnTurnBasedMatchUpdateReceivedListener> zzqs2) {
            this.HA = zzqs2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.HA.zza((zzqs.zzb)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String string) {
            this.HA.zza((zzqs.zzb)new MatchRemovedNotifier(string));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqs<OnInvitationReceivedListener> HA;

        InvitationReceivedBinderCallback(zzqs<OnInvitationReceivedListener> zzqs2) {
            this.HA = zzqs2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.HA.zza((zzqs.zzb)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String string) {
            this.HA.zza((zzqs.zzb)new InvitationRemovedNotifier(string));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Invitations.LoadInvitationsResult> zj;

        InvitationsLoadedBinderCallback(zzpr.zzb<Invitations.LoadInvitationsResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Leaderboards.LoadPlayerScoreResult> zj;

        PlayerLeaderboardScoreLoadedBinderCallback(zzpr.zzb<Leaderboards.LoadPlayerScoreResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaj(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Leaderboards.LoadScoresResult> zj;

        LeaderboardScoresLoadedBinderCallback(zzpr.zzb<Leaderboards.LoadScoresResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zj.setResult((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Leaderboards.LeaderboardMetadataResult> zj;

        LeaderboardsLoadedBinderCallback(zzpr.zzb<Leaderboards.LeaderboardMetadataResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zj.setResult((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zj;

        GameSearchSuggestionsLoadedBinderCallback(zzpr.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<GamesMetadata.LoadGameInstancesResult> zj;

        GameInstancesLoadedBinderCallback(zzpr.zzb<GamesMetadata.LoadGameInstancesResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Events.LoadEventsResult> zj;

        EventsLoadedBinderCallback(zzpr.zzb<Events.LoadEventsResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<GamesMetadata.LoadGamesResult> zj;

        GamesLoadedBinderCallback(zzpr.zzb<GamesMetadata.LoadGamesResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Achievements.UpdateAchievementResult> zj;

        AchievementUpdatedBinderCallback(zzpr.zzb<Achievements.UpdateAchievementResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            this.zj.setResult((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzpr.zzb<Achievements.LoadAchievementsResult> zj;

        AchievementsLoadedBinderCallback(zzpr.zzb<Achievements.LoadAchievementsResult> zzb2) {
            this.zj = (zzpr.zzb)zzab.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zj.setResult((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzq(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzarw()).zzn(string, n);
                } else {
                    GamesLog.zzag("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

