/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.player;

import android.net.Uri;
import android.os.Parcel;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.player.ProfileSettingsEntityCreator;
import com.google.android.gms.games.internal.player.StockProfileImage;
import com.google.android.gms.games.internal.player.StockProfileImageEntity;

public class ProfileSettingsEntity
extends AbstractSafeParcelable
implements Players.LoadProfileSettingsResult {
    public static final ProfileSettingsEntityCreator CREATOR = new ProfileSettingsEntityCreator();
    private final int mVersionCode;
    private final Status cc;
    private final String Rv;
    private final boolean XC;
    private final boolean Rt;
    private final boolean XD;
    private final StockProfileImageEntity XE;
    private final boolean XF;
    private final boolean XG;

    public ProfileSettingsEntity(DataHolder dataHolder) {
        this.mVersionCode = 3;
        this.cc = new Status(dataHolder.getStatusCode());
        if (this.cc.isSuccess() && dataHolder.getCount() > 0) {
            int n = dataHolder.zzfo(0);
            this.Rv = dataHolder.zzd("gamer_tag", 0, n);
            this.XC = dataHolder.zze("gamer_tag_explicitly_set", 0, n);
            this.Rt = dataHolder.zze("profile_visible", 0, n);
            this.XD = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
            String string = dataHolder.zzd("stock_avatar_url", 0, n);
            String string2 = dataHolder.zzd("stock_avatar_uri", 0, n);
            this.XE = !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) ? new StockProfileImageEntity(string, Uri.parse((String)string2)) : null;
            this.XF = dataHolder.zze("profile_discoverable", 0, n);
            this.XG = dataHolder.zze("auto_sign_in", 0, n);
        } else {
            this.Rv = null;
            this.XC = false;
            this.Rt = false;
            this.XD = false;
            this.XE = null;
            this.XF = false;
            this.XG = false;
        }
    }

    ProfileSettingsEntity(int n, Status status, String string, boolean bl, boolean bl2, boolean bl3, StockProfileImageEntity stockProfileImageEntity, boolean bl4, boolean bl5) {
        this.mVersionCode = n;
        this.cc = status;
        this.Rv = string;
        this.XC = bl;
        this.Rt = bl2;
        this.XD = bl3;
        this.XE = stockProfileImageEntity;
        this.XF = bl4;
        this.XG = bl5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String zzbgd() {
        return this.Rv;
    }

    @Override
    public boolean zzbgn() {
        return this.XC;
    }

    @Override
    public boolean zzbgg() {
        return this.Rt;
    }

    @Override
    public boolean zzbgl() {
        return this.XD;
    }

    @Override
    public StockProfileImage zzbgm() {
        return this.XE;
    }

    @Override
    public boolean zzbgo() {
        return this.XF;
    }

    @Override
    public boolean zzbgp() {
        return this.XG;
    }

    public Status getStatus() {
        return this.cc;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.Rv, this.XC, this.Rt, this.XD, this.cc, this.XE, this.XF, this.XG});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Players.LoadProfileSettingsResult)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Players.LoadProfileSettingsResult loadProfileSettingsResult = (Players.LoadProfileSettingsResult)object;
        return zzaa.equal((Object)this.Rv, (Object)loadProfileSettingsResult.zzbgd()) && zzaa.equal((Object)this.XC, (Object)loadProfileSettingsResult.zzbgn()) && zzaa.equal((Object)this.Rt, (Object)loadProfileSettingsResult.zzbgg()) && zzaa.equal((Object)this.XD, (Object)loadProfileSettingsResult.zzbgl()) && zzaa.equal((Object)this.cc, (Object)loadProfileSettingsResult.getStatus()) && zzaa.equal((Object)this.XE, (Object)loadProfileSettingsResult.zzbgm()) && zzaa.equal((Object)this.XF, (Object)loadProfileSettingsResult.zzbgo()) && zzaa.equal((Object)this.XG, (Object)loadProfileSettingsResult.zzbgp());
    }

    public String toString() {
        return zzaa.zzz((Object)this).zzg("GamerTag", (Object)this.Rv).zzg("IsGamerTagExplicitlySet", (Object)this.XC).zzg("IsProfileVisible", (Object)this.Rt).zzg("IsVisibilityExplicitlySet", (Object)this.XD).zzg("Status", (Object)this.cc).zzg("StockProfileImage", (Object)this.XE).zzg("IsProfileDiscoverable", (Object)this.XF).zzg("AutoSignIn", (Object)this.XG).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ProfileSettingsEntityCreator.zza(this, parcel, n);
    }
}

