/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;

public final class LeaderboardScoreRef
extends zzc
implements LeaderboardScore {
    private final PlayerRef Yc;

    LeaderboardScoreRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.Yc = new PlayerRef(dataHolder, n);
    }

    @Override
    public long getRank() {
        return this.getLong("rank");
    }

    @Override
    public String getDisplayRank() {
        return this.getString("display_rank");
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        this.zza("display_rank", charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.getString("display_score");
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        this.zza("display_score", charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.getLong("raw_score");
    }

    @Override
    public long getTimestampMillis() {
        return this.getLong("achieved_timestamp");
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzhh("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.Yc.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhh("external_player_id")) {
            this.zza("default_display_name", charArrayBuffer);
            return;
        }
        this.Yc.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzhh("external_player_id")) {
            return this.zzhg("default_display_image_uri");
        }
        return this.Yc.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzhh("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.Yc.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzhh("external_player_id")) {
            return null;
        }
        return this.Yc.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzhh("external_player_id")) {
            return null;
        }
        return this.Yc.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        if (this.zzhh("external_player_id")) {
            return null;
        }
        return this.Yc;
    }

    @Override
    public String getScoreTag() {
        return this.getString("score_tag");
    }

    public LeaderboardScore zzblb() {
        return new LeaderboardScoreEntity(this);
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    public /* synthetic */ Object freeze() {
        return this.zzblb();
    }
}

