/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String TH;
    private final String dH;
    private final Uri QE;
    private final Uri QF;
    private final int zzblz;
    private final String Sx;
    private final boolean Yx;
    private final PlayerEntity RS;
    private final int gR;
    private final ParticipantResult Yy;
    private final String QP;
    private final String QQ;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.TH = participant.getParticipantId();
        this.dH = participant.getDisplayName();
        this.QE = participant.getIconImageUri();
        this.QF = participant.getHiResImageUri();
        this.zzblz = participant.getStatus();
        this.Sx = participant.zzbhz();
        this.Yx = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.RS = player == null ? null : new PlayerEntity(player);
        this.gR = participant.getCapabilities();
        this.Yy = participant.getResult();
        this.QP = participant.getIconImageUrl();
        this.QQ = participant.getHiResImageUrl();
    }

    ParticipantEntity(int n, String string, String string2, Uri uri, Uri uri2, int n2, String string3, boolean bl, PlayerEntity playerEntity, int n3, ParticipantResult participantResult, String string4, String string5) {
        this.mVersionCode = n;
        this.TH = string;
        this.dH = string2;
        this.QE = uri;
        this.QF = uri2;
        this.zzblz = n2;
        this.Sx = string3;
        this.Yx = bl;
        this.RS = playerEntity;
        this.gR = n3;
        this.Yy = participantResult;
        this.QP = string4;
        this.QQ = string5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzblz;
    }

    @Override
    public String zzbhz() {
        return this.Sx;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.Yx;
    }

    @Override
    public String getDisplayName() {
        if (this.RS == null) {
            return this.dH;
        }
        return this.RS.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.RS == null) {
            zzg.zzb((String)this.dH, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.RS.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.RS == null) {
            return this.QE;
        }
        return this.RS.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.RS == null) {
            return this.QP;
        }
        return this.RS.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.RS == null) {
            return this.QF;
        }
        return this.RS.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.RS == null) {
            return this.QQ;
        }
        return this.RS.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.TH;
    }

    @Override
    public Player getPlayer() {
        return this.RS;
    }

    @Override
    public ParticipantResult getResult() {
        return this.Yy;
    }

    @Override
    public int getCapabilities() {
        return this.gR;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzaa.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzbhz(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzaa.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzaa.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzaa.equal((Object)participant2.zzbhz(), (Object)participant.zzbhz()) && zzaa.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzaa.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzaa.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzaa.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzaa.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzaa.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzaa.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzaa.zzz((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzbhz()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzasq()) {
            ParticipantEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.TH);
            parcel.writeString(this.dH);
            parcel.writeString(this.QE == null ? null : this.QE.toString());
            parcel.writeString(this.QF == null ? null : this.QF.toString());
            parcel.writeInt(this.zzblz);
            parcel.writeString(this.Sx);
            parcel.writeInt(this.Yx ? 1 : 0);
            parcel.writeInt(this.RS == null ? 0 : 1);
            if (this.RS != null) {
                this.RS.writeToParcel(parcel, n);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzlo(Parcel parcel) {
            boolean bl = ParticipantEntity.zzf(ParticipantEntity.zzasp());
            if (bl || ParticipantEntity.zzhl((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzlo(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            Object var14_14 = null;
            Object var15_15 = null;
            Object var16_16 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, 7, null, null, null);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzlo(parcel);
        }
    }
}

