/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer YP;
    private final TurnBasedMatchBuffer YQ;
    private final TurnBasedMatchBuffer YR;
    private final TurnBasedMatchBuffer YS;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.YP = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.YQ = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.YR = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        this.YS = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzqs(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.YP;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.YQ;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.YR;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.YS;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.YP != null) {
            this.YP.release();
        }
        if (this.YQ != null) {
            this.YQ.release();
        }
        if (this.YR != null) {
            this.YR.release();
        }
        if (this.YS != null) {
            this.YS.release();
        }
    }

    public boolean hasData() {
        if (this.YP != null && this.YP.getCount() > 0) {
            return true;
        }
        if (this.YQ != null && this.YQ.getCount() > 0) {
            return true;
        }
        if (this.YR != null && this.YR.getCount() > 0) {
            return true;
        }
        return this.YS != null && this.YS.getCount() > 0;
    }
}

