/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
extends AbstractSafeParcelable
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final int mVersionCode;
    private final GameEntity WG;
    private final String Tz;
    private final String YM;
    private final long Yq;
    private final String YU;
    private final long RV;
    private final String YV;
    private final int YW;
    private final int Yu;
    private final int mVersion;
    private final byte[] YX;
    private final ArrayList<ParticipantEntity> Yt;
    private final String YY;
    private final byte[] YZ;
    private final int Za;
    private final Bundle YK;
    private final int Zb;
    private final boolean Zc;
    private final String zzcvi;
    private final String Zd;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.mVersionCode = 2;
        this.WG = new GameEntity(turnBasedMatch.getGame());
        this.Tz = turnBasedMatch.getMatchId();
        this.YM = turnBasedMatch.getCreatorId();
        this.Yq = turnBasedMatch.getCreationTimestamp();
        this.YU = turnBasedMatch.getLastUpdaterId();
        this.RV = turnBasedMatch.getLastUpdatedTimestamp();
        this.YV = turnBasedMatch.getPendingParticipantId();
        this.YW = turnBasedMatch.getStatus();
        this.Zb = turnBasedMatch.getTurnStatus();
        this.Yu = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.YY = turnBasedMatch.getRematchId();
        this.Za = turnBasedMatch.getMatchNumber();
        this.YK = turnBasedMatch.getAutoMatchCriteria();
        this.Zc = turnBasedMatch.isLocallyModified();
        this.zzcvi = turnBasedMatch.getDescription();
        this.Zd = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.YX = null;
        } else {
            this.YX = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.YX, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.YZ = null;
        } else {
            this.YZ = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.YZ, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.Yt = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.Yt.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int n, GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n2, int n3, int n4, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n5, Bundle bundle, int n6, boolean bl, String string6, String string7) {
        this.mVersionCode = n;
        this.WG = gameEntity;
        this.Tz = string;
        this.YM = string2;
        this.Yq = l;
        this.YU = string3;
        this.RV = l2;
        this.YV = string4;
        this.YW = n2;
        this.Zb = n6;
        this.Yu = n3;
        this.mVersion = n4;
        this.YX = byArray;
        this.Yt = arrayList;
        this.YY = string5;
        this.YZ = byArray2;
        this.Za = n5;
        this.YK = bundle;
        this.Zc = bl;
        this.zzcvi = string6;
        this.Zd = string7;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.WG;
    }

    @Override
    public String getMatchId() {
        return this.Tz;
    }

    @Override
    public String getCreatorId() {
        return this.YM;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Yq;
    }

    @Override
    public String getLastUpdaterId() {
        return this.YU;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.RV;
    }

    @Override
    public String getPendingParticipantId() {
        return this.YV;
    }

    @Override
    public int getStatus() {
        return this.YW;
    }

    @Override
    public int getTurnStatus() {
        return this.Zb;
    }

    @Override
    public String getDescription() {
        return this.zzcvi;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.Zd;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzcvi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.Yu;
    }

    @Override
    public byte[] getData() {
        return this.YX;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.YY;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.YZ;
    }

    @Override
    public int getMatchNumber() {
        return this.Za;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.YK;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.YK == null) {
            return 0;
        }
        return this.YK.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.YW == 2 && this.YY == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.Zc;
    }

    @Override
    public int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.Yt);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzaa.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzaa.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzaa.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzaa.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzaa.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzaa.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzaa.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzaa.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzaa.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzaa.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzaa.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzaa.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzaa.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzaa.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzaa.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzaa.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzaa.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzaa.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzaa.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzaa.zzz((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        TurnBasedMatchEntityCreator.zza(this, parcel, n);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

