/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
extends AbstractSafeParcelable
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity WG;
    private final PlayerEntity Zq;
    private final byte[] YX;
    private final String zzbvu;
    private final ArrayList<PlayerEntity> Zr;
    private final int it;
    private final long Yq;
    private final long Zs;
    private final Bundle Zt;
    private final int zzblz;

    public GameRequestEntity(GameRequest gameRequest) {
        this.mVersionCode = 2;
        this.WG = new GameEntity(gameRequest.getGame());
        this.Zq = new PlayerEntity(gameRequest.getSender());
        this.zzbvu = gameRequest.getRequestId();
        this.it = gameRequest.getType();
        this.Yq = gameRequest.getCreationTimestamp();
        this.Zs = gameRequest.getExpirationTimestamp();
        this.zzblz = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.YX = null;
        } else {
            this.YX = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.YX, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.Zr = new ArrayList(n);
        this.Zt = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.Zr.add((PlayerEntity)player);
            this.Zt.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int n, GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n2, long l, long l2, Bundle bundle, int n3) {
        this.mVersionCode = n;
        this.WG = gameEntity;
        this.Zq = playerEntity;
        this.YX = byArray;
        this.zzbvu = string;
        this.Zr = arrayList;
        this.it = n2;
        this.Yq = l;
        this.Zs = l2;
        this.Zt = bundle;
        this.zzblz = n3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzbvu;
    }

    @Override
    public Game getGame() {
        return this.WG;
    }

    @Override
    public Player getSender() {
        return this.Zq;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.Zr);
    }

    @Override
    public boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public byte[] getData() {
        return this.YX;
    }

    @Override
    public int getType() {
        return this.it;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Yq;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.Zs;
    }

    @Override
    public int getRecipientStatus(String string) {
        return this.Zt.getInt(string, 0);
    }

    @Override
    public int getStatus() {
        return this.zzblz;
    }

    public Bundle zzblk() {
        return this.Zt;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzaa.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzaa.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzaa.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzaa.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzaa.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzaa.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzaa.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzaa.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzaa.zzz((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameRequestEntityCreator.zza(this, parcel, n);
    }
}

