/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzbll();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzcvi;
        private Long Zx;
        private Long Zy;
        private BitmapTeleporter Zz;
        private Uri ZA;

        public Builder setDescription(String string) {
            this.zzcvi = string;
            return this;
        }

        public Builder setPlayedTimeMillis(long l) {
            this.Zx = l;
            return this;
        }

        public Builder setProgressValue(long l) {
            this.Zy = l;
            return this;
        }

        public Builder setCoverImage(Bitmap bitmap) {
            this.Zz = new BitmapTeleporter(bitmap);
            this.ZA = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzcvi = snapshotMetadata.getDescription();
            this.Zx = snapshotMetadata.getPlayedTime();
            this.Zy = snapshotMetadata.getProgressValue();
            if (this.Zx == -1L) {
                this.Zx = null;
            }
            this.ZA = snapshotMetadata.getCoverImageUri();
            if (this.ZA != null) {
                this.Zz = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzcvi, this.Zx, this.Zz, this.ZA, this.Zy);
        }
    }
}

