/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.video.VideoCapabilitiesCreator;
import com.google.android.gms.games.video.VideoConfiguration;

public final class VideoCapabilities
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new VideoCapabilitiesCreator();
    private final int mVersionCode;
    private final boolean aae;
    private final boolean aaf;
    private final boolean aag;
    private final boolean[] aah;
    private final boolean[] aai;

    public VideoCapabilities(int n, boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.mVersionCode = n;
        this.aae = bl;
        this.aaf = bl2;
        this.aag = bl3;
        this.aah = blArray;
        this.aai = blArray2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean isMicSupported() {
        return this.aaf;
    }

    public boolean isCameraSupported() {
        return this.aae;
    }

    public boolean isWriteStorageSupported() {
        return this.aag;
    }

    public boolean[] zzblr() {
        return this.aah;
    }

    public boolean[] zzbls() {
        return this.aai;
    }

    public boolean supportsCaptureMode(int n) {
        zzab.zzbm((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.aah[n];
    }

    public boolean supportsQualityLevel(int n) {
        zzab.zzbm((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.aai[n];
    }

    public boolean isFullySupported(int n, int n2) {
        return this.aae && this.aaf && this.aag && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzblr(), this.zzbls(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzaa.equal((Object)videoCapabilities.zzblr(), (Object)this.zzblr()) && zzaa.equal((Object)videoCapabilities.zzbls(), (Object)this.zzbls()) && zzaa.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzaa.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzaa.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public String toString() {
        return zzaa.zzz((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.zzblr()).zzg("SupportedQualityLevels", (Object)this.zzbls()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoCapabilitiesCreator.zza(this, parcel, n);
    }
}

