/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private String od;
    private String dC;
    private final Uri Pg;
    private final Uri Ph;
    private final long PQ;
    private final int PR;
    private final long PS;
    private final String Pr;
    private final String Ps;
    private final String DZ;
    private final MostRecentGameInfoEntity PT;
    private final PlayerLevelInfo PU;
    private final boolean PV;
    private final boolean PW;
    private final String PX;
    private final String mName;
    private final Uri PY;
    private final String PZ;
    private final Uri Qa;
    private final String Qb;
    private final int Qc;
    private final long Qd;
    private final boolean zzcqc;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean bl) {
        this.mVersionCode = 14;
        this.od = bl ? player.getPlayerId() : null;
        this.dC = player.getDisplayName();
        this.Pg = player.getIconImageUri();
        this.Pr = player.getIconImageUrl();
        this.Ph = player.getHiResImageUri();
        this.Ps = player.getHiResImageUrl();
        this.PQ = player.getRetrievedTimestamp();
        this.PR = player.zzbfh();
        this.PS = player.getLastPlayedWithTimestamp();
        this.DZ = player.getTitle();
        this.PV = player.zzbfi();
        MostRecentGameInfo mostRecentGameInfo = player.zzbfj();
        this.PT = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.PU = player.getLevelInfo();
        this.PW = player.zzbfg();
        this.PX = player.zzbff();
        this.mName = player.getName();
        this.PY = player.getBannerImageLandscapeUri();
        this.PZ = player.getBannerImageLandscapeUrl();
        this.Qa = player.getBannerImagePortraitUri();
        this.Qb = player.getBannerImagePortraitUrl();
        this.Qc = player.zzbfk();
        this.Qd = player.zzbfl();
        this.zzcqc = player.isMuted();
        if (bl) {
            zzb.zzu((Object)this.od);
        }
        zzb.zzu((Object)this.dC);
        zzb.zzbn((this.PQ > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int n, String string, String string2, Uri uri, Uri uri2, long l, int n2, long l2, String string3, String string4, String string5, MostRecentGameInfoEntity mostRecentGameInfoEntity, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n3, long l3, boolean bl3) {
        this.mVersionCode = n;
        this.od = string;
        this.dC = string2;
        this.Pg = uri;
        this.Pr = string3;
        this.Ph = uri2;
        this.Ps = string4;
        this.PQ = l;
        this.PR = n2;
        this.PS = l2;
        this.DZ = string5;
        this.PV = bl;
        this.PT = mostRecentGameInfoEntity;
        this.PU = playerLevelInfo;
        this.PW = bl2;
        this.PX = string6;
        this.mName = string7;
        this.PY = uri3;
        this.PZ = string8;
        this.Qa = uri4;
        this.Qb = string9;
        this.Qc = n3;
        this.Qd = l3;
        this.zzcqc = bl3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.od;
    }

    @Override
    public String getDisplayName() {
        return this.dC;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.dC, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String zzbff() {
        return this.PX;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzbfg() {
        return this.PW;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.Pg;
    }

    @Override
    public String getIconImageUrl() {
        return this.Pr;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.Ph;
    }

    @Override
    public String getHiResImageUrl() {
        return this.Ps;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.PQ;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.PS;
    }

    @Override
    public int zzbfh() {
        return this.PR;
    }

    @Override
    public boolean zzbfi() {
        return this.PV;
    }

    @Override
    public String getTitle() {
        return this.DZ;
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.DZ, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.PU;
    }

    @Override
    public MostRecentGameInfo zzbfj() {
        return this.PT;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.PY;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.PZ;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.Qa;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.Qb;
    }

    @Override
    public int zzbfk() {
        return this.Qc;
    }

    @Override
    public long zzbfl() {
        return this.Qd;
    }

    @Override
    public boolean isMuted() {
        return this.zzcqc;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzaa.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzbfg(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzbff(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzbfk(), player.zzbfl(), player.isMuted()});
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzaa.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzaa.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzaa.equal((Object)player2.zzbfg(), (Object)player.zzbfg()) && zzaa.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzaa.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzaa.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzaa.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzaa.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzaa.equal((Object)player2.zzbff(), (Object)player.zzbff()) && zzaa.equal((Object)player2.getName(), (Object)player.getName()) && zzaa.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzaa.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzaa.equal((Object)player2.zzbfk(), (Object)player.zzbfk()) && zzaa.equal((Object)player2.zzbfl(), (Object)player.zzbfl()) && zzaa.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzaa.zzx((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzbfg()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzbff()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzbfk()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzbfl()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzasu()) {
            PlayerEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.od);
            parcel.writeString(this.dC);
            parcel.writeString(this.Pg == null ? null : this.Pg.toString());
            parcel.writeString(this.Ph == null ? null : this.Ph.toString());
            parcel.writeLong(this.PQ);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzkv(Parcel parcel) {
            boolean bl = PlayerEntity.zzf(PlayerEntity.zzast());
            if (bl || PlayerEntity.zzhk((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzkv(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            int n = -1;
            long l2 = -1L;
            Object var16_14 = null;
            Object var17_15 = null;
            Object var18_16 = null;
            Object var19_17 = null;
            Object var20_18 = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Object var23_21 = null;
            Object var24_22 = null;
            Object var25_23 = null;
            Object var26_24 = null;
            int n2 = -1;
            long l3 = -1L;
            boolean bl4 = false;
            return new PlayerEntity(14, string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzkv(parcel);
        }
    }
}

