/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl SR;
    protected PopupLocationInfo SS;

    public static PopupManager zza(GamesClientImpl gamesClientImpl, int n) {
        if (zzs.zzavo()) {
            return new PopupManagerHCMR1(gamesClientImpl, n);
        }
        return new PopupManager(gamesClientImpl, n);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int n) {
        this.SR = gamesClientImpl;
        this.zzqv(n);
    }

    protected void zzqv(int n) {
        this.SS = new PopupLocationInfo(n, (IBinder)new Binder());
    }

    public void setGravity(int n) {
        this.SS.gravity = n;
    }

    public void zzr(View view) {
    }

    public void zzbiq() {
        this.SR.zza(this.SS.ST, this.SS.zzbip());
    }

    public Bundle zzbir() {
        return this.SS.zzbip();
    }

    public IBinder zzbis() {
        return this.SS.ST;
    }

    public PopupLocationInfo zzbit() {
        return this.SS;
    }

    public static final class PopupLocationInfo {
        public IBinder ST;
        public int gravity;
        public int SU = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int n, IBinder iBinder) {
            this.gravity = n;
            this.ST = iBinder;
        }

        public Bundle zzbip() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.SU);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    @TargetApi(value=12)
    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> SV;
        private boolean Rf = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int n) {
            super(gamesClientImpl, n);
        }

        @Override
        protected void zzqv(int n) {
            this.SS = new PopupLocationInfo(n, null);
        }

        @Override
        @TargetApi(value=16)
        public void zzr(View view) {
            Context context;
            View view2;
            this.SR.zzbib();
            if (this.SV != null) {
                view2 = (View)this.SV.get();
                context = this.SR.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (zzs.zzavr()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.SV = null;
            view2 = this.SR.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.zzaf("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view. Note that this may not work as expected in multi-screen environments");
            }
            if (view != null) {
                this.zzs(view);
                this.SV = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.zzag("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void zzbiq() {
            if (this.SS.ST != null) {
                super.zzbiq();
                return;
            }
            this.Rf = this.SV != null;
        }

        public void onViewAttachedToWindow(View view) {
            this.zzs(view);
        }

        public void onViewDetachedFromWindow(View view) {
            this.SR.zzbib();
            view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.SV == null) {
                return;
            }
            View view = (View)this.SV.get();
            if (view == null) {
                return;
            }
            this.zzs(view);
        }

        @TargetApi(value=17)
        private void zzs(View view) {
            Display display;
            int n = -1;
            if (zzs.zzavs()) {
                display = view.getDisplay();
                n = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n2 = view.getWidth();
            int n3 = view.getHeight();
            this.SS.SU = n;
            this.SS.ST = display;
            this.SS.left = nArray[0];
            this.SS.top = nArray[1];
            this.SS.right = nArray[0] + n2;
            this.SS.bottom = nArray[1] + n3;
            if (this.Rf) {
                this.zzbiq();
                this.Rf = false;
            }
        }
    }
}

