/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long Wr;
    private final String Ws;
    private final String Wt;
    private final long Wu;
    private final long Wv;
    private final String Ww;
    private final Uri Wx;
    private final Uri Wy;
    private final PlayerEntity Wz;
    private final String WA;
    private final String WB;
    private final String WC;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.Wr = leaderboardScore.getRank();
        this.Ws = (String)zzab.zzy((Object)leaderboardScore.getDisplayRank());
        this.Wt = (String)zzab.zzy((Object)leaderboardScore.getDisplayScore());
        this.Wu = leaderboardScore.getRawScore();
        this.Wv = leaderboardScore.getTimestampMillis();
        this.Ww = leaderboardScore.getScoreHolderDisplayName();
        this.Wx = leaderboardScore.getScoreHolderIconImageUri();
        this.Wy = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.Wz = player == null ? null : (PlayerEntity)player.freeze();
        this.WA = leaderboardScore.getScoreTag();
        this.WB = leaderboardScore.getScoreHolderIconImageUrl();
        this.WC = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.Wr;
    }

    @Override
    public String getDisplayRank() {
        return this.Ws;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Ws, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.Wt;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Wt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.Wu;
    }

    @Override
    public long getTimestampMillis() {
        return this.Wv;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.Wz == null) {
            return this.Ww;
        }
        return this.Wz.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.Wz == null) {
            zzg.zzb((String)this.Ww, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.Wz.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.Wz == null) {
            return this.Wx;
        }
        return this.Wz.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.Wz == null) {
            return this.WB;
        }
        return this.Wz.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.Wz == null) {
            return this.Wy;
        }
        return this.Wz.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.Wz == null) {
            return this.WC;
        }
        return this.Wz.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.Wz;
    }

    @Override
    public String getScoreTag() {
        return this.WA;
    }

    public LeaderboardScore zzbkd() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzaa.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzaa.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzaa.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzaa.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzaa.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzaa.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzaa.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzaa.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzaa.zzx((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzbkd();
    }
}

