/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String Si;
    private final String dC;
    private final Uri Pg;
    private final Uri Ph;
    private final int zzblv;
    private final String QY;
    private final boolean WY;
    private final PlayerEntity Qu;
    private final int gO;
    private final ParticipantResult WZ;
    private final String Pr;
    private final String Ps;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.Si = participant.getParticipantId();
        this.dC = participant.getDisplayName();
        this.Pg = participant.getIconImageUri();
        this.Ph = participant.getHiResImageUri();
        this.zzblv = participant.getStatus();
        this.QY = participant.zzbhb();
        this.WY = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.Qu = player == null ? null : new PlayerEntity(player);
        this.gO = participant.getCapabilities();
        this.WZ = participant.getResult();
        this.Pr = participant.getIconImageUrl();
        this.Ps = participant.getHiResImageUrl();
    }

    ParticipantEntity(int n, String string, String string2, Uri uri, Uri uri2, int n2, String string3, boolean bl, PlayerEntity playerEntity, int n3, ParticipantResult participantResult, String string4, String string5) {
        this.mVersionCode = n;
        this.Si = string;
        this.dC = string2;
        this.Pg = uri;
        this.Ph = uri2;
        this.zzblv = n2;
        this.QY = string3;
        this.WY = bl;
        this.Qu = playerEntity;
        this.gO = n3;
        this.WZ = participantResult;
        this.Pr = string4;
        this.Ps = string5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzblv;
    }

    @Override
    public String zzbhb() {
        return this.QY;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.WY;
    }

    @Override
    public String getDisplayName() {
        if (this.Qu == null) {
            return this.dC;
        }
        return this.Qu.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.Qu == null) {
            zzg.zzb((String)this.dC, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.Qu.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.Qu == null) {
            return this.Pg;
        }
        return this.Qu.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.Qu == null) {
            return this.Pr;
        }
        return this.Qu.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.Qu == null) {
            return this.Ph;
        }
        return this.Qu.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.Qu == null) {
            return this.Ps;
        }
        return this.Qu.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.Si;
    }

    @Override
    public Player getPlayer() {
        return this.Qu;
    }

    @Override
    public ParticipantResult getResult() {
        return this.WZ;
    }

    @Override
    public int getCapabilities() {
        return this.gO;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzaa.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzbhb(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzaa.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzaa.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzaa.equal((Object)participant2.zzbhb(), (Object)participant.zzbhb()) && zzaa.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzaa.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzaa.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzaa.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzaa.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzaa.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzaa.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzaa.zzx((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzbhb()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzasu()) {
            ParticipantEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.Si);
            parcel.writeString(this.dC);
            parcel.writeString(this.Pg == null ? null : this.Pg.toString());
            parcel.writeString(this.Ph == null ? null : this.Ph.toString());
            parcel.writeInt(this.zzblv);
            parcel.writeString(this.QY);
            parcel.writeInt(this.WY ? 1 : 0);
            parcel.writeInt(this.Qu == null ? 0 : 1);
            if (this.Qu != null) {
                this.Qu.writeToParcel(parcel, n);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzlp(Parcel parcel) {
            boolean bl = ParticipantEntity.zzf(ParticipantEntity.zzast());
            if (bl || ParticipantEntity.zzhk((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzlp(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            Object var14_14 = null;
            Object var15_15 = null;
            Object var16_16 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, 7, null, null, null);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzlp(parcel);
        }
    }
}

