/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer Xq;
    private final TurnBasedMatchBuffer Xr;
    private final TurnBasedMatchBuffer Xs;
    private final TurnBasedMatchBuffer Xt;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.Xq = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.Xr = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.Xs = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        this.Xt = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzqw(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.Xq;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.Xr;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.Xs;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.Xt;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.Xq != null) {
            this.Xq.release();
        }
        if (this.Xr != null) {
            this.Xr.release();
        }
        if (this.Xs != null) {
            this.Xs.release();
        }
        if (this.Xt != null) {
            this.Xt.release();
        }
    }

    public boolean hasData() {
        if (this.Xq != null && this.Xq.getCount() > 0) {
            return true;
        }
        if (this.Xr != null && this.Xr.getCount() > 0) {
            return true;
        }
        if (this.Xs != null && this.Xs.getCount() > 0) {
            return true;
        }
        return this.Xt != null && this.Xt.getCount() > 0;
    }
}

