/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.video.VideoCapabilitiesCreator;
import com.google.android.gms.games.video.VideoConfiguration;

public final class VideoCapabilities
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new VideoCapabilitiesCreator();
    private final int mVersionCode;
    private final boolean YF;
    private final boolean YG;
    private final boolean YH;
    private final boolean[] YI;
    private final boolean[] YJ;

    public VideoCapabilities(int n, boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.mVersionCode = n;
        this.YF = bl;
        this.YG = bl2;
        this.YH = bl3;
        this.YI = blArray;
        this.YJ = blArray2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean isMicSupported() {
        return this.YG;
    }

    public boolean isCameraSupported() {
        return this.YF;
    }

    public boolean isWriteStorageSupported() {
        return this.YH;
    }

    public boolean[] zzbkt() {
        return this.YI;
    }

    public boolean[] zzbku() {
        return this.YJ;
    }

    public boolean supportsCaptureMode(int n) {
        zzab.zzbn((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.YI[n];
    }

    public boolean supportsQualityLevel(int n) {
        zzab.zzbn((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.YJ[n];
    }

    public boolean isFullySupported(int n, int n2) {
        return this.YF && this.YG && this.YH && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzbkt(), this.zzbku(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzaa.equal((Object)videoCapabilities.zzbkt(), (Object)this.zzbkt()) && zzaa.equal((Object)videoCapabilities.zzbku(), (Object)this.zzbku()) && zzaa.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzaa.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzaa.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public String toString() {
        return zzaa.zzx((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.zzbkt()).zzg("SupportedQualityLevels", (Object)this.zzbku()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoCapabilitiesCreator.zza(this, parcel, n);
    }
}

