/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.video.VideoConfigurationCreator;

public final class VideoConfiguration
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new VideoConfigurationCreator();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int mVersionCode;
    private final int YK;
    private final int YD;
    private final String YL;
    private final String YM;
    private final String YN;
    private final String YO;
    private final boolean YP;

    private VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        this(2, n, n2, string, string2, string3, string4, bl);
    }

    public VideoConfiguration(int n, int n2, int n3, String string, String string2, String string3, String string4, boolean bl) {
        this.mVersionCode = n;
        zzab.zzbo((boolean)VideoConfiguration.isValidQualityLevel(n2, false));
        zzab.zzbo((boolean)VideoConfiguration.isValidCaptureMode(n3, false));
        this.YK = n2;
        this.YD = n3;
        this.YP = bl;
        if (n3 == 1) {
            this.YM = string2;
            this.YL = string;
            this.YN = string3;
            this.YO = string4;
        } else {
            zzab.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
            zzab.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
            zzab.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
            zzab.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
            this.YM = null;
            this.YL = null;
            this.YN = null;
            this.YO = null;
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getQualityLevel() {
        return this.YK;
    }

    public int getCaptureMode() {
        return this.YD;
    }

    public String zzbkv() {
        return this.YM;
    }

    public String getStreamUrl() {
        return this.YL;
    }

    public String zzbkw() {
        return this.YN;
    }

    public String zzbkx() {
        return this.YO;
    }

    public boolean zzbky() {
        return this.YP;
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoConfigurationCreator.zza(this, parcel, n);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int YK;
        private int YD;
        private boolean YP;
        private String YL;
        private String YM;
        private String YN;
        private String YO;

        public Builder(int n, int n2) {
            this.YK = n;
            this.YD = n2;
            this.YP = true;
            this.YL = null;
            this.YM = null;
            this.YN = null;
            this.YO = null;
        }

        public Builder setQualityLevel(int n) {
            this.YK = n;
            return this;
        }

        public Builder setCaptureMode(int n) {
            this.YD = n;
            return this;
        }

        public VideoConfiguration build() {
            return new VideoConfiguration(this.YK, this.YD, null, null, null, null, this.YP);
        }
    }
}

