/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames VO;
    private final PlayerLevelInfo Vx;
    private final MostRecentGameInfoRef VP;

    public PlayerRef(DataHolder dataHolder, int n) {
        this(dataHolder, n, null);
    }

    public PlayerRef(DataHolder dataHolder, int n, String string) {
        super(dataHolder, n);
        this.VO = new PlayerColumnNames(string);
        this.VP = new MostRecentGameInfoRef(dataHolder, n, this.VO);
        if (this.zzbif()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.VO.abj);
            int n3 = this.getInteger(this.VO.abm);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.VO.abk), this.getLong(this.VO.abl));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.VO.abl), this.getLong(this.VO.abn));
            }
            this.Vx = new PlayerLevelInfo(this.getLong(this.VO.abi), this.getLong(this.VO.abo), playerLevel, playerLevel2);
        } else {
            this.Vx = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.VO.aaZ);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.VO.aba);
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        this.zza(this.VO.aba, charArrayBuffer);
    }

    @Override
    public String zzbhy() {
        return this.getString(this.VO.aby);
    }

    @Override
    public String getName() {
        return this.getString(this.VO.name);
    }

    @Override
    public boolean zzbhz() {
        return this.getBoolean(this.VO.abx);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzhn(this.VO.abb);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.VO.abc);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzhn(this.VO.abd);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.VO.abe);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.VO.abf);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzhm(this.VO.abh) || this.zzho(this.VO.abh)) {
            return -1L;
        }
        return this.getLong(this.VO.abh);
    }

    @Override
    public int zzbia() {
        return this.getInteger(this.VO.abg);
    }

    @Override
    public boolean zzbib() {
        return this.getBoolean(this.VO.abq);
    }

    @Override
    public String getTitle() {
        return this.getString(this.VO.title);
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        this.zza(this.VO.title, charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.Vx;
    }

    @Override
    public MostRecentGameInfo zzbic() {
        if (this.zzho(this.VO.abr)) {
            return null;
        }
        return this.VP;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzhn(this.VO.abz);
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.getString(this.VO.abA);
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzhn(this.VO.abB);
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.getString(this.VO.abC);
    }

    @Override
    public int zzbid() {
        return this.getInteger(this.VO.abD);
    }

    @Override
    public long zzbie() {
        return this.getLong(this.VO.abE);
    }

    @Override
    public boolean isMuted() {
        return this.getBoolean(this.VO.abF);
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntity playerEntity = (PlayerEntity)((Player)this.freeze());
        playerEntity.writeToParcel(parcel, n);
    }

    private boolean zzbif() {
        if (this.zzho(this.VO.abi)) {
            return false;
        }
        return this.getLong(this.VO.abi) != -1L;
    }
}

