/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.player.ProfileSettingsEntity;
import com.google.android.gms.games.internal.player.StockProfileImageBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.OnSocialInviteUpdateReceivedListener;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.social.SocialInvite;
import com.google.android.gms.games.social.SocialInviteBuffer;
import com.google.android.gms.games.social.SocialInviteEntity;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.signin.internal.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends zzl<IGamesService> {
    EventIncrementManager WD = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzbkv() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String WE;
    private PlayerEntity WF;
    private GameEntity WG;
    private final PopupManager WH;
    private boolean WI = false;
    private final Binder WJ;
    private final long WK;
    private final Games.GamesOptions WL;

    public GamesClientImpl(Context context, Looper looper, zzh zzh2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzh2, connectionCallbacks, onConnectionFailedListener);
        this.WE = zzh2.zzauj();
        this.WJ = new Binder();
        this.WH = PopupManager.zza(this, zzh2.zzauf());
        this.zzq(zzh2.zzaul());
        this.WK = ((Object)((Object)this)).hashCode();
        this.WL = gamesOptions;
    }

    public boolean zzahd() {
        return true;
    }

    public void zza(@NonNull IGamesService iGamesService) {
        super.zza((IInterface)iGamesService);
        if (this.WI) {
            this.WH.zzblj();
            this.WI = false;
        }
        if (!this.WL.Vi && !this.WL.Vq) {
            this.zzb(iGamesService);
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.WI = false;
    }

    public void zzrr(int n) {
        this.WH.setGravity(n);
    }

    public void zzq(View view) {
        this.WH.zzr(view);
    }

    protected Set<Scope> zzc(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzac.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzac.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(zze.zzf zzf2) {
        this.zzbjw();
        super.zza(zzf2);
    }

    public void disconnect() {
        this.WI = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzatx();
                iGamesService.zzbku();
                this.WD.flush();
                iGamesService.zzam(this.WK);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzaf("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzix() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zziy() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzgm(IBinder iBinder) {
        return IGamesService.Stub.zzgp(iBinder);
    }

    public Bundle zzaoe() {
        try {
            Bundle bundle = ((IGamesService)this.zzatx()).zzaoe();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zzbjw() {
        this.WF = null;
        this.WG = null;
    }

    protected Bundle zzagl() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.WL.zzbhx();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.WE);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.WH.zzbll()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 4);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzg.zza((zzh)this.zzaus()));
        return bundle;
    }

    public void zzb(IGamesService iGamesService) {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.WH);
            iGamesService.zza(popupLocationInfoBinderCallbacks, this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zzbjx() {
        try {
            return ((IGamesService)this.zzatx()).zzbjx();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzf(zzqc.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzj(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public void zzb(String string, zzqc.zzb<Games.GetServerAuthCodeResult> zzb2) throws RemoteException {
        zzac.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((IGamesService)this.zzatx()).zza(string, new GetServerAuthCodeBinderCallbacks(zzb2));
    }

    public String zzbx(boolean bl) {
        if (bl && this.WF != null) {
            return this.WF.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzatx()).zzbkw();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzbjy() {
        this.zzatw();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.WF == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzatx()).zzbkx());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.WF = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.WF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzbjz() {
        this.zzatw();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.WG == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzatx()).zzbkz());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.WG = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.WG;
    }

    public void zza(zzqc.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzqc.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zzqc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zzqc.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzatx()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zzqc.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                String string3 = String.valueOf(string);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid player collection: ".concat(string3) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zzqc.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzbka() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzbka();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zzqc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zzqc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzqc.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zzqc.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zzqc.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zzqc.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzbmv().asBundle(), n, n2);
    }

    public void zza(zzqc.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzbkb() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzbkb();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzqc.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzqc.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.WH.zzbll(), this.WH.zzblk());
    }

    public void zzb(zzqc.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.WH.zzbll(), this.WH.zzblk());
    }

    public void zza(zzqc.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.WH.zzbll(), this.WH.zzblk());
    }

    public void zzb(zzqc.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.WH.zzbll(), this.WH.zzblk());
    }

    public void zzd(zzqc.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzqc.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzo(String string, int n) {
        this.WD.zzo(string, n);
    }

    public Intent zzbkc() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzbkc();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbkd() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzbkd();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzrd<OnInvitationReceivedListener> zzrd2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzrd2);
            ((IGamesService)this.zzatx()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbke() {
        try {
            ((IGamesService)this.zzatx()).zzan(this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzrd<OnTurnBasedMatchUpdateReceivedListener> zzrd2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzrd2);
            ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbkf() {
        try {
            ((IGamesService)this.zzatx()).zzao(this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzrd<QuestUpdateListener> zzrd2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzrd2);
            ((IGamesService)this.zzatx()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbkg() {
        try {
            ((IGamesService)this.zzatx()).zzaq(this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzrd<OnRequestReceivedListener> zzrd2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzrd2);
            ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbkh() {
        try {
            ((IGamesService)this.zzatx()).zzap(this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbki() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzbki();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbkj() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzbkj();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzg(zzqc.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzh(zzqc.zzb<Status> zzb2) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzbkk() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzatx()).zzbkk();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zzti() {
        try {
            return ((IGamesService)this.zzatx()).zzti();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zza(zzqc.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzp(String string, int n) {
        try {
            ((IGamesService)this.zzatx()).zzp(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzq(String string, int n) {
        try {
            ((IGamesService)this.zzatx()).zzq(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzqc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzbnb(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zzqc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzk((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zzqc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzl((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzbkl() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzatx()).zzbkl();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zzqc.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zzqc.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zzqc.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzn(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zzqc.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzqc.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzm((IGamesCallbacks)new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzjw(String string) {
        try {
            ((IGamesService)this.zzatx()).zzke(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzqc.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zzqc.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzo(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzrd<RoomUpdateListener> zzrd2, zzrd<RoomStatusUpdateListener> zzrd3, zzrd<RealTimeMessageReceivedListener> zzrd4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzrd2, zzrd3, zzrd4);
            ((IGamesService)this.zzatx()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.WJ, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzrd<RoomUpdateListener> zzrd2, zzrd<RoomStatusUpdateListener> zzrd3, zzrd<RealTimeMessageReceivedListener> zzrd4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzrd2, zzrd3, zzrd4);
            ((IGamesService)this.zzatx()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.WJ, roomConfig.getInvitationId(), false, this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzrd<RoomUpdateListener> zzrd2, String string) {
        try {
            ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzrd2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzrd<RealTimeMultiplayer.ReliableMessageSentCallback> zzrd2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzrd2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzac.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzatx()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zze(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzatx()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzrs(int n) {
        try {
            ((IGamesService)this.zzatx()).zzrs(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzbkm() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzbkm();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zza(n, byArray, n2, string);
            zzac.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzbkn() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzatx()).zzbkn();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzbko() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzatx()).zzbko();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zzqc.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zzqc.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zzqc.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zzqc.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zzqc.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzc(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzc(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzjx(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzjx(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zzqc.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zzt(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zzqc.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zzqc.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zzqc.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzjy(String string) {
        try {
            ((IGamesService)this.zzatx()).zza(string, this.WH.zzbll(), this.WH.zzblk());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzqc.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zzqc.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.WD.flush();
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzbkp() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzatx()).zzbkp();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzbkq() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzatx()).zzbkq();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzqc.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zzqc.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zzqc.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzbng();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzbaw();
        snapshotContents.close();
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzbaw();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzatx()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zzqc.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzq(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zzqc.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzbng();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzbaw();
        snapshotContents.close();
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zzi(zzqc.zzb<Videos.CaptureCapabilitiesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzl(new CaptureCapabilitiesBinderCallback(zzb2));
    }

    public Intent zzbkr() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzatx()).zzblf();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzj(zzqc.zzb<Videos.CaptureStateResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzv(new CaptureStateBinderCallbacks(zzb2));
    }

    public void zzk(zzqc.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzs(new CaptureStreamingAvailabilityBinderCallback(zzb2));
    }

    public void zzl(zzqc.zzb<Videos.CaptureStreamingMetadataResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzq(new CaptureStreamingMetadataBinderCallback(zzb2));
    }

    public void zzm(zzqc.zzb<Videos.CaptureStreamingUrlResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzr(new CaptureStreamingUrlBinderCallback(zzb2));
    }

    public void zzn(zzqc.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzt(new HeadlessCaptureEnabledBinderCallback(zzb2));
    }

    public void zzb(zzqc.zzb<Videos.CaptureAvailableResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new CaptureAvailableBinderCallback(zzb2), n);
    }

    public boolean zzbks() {
        boolean bl = false;
        try {
            bl = ((IGamesService)this.zzatx()).zzbks();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return bl;
    }

    public void zzo(zzqc.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzo(new CaptureStreamingEnabledBinderCallback(zzb2));
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new CaptureLaunchGameAndOverlayBinderCallback(baseGamesApiMethodImpl), string, videoConfiguration);
    }

    public void zzp(zzqc.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzk(new ListVideosBinderCallback(zzb2));
    }

    public void zzc(zzqc.zzb<Videos.ListVideosResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zzd((IGamesCallbacks)new ListVideosBinderCallback(zzb2), string, n);
    }

    public void zze(zzrd<Videos.CaptureOverlayStateListener> zzrd2) {
        try {
            CaptureOverlayStateBinderCallback captureOverlayStateBinderCallback = new CaptureOverlayStateBinderCallback(zzrd2);
            ((IGamesService)this.zzatx()).zzf((IGamesCallbacks)captureOverlayStateBinderCallback, this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzg(zzqc.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzm((IGamesCallbacks)new CapturePausedBinderCallback(zzb2), bl);
    }

    public void zza(zzqc.zzb<Status> zzb2, VideoConfiguration videoConfiguration, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new CaptureStartedBinderCallbacks(zzb2, captureRuntimeErrorCallback), videoConfiguration);
    }

    public void zzq(zzqc.zzb<Videos.CaptureStoppedResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzu(new CaptureStoppedBinderCallbacks(zzb2));
    }

    public void zzbkt() {
        try {
            ((IGamesService)this.zzatx()).zzat(this.WK);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzqc.zzb<Status> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzh(new UpdateHeadlessCapturePermissionBinderCallback(zzb2), string, bl);
    }

    public void zzj(zzqc.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zzqc.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzp(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzqc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzqc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zzqc.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzqc.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzqc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zzqc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zzqc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzatx()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zzqc.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zzqc.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zzqc.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzr(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzqc.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zze(zzqc.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zza(zzqc.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl, bl2);
    }

    public void zzh(zzqc.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zza(zzqc.zzb<Players.LoadPlayersResult> zzb2, Account account) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), account);
    }

    public void zzr(zzqc.zzb<Players.LoadStockProfileImagesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzp(new StockProfileImagesLoadedBinderCallback(zzb2));
    }

    public void zza(zzqc.zzb<Players.UpdateGamerProfileResult> zzb2, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new GamerProfileUpdatedBinderCallback(zzb2), string, bl, string2, bl2, bl3);
    }

    public void zzi(zzqc.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzj((IGamesCallbacks)new DeletePlayerBinderCallback(zzb2), bl);
    }

    public void zzj(zzqc.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzk((IGamesCallbacks)new UpdateAutoSignInBinderCallback(zzb2), bl);
    }

    public void zzk(zzqc.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzl((IGamesCallbacks)new UpdateProfileDiscoverabilityBinderCallback(zzb2), bl);
    }

    public void zzb(zzqc.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zzqc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zzqc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzatx()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzqc.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zzqc.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzj((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zzqc.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zze(zzqc.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzn(zzqc.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzl(zzqc.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzqc.zzb<Status> zzb2, boolean bl, boolean bl2, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bl2, bundle);
    }

    public void zzs(zzqc.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzs(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zzqc.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zzqc.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zzqc.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzg(zzqc.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zzqc.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzatx()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzbku() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzatx()).zzbku();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzbi(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.WI = bundle.getBoolean("show_welcome_popup");
            this.WF = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.WG = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zzo(zzqc.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzu(new SendFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzp(zzqc.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzv(new AcceptFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzq(zzqc.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzw(new IgnoreFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzr(zzqc.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzx(new CancelFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zze(zzqc.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzatx()).zzf(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzs(zzqc.zzb<Players.LoadPlayersResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzatx()).zzy(new PlayerUnfriendedBinderCallback(zzb2), string);
    }

    public void zzf(zzqc.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzatx()).zzg(new SetPlayerMutedBinderCallback(zzb2), string, bl);
    }

    public void zzc(zzqc.zzb<Social.LoadInvitesResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzatx()).zzb((IGamesCallbacks)new InvitesLoadedBinderCallback(zzb2), n);
    }

    public void zza(Account account, byte[] byArray) throws RemoteException {
        ((IGamesService)this.zzatx()).zza(account, byArray);
    }

    public void zze(Account account) throws RemoteException {
        ((IGamesService)this.zzatx()).zze(account);
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzgm(iBinder);
    }

    private static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer Xj;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xj = new VideoBuffer(dataHolder);
        }
    }

    private static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status fp;
        private final String zzae;

        CaptureStreamingUrlResultImpl(Status status, String string) {
            this.fp = status;
            this.zzae = string;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public String getUrl() {
            return this.zzae;
        }
    }

    private static final class CaptureStreamingMetadataResultImpl
    implements Videos.CaptureStreamingMetadataResult {
        private final Status fp;
        private final String HP;
        private final String Y;

        CaptureStreamingMetadataResultImpl(Status status, String string, String string2) {
            this.fp = status;
            this.HP = string;
            this.Y = string2;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class CaptureStreamingEnabledResultImpl
    implements Result {
        public Status getStatus() {
            return null;
        }
    }

    private static final class CaptureStreamingAvailabilityResultImpl
    implements Videos.CaptureStreamingAvailabilityResult {
        private final Status fp;
        private final boolean WR;
        private final boolean WY;

        CaptureStreamingAvailabilityResultImpl(Status status, boolean bl, boolean bl2) {
            this.fp = status;
            this.WR = bl;
            this.WY = bl2;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class CaptureStoppedResultImpl
    implements Videos.CaptureStoppedResult {
        private final Status fp;
        private final Uri WX;

        CaptureStoppedResultImpl(Status status, Uri uri) {
            this.fp = status;
            this.WX = uri;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class CaptureStateResultImpl
    implements Videos.CaptureStateResult {
        private final Status fp;
        private final CaptureState WW;

        CaptureStateResultImpl(Status status, CaptureState captureState) {
            this.fp = status;
            this.WW = captureState;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public CaptureState getCaptureState() {
            return this.WW;
        }
    }

    private static final class CaptureCapabilitiesResultImpl
    implements Videos.CaptureCapabilitiesResult {
        private final Status fp;
        private final VideoCapabilities WS;

        CaptureCapabilitiesResultImpl(Status status, VideoCapabilities videoCapabilities) {
            this.fp = status;
            this.WS = videoCapabilities;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public VideoCapabilities getCapabilities() {
            return this.WS;
        }
    }

    private static final class CaptureAvailableResultImpl
    implements Videos.CaptureAvailableResult {
        private final Status fp;
        private final boolean WR;

        CaptureAvailableResultImpl(Status status, boolean bl) {
            this.fp = status;
            this.WR = bl;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public boolean isAvailable() {
            return this.WR;
        }
    }

    private static final class InviteUpdateResultImpl
    extends GamesDataHolderResult
    implements Social.InviteUpdateResult {
        private final SocialInvite Xg;

        InviteUpdateResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            try {
                this.Xg = socialInviteBuffer.getCount() > 0 ? new SocialInviteEntity((SocialInvite)socialInviteBuffer.get(0)) : null;
            }
            finally {
                socialInviteBuffer.release();
            }
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status fp;
        private final String Xb;

        DeleteSnapshotResultImpl(int n, String string) {
            this.fp = GamesStatusCodes.zzqv(n);
            this.Xb = string;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public String getSnapshotId() {
            return this.Xb;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata Xa;

        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.Xa = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.Xa;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot XG;
        private final String XH;
        private final Snapshot XI;
        private final Contents XJ;
        private final SnapshotContents XK;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents contents) {
            this(dataHolder, null, contents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.XG = null;
                    this.XI = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzc.zzbr((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.XG = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    this.XI = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.XG = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.XI = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(contents2));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.XH = string;
            this.XJ = contents3;
            this.XK = new SnapshotContentsEntity(contents3);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.XG;
        }

        @Override
        public String getConflictId() {
            return this.XH;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.XI;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.XK;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.xi);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats Xu;

        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.Xu = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity((PlayerStats)playerStatsBuffer.get(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.Xu;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> Xl;

        LoadAppContentsResultImpl(DataHolder[] dataHolderArray) {
            super(dataHolderArray[0]);
            this.Xl = new ArrayList<DataHolder>(Arrays.asList(dataHolderArray));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone WZ;
        private final Quest WO;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.WO = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.WO.zzbnd();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.WZ = list.get(i);
                        return;
                    }
                    this.WZ = null;
                } else {
                    this.WZ = null;
                    this.WO = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.WZ;
        }

        @Override
        public Quest getQuest() {
            return this.WO;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest WO;

        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.WO = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.WO;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder xi;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.xi = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.xi);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status fp;
        private final Bundle Xw;

        LoadRequestsResultImpl(Status status, Bundle bundle) {
            this.fp = status;
            this.Xw = bundle;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public GameRequestBuffer getRequests(int n) {
            String string = RequestType.zzrv(n);
            if (!this.Xw.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.Xw.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.Xw.keySet()) {
                DataHolder dataHolder = (DataHolder)this.Xw.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes Yn;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Yn = RequestUpdateOutcomes.zzbl(dataHolder);
        }

        @Override
        public int getRequestOutcome(String string) {
            return this.Yn.getRequestOutcome(string);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.Yn.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest XT;

        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.XT = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status fp;
        private final Bundle Xe;

        InboxCountResultImpl(Status status, Bundle bundle) {
            this.fp = status;
            this.Xe = bundle;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class GetServerAuthCodeResultImpl
    implements Games.GetServerAuthCodeResult {
        private final Status fp;
        private final String Xd;

        GetServerAuthCodeResultImpl(Status status, String string) {
            this.fp = status;
            this.Xd = string;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public String getCode() {
            return this.Xd;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status fp;
        private final String fG;

        GetTokenResultImpl(Status status, String string) {
            this.fp = status;
            this.fG = string;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status fp;
        private final String Xc;
        private final boolean zzcws;

        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.fp = GamesStatusCodes.zzqv(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.Xc = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzcws = dataHolder.zze("muted", 0, 0);
                } else {
                    this.Xc = null;
                    this.zzcws = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status fp;
        private final String Xc;
        private final boolean zzcws;

        public GameMuteStatusChangeResultImpl(int n, String string, boolean bl) {
            this.fp = GamesStatusCodes.zzqv(n);
            this.Xc = string;
            this.zzcws = bl;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status fp;
        private final String WQ;

        CancelMatchResultImpl(Status status, String string) {
            this.fp = status;
            this.WQ = string;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public String getMatchId() {
            return this.WQ;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch XE;

        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.XE = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.XE;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData Yf;

        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.Yf = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.Yf;
        }
    }

    private static final class UpdateGamerProfileResultImpl
    implements Players.UpdateGamerProfileResult {
        private final Status fp;
        private final Bundle Ym;

        UpdateGamerProfileResultImpl(int n, Bundle bundle) {
            this.fp = new Status(n);
            this.Ym = bundle;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class LoadStockProfileImagesResultImpl
    extends GamesDataHolderResult
    implements Players.LoadStockProfileImagesResult {
        private final StockProfileImageBuffer Xz;

        LoadStockProfileImagesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xz = new StockProfileImageBuffer(dataHolder);
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer XC;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.XC = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status fp;
        private final List<String> XA;
        private final Bundle XB;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle bundle) {
            this.fp = status;
            this.XA = bundle.getStringArrayList("game_category_list");
            this.XB = bundle;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    private static final class LoadInvitesResultImpl
    extends GamesDataHolderResult
    implements Social.LoadInvitesResult {
        private final SocialInviteBuffer Xr;

        LoadInvitesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xr = new SocialInviteBuffer(dataHolder);
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer Xv;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xv = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.Xv;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status fp;
        private final LoadMatchesResponse Xs;

        LoadMatchesResultImpl(Status status, Bundle bundle) {
            this.fp = status;
            this.Xs = new LoadMatchesResponse(bundle);
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.Xs;
        }

        public void release() {
            this.Xs.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer Xq;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xq = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.Xq;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity Xt;

        LoadPlayerScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.Xt = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.Xt;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity Xx;
        private final LeaderboardScoreBuffer Xy;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.Xx = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.Xy = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.Xx;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.Xy;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer Xh;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xh = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.Xh;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer Xo;

        LoadGameSearchSuggestionsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xo = new GameSearchSuggestionBuffer(dataHolder);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer Xn;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xn = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer Xp;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xp = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.Xp;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer Xm;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xm = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.Xm;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status fp;
        private final String VQ;

        UpdateAchievementResultImpl(int n, String string) {
            this.fp = GamesStatusCodes.zzqv(n);
            this.VQ = string;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public String getAchievementId() {
            return this.VQ;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer Xk;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Xk = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.Xk;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzqk {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzqv(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzrd.zzc<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int rR;
        private final String XQ;
        private final int XR;

        RealTimeMessageSentNotifier(int n, int n2, String string) {
            this.rR = n;
            this.XR = n2;
            this.XQ = string;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.rR, this.XR, this.XQ);
            }
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzrd.zzc<RealTimeMessageReceivedListener> {
        private final RealTimeMessage XF;

        MessageReceivedNotifier(RealTimeMessage realTimeMessage) {
            this.XF = realTimeMessage;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.XF);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzrd.zzc<RoomStatusUpdateListener> {
        private final String XL;

        P2PDisconnectedNotifier(String string) {
            this.XL = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.XL);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzrd.zzc<RoomStatusUpdateListener> {
        private final String XL;

        P2PConnectedNotifier(String string) {
            this.XL = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.XL);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzrd.zzc<RoomUpdateListener> {
        private final int rR;
        private final String Xi;

        LeftRoomNotifier(int n, String string) {
            this.rR = n;
            this.Xi = string;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.rR, this.Xi);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> WN = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.WN.add(stringArray[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.WN);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzqj<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzbi(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzqj<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzbi(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzrd.zzc<OnNearbyPlayerDetectedListener> {
        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(null);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class SocialInviteRemovedNotifier
    implements zzrd.zzc<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite Ye;

        SocialInviteRemovedNotifier(SocialInvite socialInvite) {
            this.Ye = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zzb(this.Ye);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class SocialInviteUpdateReceivedNotifier
    implements zzrd.zzc<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite Ye;

        SocialInviteUpdateReceivedNotifier(SocialInvite socialInvite) {
            this.Ye = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zza(this.Ye);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzrd.zzc<OnRequestReceivedListener> {
        private final String zzcaj;

        RequestRemovedNotifier(String string) {
            this.zzcaj = string;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzcaj);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzrd.zzc<OnRequestReceivedListener> {
        private final GameRequest XT;

        RequestReceivedNotifier(GameRequest gameRequest) {
            this.XT = gameRequest;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.XT);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzrd.zzc<QuestUpdateListener> {
        private final Quest WO;

        QuestCompletedNotifier(Quest quest) {
            this.WO = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.WO);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzrd.zzc<OnTurnBasedMatchUpdateReceivedListener> {
        private final String XD;

        MatchRemovedNotifier(String string) {
            this.XD = string;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.XD);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzrd.zzc<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch XE;

        MatchUpdateReceivedNotifier(TurnBasedMatch turnBasedMatch) {
            this.XE = turnBasedMatch;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.XE);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzrd.zzc<OnInvitationReceivedListener> {
        private final String fg;

        InvitationRemovedNotifier(String string) {
            this.fg = string;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.fg);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzrd.zzc<OnInvitationReceivedListener> {
        private final Invitation Xf;

        InvitationReceivedNotifier(Invitation invitation) {
            this.Xf = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.Xf);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class CaptureOverlayStateChangedNotifier
    implements zzrd.zzc<Videos.CaptureOverlayStateListener> {
        private final int WU;

        CaptureOverlayStateChangedNotifier(int n) {
            this.WU = n;
        }

        public void zza(Videos.CaptureOverlayStateListener captureOverlayStateListener) {
            captureOverlayStateListener.onCaptureOverlayStateChanged(this.WU);
        }

        public void zzarg() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((Videos.CaptureOverlayStateListener)object);
        }
    }

    private static final class SetPlayerMutedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Players.LoadPlayersResult> Dj;

        SetPlayerMutedBinderCallback(zzqc.zzb<Players.LoadPlayersResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbg(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class PlayerUnfriendedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Players.LoadPlayersResult> Dj;

        PlayerUnfriendedBinderCallback(zzqc.zzb<Players.LoadPlayersResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbf(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class CancelFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Social.InviteUpdateResult> Dj;

        CancelFriendInviteFirstPartyBinderCallback(zzqc.zzb<Social.InviteUpdateResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbe(DataHolder dataHolder) {
            this.Dj.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class IgnoreFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Social.InviteUpdateResult> Dj;

        IgnoreFriendInviteFirstPartyBinderCallback(zzqc.zzb<Social.InviteUpdateResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbd(DataHolder dataHolder) {
            this.Dj.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class AcceptFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Social.InviteUpdateResult> Dj;

        AcceptFriendInviteFirstPartyBinderCallback(zzqc.zzb<Social.InviteUpdateResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzba(DataHolder dataHolder) {
            this.Dj.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class SendFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Social.InviteUpdateResult> Dj;

        SendFriendInviteFirstPartyBinderCallback(zzqc.zzb<Social.InviteUpdateResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaz(DataHolder dataHolder) {
            this.Dj.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class UpdateHeadlessCapturePermissionBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        UpdateHeadlessCapturePermissionBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbk(Status status) {
            this.Dj.setResult((Object)status);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Videos.ListVideosResult> Dj;

        ListVideosBinderCallback(zzqc.zzb<Videos.ListVideosResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzax(DataHolder dataHolder) {
            this.Dj.setResult((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class CaptureStreamingUrlBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Videos.CaptureStreamingUrlResult> Dj;

        CaptureStreamingUrlBinderCallback(zzqc.zzb<Videos.CaptureStreamingUrlResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzm(int n, String string) {
            this.Dj.setResult((Object)new CaptureStreamingUrlResultImpl(new Status(n), string));
        }
    }

    private static final class CaptureStreamingMetadataBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Videos.CaptureStreamingMetadataResult> Dj;

        CaptureStreamingMetadataBinderCallback(zzqc.zzb<Videos.CaptureStreamingMetadataResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, String string, String string2) {
            this.Dj.setResult((Object)new CaptureStreamingMetadataResultImpl(new Status(n), string, string2));
        }
    }

    private static final class CaptureStreamingEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        CaptureStreamingEnabledBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzrk(int n) {
            this.Dj.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureStreamingAvailabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Videos.CaptureStreamingAvailabilityResult> Dj;

        CaptureStreamingAvailabilityBinderCallback(zzqc.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, boolean bl, boolean bl2) {
            this.Dj.setResult((Object)new CaptureStreamingAvailabilityResultImpl(new Status(n), bl, bl2));
        }
    }

    private static final class CaptureStoppedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Videos.CaptureStoppedResult> Dj;

        public CaptureStoppedBinderCallbacks(zzqc.zzb<Videos.CaptureStoppedResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, Uri uri) {
            this.Dj.setResult((Object)new CaptureStoppedResultImpl(new Status(n), uri));
        }
    }

    private static final class CaptureStateBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Videos.CaptureStateResult> Dj;

        public CaptureStateBinderCallbacks(zzqc.zzb<Videos.CaptureStateResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            this.Dj.setResult((Object)new CaptureStateResultImpl(new Status(n), CaptureState.zzab(bundle)));
        }
    }

    private static final class CaptureStartedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;
        private final Videos.CaptureRuntimeErrorCallback WV;

        public CaptureStartedBinderCallbacks(zzqc.zzb<Status> zzb2, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
            this.WV = (Videos.CaptureRuntimeErrorCallback)zzac.zzb((Object)captureRuntimeErrorCallback, (Object)"Callback must not be null");
        }

        @Override
        public void zzbl(Status status) {
            this.Dj.setResult((Object)status);
        }

        @Override
        public void zzro(int n) {
            this.WV.zztg(n);
        }
    }

    private static final class CapturePausedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        public CapturePausedBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzrp(int n) {
            this.Dj.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureOverlayStateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrd<Videos.CaptureOverlayStateListener> JT;

        CaptureOverlayStateBinderCallback(zzrd<Videos.CaptureOverlayStateListener> zzrd2) {
            this.JT = (zzrd)zzac.zzb(zzrd2, (Object)"Callback must not be null");
        }

        @Override
        public void onCaptureOverlayStateChanged(int n) {
            this.JT.zza((zzrd.zzc)new CaptureOverlayStateChangedNotifier(n));
        }
    }

    private static final class CaptureLaunchGameAndOverlayBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> WT;

        CaptureLaunchGameAndOverlayBinderCallback(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl) {
            this.WT = (Games.BaseGamesApiMethodImpl)((Object)zzac.zzb(baseGamesApiMethodImpl, (Object)"Holder must not be null"));
        }

        @Override
        public void zzrj(int n) {
            this.WT.zzc((Result)new Status(n));
        }

        @Override
        public void zzbi(Status status) {
            this.WT.zzc((Result)status);
        }
    }

    private static final class CaptureCapabilitiesBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Videos.CaptureCapabilitiesResult> Dj;

        CaptureCapabilitiesBinderCallback(zzqc.zzb<Videos.CaptureCapabilitiesResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, VideoCapabilities videoCapabilities) {
            this.Dj.setResult((Object)new CaptureCapabilitiesResultImpl(new Status(n), videoCapabilities));
        }
    }

    private static final class CaptureAvailableBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Videos.CaptureAvailableResult> Dj;

        CaptureAvailableBinderCallback(zzqc.zzb<Videos.CaptureAvailableResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, boolean bl) {
            this.Dj.setResult((Object)new CaptureAvailableResultImpl(new Status(n), bl));
        }
    }

    private static final class HeadlessCaptureEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        HeadlessCaptureEnabledBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbj(Status status) {
            this.Dj.setResult((Object)status);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Snapshots.DeleteSnapshotResult> Dj;

        public SnapshotDeletedBinderCallbacks(zzqc.zzb<Snapshots.DeleteSnapshotResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(int n, String string) {
            this.Dj.setResult((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Snapshots.CommitSnapshotResult> Yb;

        public SnapshotCommittedBinderCallbacks(zzqc.zzb<Snapshots.CommitSnapshotResult> zzb2) {
            this.Yb = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzao(DataHolder dataHolder) {
            this.Yb.setResult((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Snapshots.OpenSnapshotResult> Yc;

        public SnapshotOpenedBinderCallbacks(zzqc.zzb<Snapshots.OpenSnapshotResult> zzb2) {
            this.Yc = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.Yc.setResult((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.Yc.setResult((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Snapshots.LoadSnapshotsResult> Yd;

        public SnapshotsLoadedBinderCallbacks(zzqc.zzb<Snapshots.LoadSnapshotsResult> zzb2) {
            this.Yd = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzan(DataHolder dataHolder) {
            this.Yd.setResult((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Stats.LoadPlayerStatsResult> Dj;

        public PlayerStatsLoadedBinderCallbacks(zzqc.zzb<Stats.LoadPlayerStatsResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaw(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<AppContents.LoadAppContentResult> WP;

        public AppContentLoadedBinderCallbacks(zzqc.zzb<AppContents.LoadAppContentResult> zzb2) {
            this.WP = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.WP.setResult((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Quests.LoadQuestsResult> XP;

        public QuestsLoadedBinderCallbacks(zzqc.zzb<Quests.LoadQuestsResult> zzb2) {
            this.XP = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzat(DataHolder dataHolder) {
            this.XP.setResult((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Quests.ClaimMilestoneResult> XN;
        private final String XO;

        public QuestMilestoneClaimBinderCallbacks(zzqc.zzb<Quests.ClaimMilestoneResult> zzb2, String string) {
            this.XN = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
            this.XO = (String)zzac.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzap(DataHolder dataHolder) {
            this.XN.setResult((Object)new ClaimMilestoneResultImpl(dataHolder, this.XO));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Quests.AcceptQuestResult> XM;

        public QuestAcceptedBinderCallbacks(zzqc.zzb<Quests.AcceptQuestResult> zzb2) {
            this.XM = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaq(DataHolder dataHolder) {
            this.XM.setResult((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Requests.LoadRequestSummariesResult> XV;

        public RequestSummariesLoadedBinderCallbacks(zzqc.zzb<Requests.LoadRequestSummariesResult> zzb2) {
            this.XV = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzam(DataHolder dataHolder) {
            this.XV.setResult((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Requests.LoadRequestsResult> XW;

        public RequestsLoadedBinderCallbacks(zzqc.zzb<Requests.LoadRequestsResult> zzb2) {
            this.XW = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzqv(n);
            this.XW.setResult((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Requests.SendRequestResult> XU;

        public RequestSentBinderCallbacks(zzqc.zzb<Requests.SendRequestResult> zzb2) {
            this.XU = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzal(DataHolder dataHolder) {
            this.XU.setResult((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Requests.UpdateRequestsResult> XX;

        public RequestsUpdatedBinderCallbacks(zzqc.zzb<Requests.UpdateRequestsResult> zzb2) {
            this.XX = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzak(DataHolder dataHolder) {
            this.XX.setResult((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager WH;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.WH = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzbjt() {
            return new PopupLocationInfoParcelable(this.WH.zzblm());
        }
    }

    private static final class GetServerAuthCodeBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Games.GetServerAuthCodeResult> Dj;

        public GetServerAuthCodeBinderCallbacks(zzqc.zzb<Games.GetServerAuthCodeResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzqv(n);
            this.Dj.setResult((Object)new GetServerAuthCodeResultImpl(status, string));
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Games.GetTokenResult> Dj;

        public GetAuthTokenBinderCallbacks(zzqc.zzb<Games.GetTokenResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzqv(n);
            this.Dj.setResult((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        public SignOutCompleteBinderCallbacks(zzqc.zzb<Status> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbjs() {
            Status status = GamesStatusCodes.zzqv(0);
            this.Dj.setResult((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Notifications.InboxCountResult> Dj;

        InboxCountsLoadedBinderCallback(zzqc.zzb<Notifications.InboxCountResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzqv(n);
            this.Dj.setResult((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        ContactSettingsUpdatedBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzrh(int n) {
            this.Dj.setResult((Object)GamesStatusCodes.zzqv(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Notifications.ContactSettingLoadResult> Dj;

        ContactSettingsLoadedBinderCallback(zzqc.zzb<Notifications.ContactSettingLoadResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzai(DataHolder dataHolder) {
            this.Dj.setResult((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Notifications.GameMuteStatusLoadResult> Dj;

        GameMuteStatusLoadedBinderCallback(zzqc.zzb<Notifications.GameMuteStatusLoadResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzag(DataHolder dataHolder) {
            this.Dj.setResult((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Notifications.GameMuteStatusChangeResult> Dj;

        GameMuteStatusChangedBinderCallback(zzqc.zzb<Notifications.GameMuteStatusChangeResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.Dj.setResult((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzrd<RealTimeMultiplayer.ReliableMessageSentCallback> XS;

        public RealTimeReliableMessageBinderCallbacks(zzrd<RealTimeMultiplayer.ReliableMessageSentCallback> zzrd2) {
            this.XS = zzrd2;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.XS != null) {
                this.XS.zza((zzrd.zzc)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzrd<? extends RoomUpdateListener> XY;
        private final zzrd<? extends RoomStatusUpdateListener> XZ;
        private final zzrd<RealTimeMessageReceivedListener> Ya;

        public RoomBinderCallbacks(zzrd<RoomUpdateListener> zzrd2) {
            this.XY = (zzrd)zzac.zzb(zzrd2, (Object)"Callbacks must not be null");
            this.XZ = null;
            this.Ya = null;
        }

        public RoomBinderCallbacks(zzrd<? extends RoomUpdateListener> zzrd2, zzrd<? extends RoomStatusUpdateListener> zzrd3, zzrd<RealTimeMessageReceivedListener> zzrd4) {
            this.XY = (zzrd)zzac.zzb(zzrd2, (Object)"Callbacks must not be null");
            this.XZ = zzrd3;
            this.Ya = zzrd4;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.XY.zza((zzrd.zzc)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzaa(DataHolder dataHolder) {
            this.XY.zza((zzrd.zzc)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int n, String string) {
            this.XY.zza((zzrd.zzc)new LeftRoomNotifier(n, string));
        }

        @Override
        public void zzad(DataHolder dataHolder) {
            this.XY.zza((zzrd.zzc)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzab(DataHolder dataHolder) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzac(DataHolder dataHolder) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzae(DataHolder dataHolder) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzaf(DataHolder dataHolder) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String string) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new P2PConnectedNotifier(string));
            }
        }

        @Override
        public void onP2PDisconnected(String string) {
            if (this.XZ != null) {
                this.XZ.zza((zzrd.zzc)new P2PDisconnectedNotifier(string));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.Ya != null) {
                this.Ya.zza((zzrd.zzc)new MessageReceivedNotifier(realTimeMessage));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<TurnBasedMultiplayer.CancelMatchResult> Yg;

        public TurnBasedMatchCanceledBinderCallbacks(zzqc.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2) {
            this.Yg = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(int n, String string) {
            Status status = GamesStatusCodes.zzqv(n);
            this.Yg.setResult((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<TurnBasedMultiplayer.LeaveMatchResult> Yi;

        public TurnBasedMatchLeftBinderCallbacks(zzqc.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2) {
            this.Yi = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.Yi.setResult((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<TurnBasedMultiplayer.UpdateMatchResult> Yk;

        public TurnBasedMatchUpdatedBinderCallbacks(zzqc.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2) {
            this.Yk = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.Yk.setResult((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<TurnBasedMultiplayer.InitiateMatchResult> Yh;

        public TurnBasedMatchInitiatedBinderCallbacks(zzqc.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2) {
            this.Yh = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.Yh.setResult((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<TurnBasedMultiplayer.LoadMatchResult> Yj;

        public TurnBasedMatchLoadedBinderCallbacks(zzqc.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2) {
            this.Yj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.Yj.setResult((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<TurnBasedMultiplayer.LoadMatchesResult> Yl;

        public TurnBasedMatchesLoadedBinderCallbacks(zzqc.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2) {
            this.Yl = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzqv(n);
            this.Yl.setResult((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Leaderboards.SubmitScoreResult> Dj;

        public SubmitScoreBinderCallbacks(zzqc.zzb<Leaderboards.SubmitScoreResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.Dj.setResult((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class UpdateProfileDiscoverabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        UpdateProfileDiscoverabilityBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zzrn(int n) {
            this.Dj.setResult((Object)new Status(n));
        }
    }

    private static final class UpdateAutoSignInBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        UpdateAutoSignInBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zzrm(int n) {
            this.Dj.setResult((Object)new Status(n));
        }
    }

    private static final class DeletePlayerBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        DeletePlayerBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zzrl(int n) {
            this.Dj.setResult((Object)new Status(n));
        }
    }

    private static final class GamerProfileUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Players.UpdateGamerProfileResult> Dj;

        GamerProfileUpdatedBinderCallback(zzqc.zzb<Players.UpdateGamerProfileResult> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            this.Dj.setResult((Object)new UpdateGamerProfileResultImpl(n, bundle));
        }
    }

    private static final class StockProfileImagesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Players.LoadStockProfileImagesResult> Dj;

        StockProfileImagesLoadedBinderCallback(zzqc.zzb<Players.LoadStockProfileImagesResult> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zzay(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadStockProfileImagesResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Status> Dj;

        ProfileSettingsUpdatedBinderCallback(zzqc.zzb<Status> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzri(int n) {
            this.Dj.setResult((Object)GamesStatusCodes.zzqv(n));
        }
    }

    private static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Players.LoadProfileSettingsResult> Dj;

        ProfileSettingsLoadedBinderCallback(zzqc.zzb<Players.LoadProfileSettingsResult> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zzav(DataHolder dataHolder) {
            this.Dj.setResult((Object)new ProfileSettingsEntity(dataHolder));
            dataHolder.close();
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Players.LoadXpStreamResult> Dj;

        PlayerXpStreamLoadedBinderCallback(zzqc.zzb<Players.LoadXpStreamResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzau(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Players.LoadXpForGameCategoriesResult> Dj;

        PlayerXpForGameCategoriesLoadedBinderCallback(zzqc.zzb<Players.LoadXpForGameCategoriesResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzqv(n);
            this.Dj.setResult((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class InvitesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Social.LoadInvitesResult> Dj;

        InvitesLoadedBinderCallback(zzqc.zzb<Social.LoadInvitesResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbh(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadInvitesResultImpl(dataHolder));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Players.LoadPlayersResult> Dj;

        PlayersLoadedBinderCallback(zzqc.zzb<Players.LoadPlayersResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class SocialInviteUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbb(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzrd.zzc)new SocialInviteUpdateReceivedNotifier(socialInvite));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbc(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzrd.zzc)new SocialInviteRemovedNotifier(socialInvite));
            }
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrd<OnRequestReceivedListener> JT;

        RequestReceivedBinderCallback(zzrd<OnRequestReceivedListener> zzrd2) {
            this.JT = zzrd2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.JT.zza((zzrd.zzc)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String string) {
            this.JT.zza((zzrd.zzc)new RequestRemovedNotifier(string));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrd<QuestUpdateListener> JT;

        QuestUpdateBinderCallback(zzrd<QuestUpdateListener> zzrd2) {
            this.JT = zzrd2;
        }

        @Override
        public void zzar(DataHolder dataHolder) {
            Quest quest = this.zzbk(dataHolder);
            if (quest != null) {
                this.JT.zza((zzrd.zzc)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzbk(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrd<OnTurnBasedMatchUpdateReceivedListener> JT;

        MatchUpdateReceivedBinderCallback(zzrd<OnTurnBasedMatchUpdateReceivedListener> zzrd2) {
            this.JT = zzrd2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.JT.zza((zzrd.zzc)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String string) {
            this.JT.zza((zzrd.zzc)new MatchRemovedNotifier(string));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrd<OnInvitationReceivedListener> JT;

        InvitationReceivedBinderCallback(zzrd<OnInvitationReceivedListener> zzrd2) {
            this.JT = zzrd2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.JT.zza((zzrd.zzc)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String string) {
            this.JT.zza((zzrd.zzc)new InvitationRemovedNotifier(string));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Invitations.LoadInvitationsResult> Dj;

        InvitationsLoadedBinderCallback(zzqc.zzb<Invitations.LoadInvitationsResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Leaderboards.LoadPlayerScoreResult> Dj;

        PlayerLeaderboardScoreLoadedBinderCallback(zzqc.zzb<Leaderboards.LoadPlayerScoreResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaj(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Leaderboards.LoadScoresResult> Dj;

        LeaderboardScoresLoadedBinderCallback(zzqc.zzb<Leaderboards.LoadScoresResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.Dj.setResult((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Leaderboards.LeaderboardMetadataResult> Dj;

        LeaderboardsLoadedBinderCallback(zzqc.zzb<Leaderboards.LeaderboardMetadataResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> Dj;

        GameSearchSuggestionsLoadedBinderCallback(zzqc.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<GamesMetadata.LoadGameInstancesResult> Dj;

        GameInstancesLoadedBinderCallback(zzqc.zzb<GamesMetadata.LoadGameInstancesResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Events.LoadEventsResult> Dj;

        EventsLoadedBinderCallback(zzqc.zzb<Events.LoadEventsResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<GamesMetadata.LoadGamesResult> Dj;

        GamesLoadedBinderCallback(zzqc.zzb<GamesMetadata.LoadGamesResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Achievements.UpdateAchievementResult> Dj;

        AchievementUpdatedBinderCallback(zzqc.zzb<Achievements.UpdateAchievementResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            this.Dj.setResult((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqc.zzb<Achievements.LoadAchievementsResult> Dj;

        AchievementsLoadedBinderCallback(zzqc.zzb<Achievements.LoadAchievementsResult> zzb2) {
            this.Dj = (zzqc.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.Dj.setResult((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzr(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzatx()).zzo(string, n);
                } else {
                    GamesLog.zzag("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

