/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.player;

import android.net.Uri;
import android.os.Parcel;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.player.ProfileSettingsEntityCreator;
import com.google.android.gms.games.internal.player.StockProfileImage;
import com.google.android.gms.games.internal.player.StockProfileImageEntity;

public class ProfileSettingsEntity
extends AbstractSafeParcelable
implements Players.LoadProfileSettingsResult {
    public static final ProfileSettingsEntityCreator CREATOR = new ProfileSettingsEntityCreator();
    private final int mVersionCode;
    private final Status fp;
    private final String VA;
    private final boolean abG;
    private final boolean Vy;
    private final boolean abH;
    private final StockProfileImageEntity abI;
    private final boolean abJ;
    private final boolean abK;

    public ProfileSettingsEntity(DataHolder dataHolder) {
        this.mVersionCode = 3;
        this.fp = new Status(dataHolder.getStatusCode());
        if (this.fp.isSuccess() && dataHolder.getCount() > 0) {
            int n = dataHolder.zzgb(0);
            this.VA = dataHolder.zzd("gamer_tag", 0, n);
            this.abG = dataHolder.zze("gamer_tag_explicitly_set", 0, n);
            this.Vy = dataHolder.zze("profile_visible", 0, n);
            this.abH = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
            String string = dataHolder.zzd("stock_avatar_url", 0, n);
            String string2 = dataHolder.zzd("stock_avatar_uri", 0, n);
            this.abI = !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) ? new StockProfileImageEntity(string, Uri.parse((String)string2)) : null;
            this.abJ = dataHolder.zze("profile_discoverable", 0, n);
            this.abK = dataHolder.zze("auto_sign_in", 0, n);
        } else {
            this.VA = null;
            this.abG = false;
            this.Vy = false;
            this.abH = false;
            this.abI = null;
            this.abJ = false;
            this.abK = false;
        }
    }

    ProfileSettingsEntity(int n, Status status, String string, boolean bl, boolean bl2, boolean bl3, StockProfileImageEntity stockProfileImageEntity, boolean bl4, boolean bl5) {
        this.mVersionCode = n;
        this.fp = status;
        this.VA = string;
        this.abG = bl;
        this.Vy = bl2;
        this.abH = bl3;
        this.abI = stockProfileImageEntity;
        this.abJ = bl4;
        this.abK = bl5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String zzbhy() {
        return this.VA;
    }

    @Override
    public boolean zzbii() {
        return this.abG;
    }

    @Override
    public boolean zzbib() {
        return this.Vy;
    }

    @Override
    public boolean zzbig() {
        return this.abH;
    }

    @Override
    public StockProfileImage zzbih() {
        return this.abI;
    }

    @Override
    public boolean zzbij() {
        return this.abJ;
    }

    @Override
    public boolean zzbik() {
        return this.abK;
    }

    public Status getStatus() {
        return this.fp;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.VA, this.abG, this.Vy, this.abH, this.fp, this.abI, this.abJ, this.abK});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Players.LoadProfileSettingsResult)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Players.LoadProfileSettingsResult loadProfileSettingsResult = (Players.LoadProfileSettingsResult)object;
        return zzab.equal((Object)this.VA, (Object)loadProfileSettingsResult.zzbhy()) && zzab.equal((Object)this.abG, (Object)loadProfileSettingsResult.zzbii()) && zzab.equal((Object)this.Vy, (Object)loadProfileSettingsResult.zzbib()) && zzab.equal((Object)this.abH, (Object)loadProfileSettingsResult.zzbig()) && zzab.equal((Object)this.fp, (Object)loadProfileSettingsResult.getStatus()) && zzab.equal((Object)this.abI, (Object)loadProfileSettingsResult.zzbih()) && zzab.equal((Object)this.abJ, (Object)loadProfileSettingsResult.zzbij()) && zzab.equal((Object)this.abK, (Object)loadProfileSettingsResult.zzbik());
    }

    public String toString() {
        return zzab.zzx((Object)this).zzg("GamerTag", (Object)this.VA).zzg("IsGamerTagExplicitlySet", (Object)this.abG).zzg("IsProfileVisible", (Object)this.Vy).zzg("IsVisibilityExplicitlySet", (Object)this.abH).zzg("Status", (Object)this.fp).zzg("StockProfileImage", (Object)this.abI).zzg("IsProfileDiscoverable", (Object)this.abJ).zzg("AutoSignIn", (Object)this.abK).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        ProfileSettingsEntityCreator.zza(this, parcel, n);
    }
}

