/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String XL;
    private final String gV;
    private final Uri UJ;
    private final Uri UK;
    private final int zzbqm;
    private final String WB;
    private final boolean acB;
    private final PlayerEntity VX;
    private final int kl;
    private final ParticipantResult acC;
    private final String UU;
    private final String UV;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.XL = participant.getParticipantId();
        this.gV = participant.getDisplayName();
        this.UJ = participant.getIconImageUri();
        this.UK = participant.getHiResImageUri();
        this.zzbqm = participant.getStatus();
        this.WB = participant.zzbju();
        this.acB = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.VX = player == null ? null : new PlayerEntity(player);
        this.kl = participant.getCapabilities();
        this.acC = participant.getResult();
        this.UU = participant.getIconImageUrl();
        this.UV = participant.getHiResImageUrl();
    }

    ParticipantEntity(int n, String string, String string2, Uri uri, Uri uri2, int n2, String string3, boolean bl, PlayerEntity playerEntity, int n3, ParticipantResult participantResult, String string4, String string5) {
        this.mVersionCode = n;
        this.XL = string;
        this.gV = string2;
        this.UJ = uri;
        this.UK = uri2;
        this.zzbqm = n2;
        this.WB = string3;
        this.acB = bl;
        this.VX = playerEntity;
        this.kl = n3;
        this.acC = participantResult;
        this.UU = string4;
        this.UV = string5;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzbqm;
    }

    @Override
    public String zzbju() {
        return this.WB;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.acB;
    }

    @Override
    public String getDisplayName() {
        if (this.VX == null) {
            return this.gV;
        }
        return this.VX.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.VX == null) {
            zzg.zzb((String)this.gV, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.VX.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.VX == null) {
            return this.UJ;
        }
        return this.VX.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.VX == null) {
            return this.UU;
        }
        return this.VX.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.VX == null) {
            return this.UK;
        }
        return this.VX.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.VX == null) {
            return this.UV;
        }
        return this.VX.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.XL;
    }

    @Override
    public Player getPlayer() {
        return this.VX;
    }

    @Override
    public ParticipantResult getResult() {
        return this.acC;
    }

    @Override
    public int getCapabilities() {
        return this.kl;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzab.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzbju(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzab.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzab.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzab.equal((Object)participant2.zzbju(), (Object)participant.zzbju()) && zzab.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzab.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzab.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzab.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzab.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzab.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzab.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzab.zzx((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzbju()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzaur()) {
            ParticipantEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.XL);
            parcel.writeString(this.gV);
            parcel.writeString(this.UJ == null ? null : this.UJ.toString());
            parcel.writeString(this.UK == null ? null : this.UK.toString());
            parcel.writeInt(this.zzbqm);
            parcel.writeString(this.WB);
            parcel.writeInt(this.acB ? 1 : 0);
            parcel.writeInt(this.VX == null ? 0 : 1);
            if (this.VX != null) {
                this.VX.writeToParcel(parcel, n);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzmd(Parcel parcel) {
            boolean bl = ParticipantEntity.zzf(ParticipantEntity.zzauq());
            if (bl || ParticipantEntity.zzhs((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzmd(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            Object var14_14 = null;
            Object var15_15 = null;
            Object var16_16 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, 7, null, null, null);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzmd(parcel);
        }
    }
}

