/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
extends AbstractSafeParcelable
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity aaK;
    private final String adl;
    private final long adm;
    private final Uri adn;
    private final String ado;
    private final String Y;
    private final long adp;
    private final long Wa;
    private final Uri mIconUri;
    private final String adq;
    private final String mName;
    private final long adr;
    private final long ads;
    private final int mState;
    private final int lN;
    private final ArrayList<MilestoneEntity> adt;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.aaK = new GameEntity(quest.getGame());
        this.adl = quest.getQuestId();
        this.adm = quest.getAcceptedTimestamp();
        this.Y = quest.getDescription();
        this.adn = quest.getBannerImageUri();
        this.ado = quest.getBannerImageUrl();
        this.adp = quest.getEndTimestamp();
        this.mIconUri = quest.getIconImageUri();
        this.adq = quest.getIconImageUrl();
        this.Wa = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.adr = quest.zzbne();
        this.ads = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.lN = quest.getType();
        List<Milestone> list = quest.zzbnd();
        int n = list.size();
        this.adt = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.adt.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int n, GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n2, int n3, ArrayList<MilestoneEntity> arrayList) {
        this.mVersionCode = n;
        this.aaK = gameEntity;
        this.adl = string;
        this.adm = l;
        this.adn = uri;
        this.ado = string2;
        this.Y = string3;
        this.adp = l2;
        this.Wa = l3;
        this.mIconUri = uri2;
        this.adq = string4;
        this.mName = string5;
        this.adr = l4;
        this.ads = l5;
        this.mState = n2;
        this.lN = n3;
        this.adt = arrayList;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.adl;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.Y;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Y, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.mIconUri;
    }

    @Override
    public String getIconImageUrl() {
        return this.adq;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.adn;
    }

    @Override
    public String getBannerImageUrl() {
        return this.ado;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzbnd().get(0);
    }

    @Override
    public List<Milestone> zzbnd() {
        return new ArrayList<Milestone>(this.adt);
    }

    @Override
    public Game getGame() {
        return this.aaK;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.lN;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.adm;
    }

    @Override
    public long getEndTimestamp() {
        return this.adp;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Wa;
    }

    @Override
    public long zzbne() {
        return this.adr;
    }

    @Override
    public long getStartTimestamp() {
        return this.ads;
    }

    @Override
    public boolean isEndingSoon() {
        return this.adr <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzab.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzbnd(), quest.getName(), quest.zzbne(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzab.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzab.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzab.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzab.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzab.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzab.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzab.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzab.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzab.equal(quest2.zzbnd(), quest.zzbnd()) && zzab.equal((Object)quest2.getName(), (Object)quest.getName()) && zzab.equal((Object)quest2.zzbne(), (Object)quest.zzbne()) && zzab.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzab.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzab.zzx((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzbnd()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzbne()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        QuestEntityCreator.zza(this, parcel, n);
    }
}

