/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
extends AbstractSafeParcelable
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity aaK;
    private final PlayerEntity adu;
    private final byte[] adb;
    private final String zzcaj;
    private final ArrayList<PlayerEntity> adv;
    private final int lN;
    private final long acu;
    private final long adw;
    private final Bundle adx;
    private final int zzbqm;

    public GameRequestEntity(GameRequest gameRequest) {
        this.mVersionCode = 2;
        this.aaK = new GameEntity(gameRequest.getGame());
        this.adu = new PlayerEntity(gameRequest.getSender());
        this.zzcaj = gameRequest.getRequestId();
        this.lN = gameRequest.getType();
        this.acu = gameRequest.getCreationTimestamp();
        this.adw = gameRequest.getExpirationTimestamp();
        this.zzbqm = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.adb = null;
        } else {
            this.adb = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.adb, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.adv = new ArrayList(n);
        this.adx = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.adv.add((PlayerEntity)player);
            this.adx.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int n, GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n2, long l, long l2, Bundle bundle, int n3) {
        this.mVersionCode = n;
        this.aaK = gameEntity;
        this.adu = playerEntity;
        this.adb = byArray;
        this.zzcaj = string;
        this.adv = arrayList;
        this.lN = n2;
        this.acu = l;
        this.adw = l2;
        this.adx = bundle;
        this.zzbqm = n3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzcaj;
    }

    @Override
    public Game getGame() {
        return this.aaK;
    }

    @Override
    public Player getSender() {
        return this.adu;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.adv);
    }

    @Override
    public boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public byte[] getData() {
        return this.adb;
    }

    @Override
    public int getType() {
        return this.lN;
    }

    @Override
    public long getCreationTimestamp() {
        return this.acu;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.adw;
    }

    @Override
    public int getRecipientStatus(String string) {
        return this.adx.getInt(string, 0);
    }

    @Override
    public int getStatus() {
        return this.zzbqm;
    }

    public Bundle zzbnf() {
        return this.adx;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzab.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzab.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzab.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzab.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzab.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzab.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzab.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzab.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzab.zzx((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameRequestEntityCreator.zza(this, parcel, n);
    }
}

