/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.video.VideoConfigurationCreator;

public final class VideoConfiguration
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new VideoConfigurationCreator();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int mVersionCode;
    private final int aen;
    private final int aeg;
    private final String aeo;
    private final String aep;
    private final String aeq;
    private final String aer;
    private final boolean aes;

    private VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        this(2, n, n2, string, string2, string3, string4, bl);
    }

    public VideoConfiguration(int n, int n2, int n3, String string, String string2, String string3, String string4, boolean bl) {
        this.mVersionCode = n;
        zzac.zzbs((boolean)VideoConfiguration.isValidQualityLevel(n2, false));
        zzac.zzbs((boolean)VideoConfiguration.isValidCaptureMode(n3, false));
        this.aen = n2;
        this.aeg = n3;
        this.aes = bl;
        if (n3 == 1) {
            this.aep = string2;
            this.aeo = string;
            this.aeq = string3;
            this.aer = string4;
        } else {
            zzac.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
            zzac.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
            zzac.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
            zzac.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
            this.aep = null;
            this.aeo = null;
            this.aeq = null;
            this.aer = null;
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getQualityLevel() {
        return this.aen;
    }

    public int getCaptureMode() {
        return this.aeg;
    }

    public String zzbno() {
        return this.aep;
    }

    public String getStreamUrl() {
        return this.aeo;
    }

    public String zzbnp() {
        return this.aeq;
    }

    public String zzbnq() {
        return this.aer;
    }

    public boolean zzbnr() {
        return this.aes;
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoConfigurationCreator.zza(this, parcel, n);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int aen;
        private int aeg;
        private boolean aes;
        private String aeo;
        private String aep;
        private String aeq;
        private String aer;

        public Builder(int n, int n2) {
            this.aen = n;
            this.aeg = n2;
            this.aes = true;
            this.aeo = null;
            this.aep = null;
            this.aeq = null;
            this.aer = null;
        }

        public Builder setQualityLevel(int n) {
            this.aen = n;
            return this;
        }

        public Builder setCaptureMode(int n) {
            this.aeg = n;
            return this;
        }

        public VideoConfiguration build() {
            return new VideoConfiguration(this.aen, this.aeg, null, null, null, null, this.aes);
        }
    }
}

