/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private String rK;
    private String gV;
    private final Uri UJ;
    private final Uri UK;
    private final long Vt;
    private final int Vu;
    private final long Vv;
    private final String UU;
    private final String UV;
    private final String HP;
    private final MostRecentGameInfoEntity Vw;
    private final PlayerLevelInfo Vx;
    private final boolean Vy;
    private final boolean Vz;
    private final String VA;
    private final String mName;
    private final Uri VB;
    private final String VC;
    private final Uri VD;
    private final String VE;
    private final int VF;
    private final long VG;
    private final boolean zzcws;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean bl) {
        this.mVersionCode = 14;
        this.rK = bl ? player.getPlayerId() : null;
        this.gV = player.getDisplayName();
        this.UJ = player.getIconImageUri();
        this.UU = player.getIconImageUrl();
        this.UK = player.getHiResImageUri();
        this.UV = player.getHiResImageUrl();
        this.Vt = player.getRetrievedTimestamp();
        this.Vu = player.zzbia();
        this.Vv = player.getLastPlayedWithTimestamp();
        this.HP = player.getTitle();
        this.Vy = player.zzbib();
        MostRecentGameInfo mostRecentGameInfo = player.zzbic();
        this.Vw = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.Vx = player.getLevelInfo();
        this.Vz = player.zzbhz();
        this.VA = player.zzbhy();
        this.mName = player.getName();
        this.VB = player.getBannerImageLandscapeUri();
        this.VC = player.getBannerImageLandscapeUrl();
        this.VD = player.getBannerImagePortraitUri();
        this.VE = player.getBannerImagePortraitUrl();
        this.VF = player.zzbid();
        this.VG = player.zzbie();
        this.zzcws = player.isMuted();
        if (bl) {
            zzc.zzu((Object)this.rK);
        }
        zzc.zzu((Object)this.gV);
        zzc.zzbr((this.Vt > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int n, String string, String string2, Uri uri, Uri uri2, long l, int n2, long l2, String string3, String string4, String string5, MostRecentGameInfoEntity mostRecentGameInfoEntity, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n3, long l3, boolean bl3) {
        this.mVersionCode = n;
        this.rK = string;
        this.gV = string2;
        this.UJ = uri;
        this.UU = string3;
        this.UK = uri2;
        this.UV = string4;
        this.Vt = l;
        this.Vu = n2;
        this.Vv = l2;
        this.HP = string5;
        this.Vy = bl;
        this.Vw = mostRecentGameInfoEntity;
        this.Vx = playerLevelInfo;
        this.Vz = bl2;
        this.VA = string6;
        this.mName = string7;
        this.VB = uri3;
        this.VC = string8;
        this.VD = uri4;
        this.VE = string9;
        this.VF = n3;
        this.VG = l3;
        this.zzcws = bl3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.rK;
    }

    @Override
    public String getDisplayName() {
        return this.gV;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.gV, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String zzbhy() {
        return this.VA;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzbhz() {
        return this.Vz;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.UJ;
    }

    @Override
    public String getIconImageUrl() {
        return this.UU;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.UK;
    }

    @Override
    public String getHiResImageUrl() {
        return this.UV;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.Vt;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.Vv;
    }

    @Override
    public int zzbia() {
        return this.Vu;
    }

    @Override
    public boolean zzbib() {
        return this.Vy;
    }

    @Override
    public String getTitle() {
        return this.HP;
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.HP, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.Vx;
    }

    @Override
    public MostRecentGameInfo zzbic() {
        return this.Vw;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.VB;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.VC;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.VD;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.VE;
    }

    @Override
    public int zzbid() {
        return this.VF;
    }

    @Override
    public long zzbie() {
        return this.VG;
    }

    @Override
    public boolean isMuted() {
        return this.zzcws;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzab.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzbhz(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzbhy(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzbid(), player.zzbie(), player.isMuted()});
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzab.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzab.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzab.equal((Object)player2.zzbhz(), (Object)player.zzbhz()) && zzab.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzab.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzab.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzab.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzab.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzab.equal((Object)player2.zzbhy(), (Object)player.zzbhy()) && zzab.equal((Object)player2.getName(), (Object)player.getName()) && zzab.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzab.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzab.equal((Object)player2.zzbid(), (Object)player.zzbid()) && zzab.equal((Object)player2.zzbie(), (Object)player.zzbie()) && zzab.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzab.zzx((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzbhz()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzbhy()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzbid()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzbie()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzaur()) {
            PlayerEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.rK);
            parcel.writeString(this.gV);
            parcel.writeString(this.UJ == null ? null : this.UJ.toString());
            parcel.writeString(this.UK == null ? null : this.UK.toString());
            parcel.writeLong(this.Vt);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzlj(Parcel parcel) {
            boolean bl = PlayerEntity.zzf(PlayerEntity.zzauq());
            if (bl || PlayerEntity.zzhs((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzlj(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            int n = -1;
            long l2 = -1L;
            Object var16_14 = null;
            Object var17_15 = null;
            Object var18_16 = null;
            Object var19_17 = null;
            Object var20_18 = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Object var23_21 = null;
            Object var24_22 = null;
            Object var25_23 = null;
            Object var26_24 = null;
            int n2 = -1;
            long l3 = -1L;
            boolean bl4 = false;
            return new PlayerEntity(14, string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzlj(parcel);
        }
    }
}

