/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int mVersionCode;
    private final GameEntity aaK;
    private final String fg;
    private final long acu;
    private final int acv;
    private final ParticipantEntity acw;
    private final ArrayList<ParticipantEntity> acx;
    private final int acy;
    private final int acz;

    InvitationEntity(Invitation invitation) {
        this.mVersionCode = 2;
        this.aaK = new GameEntity(invitation.getGame());
        this.fg = invitation.getInvitationId();
        this.acu = invitation.getCreationTimestamp();
        this.acv = invitation.getInvitationType();
        this.acy = invitation.getVariant();
        this.acz = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.acx = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.acx.add((ParticipantEntity)participant2.freeze());
        }
        zzac.zzb(participant, (Object)"Must have a valid inviter!");
        this.acw = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int n, GameEntity gameEntity, String string, long l, int n2, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n3, int n4) {
        this.mVersionCode = n;
        this.aaK = gameEntity;
        this.fg = string;
        this.acu = l;
        this.acv = n2;
        this.acw = participantEntity;
        this.acx = arrayList;
        this.acy = n3;
        this.acz = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.aaK;
    }

    @Override
    public String getInvitationId() {
        return this.fg;
    }

    @Override
    public Participant getInviter() {
        return this.acw;
    }

    @Override
    public long getCreationTimestamp() {
        return this.acu;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.acx);
    }

    @Override
    public int getInvitationType() {
        return this.acv;
    }

    @Override
    public int getVariant() {
        return this.acy;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.acz;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzab.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzab.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzab.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzab.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzab.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzab.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzab.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzab.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzab.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzab.zzx((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzaur()) {
            InvitationEntityCreator.zza(this, parcel, n);
        } else {
            this.aaK.writeToParcel(parcel, n);
            parcel.writeString(this.fg);
            parcel.writeLong(this.acu);
            parcel.writeInt(this.acv);
            this.acw.writeToParcel(parcel, n);
            int n2 = this.acx.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.acx.get(i).writeToParcel(parcel, n);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzmc(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzf(InvitationEntity.zzauq());
            if (bl || InvitationEntity.zzhs((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzmc(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            boolean bl2 = false;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, -1, 0);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzmc(parcel);
        }
    }
}

