/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String lU;
    private final String jh;
    private final String WN;
    private final String WO;
    private final String cg;
    private final String WP;
    private final Uri WQ;
    private final Uri WR;
    private final Uri WS;
    private final boolean WT;
    private final boolean WU;
    private final String WV;
    private final int WW;
    private final int WX;
    private final int WY;
    private final boolean WZ;
    private final boolean Xa;
    private final String Xb;
    private final String Xc;
    private final String Xd;
    private final boolean zzces;
    private final boolean Xe;
    private final boolean Xf;
    private final String Xg;
    private final boolean Xh;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.lU = game.getApplicationId();
        this.WN = game.getPrimaryCategory();
        this.WO = game.getSecondaryCategory();
        this.cg = game.getDescription();
        this.WP = game.getDeveloperName();
        this.jh = game.getDisplayName();
        this.WQ = game.getIconImageUri();
        this.Xb = game.getIconImageUrl();
        this.WR = game.getHiResImageUri();
        this.Xc = game.getHiResImageUrl();
        this.WS = game.getFeaturedImageUri();
        this.Xd = game.getFeaturedImageUrl();
        this.WT = game.zzbhj();
        this.WU = game.zzbhl();
        this.WV = game.zzbhm();
        this.WW = 1;
        this.WX = game.getAchievementTotalCount();
        this.WY = game.getLeaderboardCount();
        this.WZ = game.isRealTimeMultiplayerEnabled();
        this.Xa = game.isTurnBasedMultiplayerEnabled();
        this.zzces = game.isMuted();
        this.Xe = game.zzbhk();
        this.Xf = game.areSnapshotsEnabled();
        this.Xg = game.getThemeColor();
        this.Xh = game.hasGamepadSupport();
    }

    GameEntity(int n, String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n2, int n3, int n4, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.mVersionCode = n;
        this.lU = string;
        this.jh = string2;
        this.WN = string3;
        this.WO = string4;
        this.cg = string5;
        this.WP = string6;
        this.WQ = uri;
        this.Xb = string8;
        this.WR = uri2;
        this.Xc = string9;
        this.WS = uri3;
        this.Xd = string10;
        this.WT = bl;
        this.WU = bl2;
        this.WV = string7;
        this.WW = n2;
        this.WX = n3;
        this.WY = n4;
        this.WZ = bl3;
        this.Xa = bl4;
        this.zzces = bl5;
        this.Xe = bl6;
        this.Xf = bl7;
        this.Xg = string11;
        this.Xh = bl8;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.lU;
    }

    @Override
    public String getDisplayName() {
        return this.jh;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.jh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getPrimaryCategory() {
        return this.WN;
    }

    @Override
    public String getSecondaryCategory() {
        return this.WO;
    }

    @Override
    public String getDescription() {
        return this.cg;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.cg, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDeveloperName() {
        return this.WP;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.WP, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.WQ;
    }

    @Override
    public String getIconImageUrl() {
        return this.Xb;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.WR;
    }

    @Override
    public String getHiResImageUrl() {
        return this.Xc;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.WS;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.Xd;
    }

    @Override
    public boolean isMuted() {
        return this.zzces;
    }

    @Override
    public boolean zzbhk() {
        return this.Xe;
    }

    @Override
    public boolean zzbhj() {
        return this.WT;
    }

    @Override
    public boolean zzbhl() {
        return this.WU;
    }

    @Override
    public String zzbhm() {
        return this.WV;
    }

    public int zzbhn() {
        return this.WW;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.WX;
    }

    @Override
    public int getLeaderboardCount() {
        return this.WY;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.WZ;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.Xa;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.Xf;
    }

    @Override
    public String getThemeColor() {
        return this.Xg;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.Xh;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzz.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzbhj(), game.zzbhl(), game.zzbhm(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzbhk(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzz.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzz.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzz.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzz.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzz.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzz.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzz.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzz.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzz.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzz.equal((Object)game2.zzbhj(), (Object)game.zzbhj()) && zzz.equal((Object)game2.zzbhl(), (Object)game.zzbhl()) && zzz.equal((Object)game2.zzbhm(), (Object)game.zzbhm()) && zzz.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzz.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzz.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzz.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzz.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzz.equal((Object)game2.zzbhk(), (Object)game.zzbhk()) ? 1 : 0)) && zzz.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzz.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzz.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzz.zzx((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzbhj()).zzg("InstanceInstalled", (Object)game.zzbhl()).zzg("InstancePackageName", (Object)game.zzbhm()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzawa()) {
            GameEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.lU);
            parcel.writeString(this.jh);
            parcel.writeString(this.WN);
            parcel.writeString(this.WO);
            parcel.writeString(this.cg);
            parcel.writeString(this.WP);
            parcel.writeString(this.WQ == null ? null : this.WQ.toString());
            parcel.writeString(this.WR == null ? null : this.WR.toString());
            parcel.writeString(this.WS == null ? null : this.WS.toString());
            parcel.writeInt(this.WT ? 1 : 0);
            parcel.writeInt(this.WU ? 1 : 0);
            parcel.writeString(this.WV);
            parcel.writeInt(this.WW);
            parcel.writeInt(this.WX);
            parcel.writeInt(this.WY);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzlk(Parcel parcel) {
            boolean bl = GameEntity.zzf(GameEntity.zzavz());
            if (bl || GameEntity.zzhu((String)GameEntity.class.getCanonicalName())) {
                return super.zzlk(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            Object var23_23 = null;
            Object var24_24 = null;
            Object var25_25 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            Object var29_29 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzlk(parcel);
        }
    }
}

