/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AppContentsImpl;
import com.google.android.gms.games.internal.api.EventsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.QuestsImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.SnapshotsImpl;
import com.google.android.gms.games.internal.api.SocialImpl;
import com.google.android.gms.games.internal.api.StatsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.api.VideosImpl;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzqo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzf<GamesClientImpl> hg = new Api.zzf();
    private static final Api.zza<GamesClientImpl, GamesOptions> hh = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(SCOPE_GAMES);
        }

        public /* synthetic */ List zzp(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    private static final Api.zza<GamesClientImpl, GamesOptions> Xi = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(Xj);
        }

        public /* synthetic */ List zzp(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api("Games.API", hh, hg);
    public static final Scope Xj = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> Xk = new Api("Games.API_1P", Xi, hg);
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final AppContents Xl = new AppContentsImpl();
    public static final Events Events = new EventsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer Xm = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Quests Quests = new QuestsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Snapshots Snapshots = new SnapshotsImpl();
    public static final Stats Stats = new StatsImpl();
    public static final Videos Videos = new VideosImpl();
    public static final Social Xn = new SocialImpl();

    private Games() {
    }

    public static GamesClientImpl zzi(GoogleApiClient googleApiClient) {
        return Games.zzb(googleApiClient, true);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzaa.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzaa.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzc(googleApiClient, bl);
    }

    public static GamesClientImpl zzc(GoogleApiClient googleApiClient, boolean bl) {
        zzaa.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        return bl2 ? (GamesClientImpl)googleApiClient.zza(hg) : null;
    }

    public static void setGravityForPopups(GoogleApiClient googleApiClient, int n) {
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzrs(n);
        }
    }

    public static void setViewForPopups(GoogleApiClient googleApiClient, View view) {
        zzaa.zzy((Object)view);
        GamesClientImpl gamesClientImpl = Games.zzb(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzw(view);
        }
    }

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public static String getCurrentAccountName(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzbjp();
    }

    @Deprecated
    public static PendingResult<GetServerAuthCodeResult> getGamesServerAuthCode(GoogleApiClient googleApiClient, final String string) {
        zzaa.zzh((String)string, (Object)"Please provide a valid serverClientId");
        return googleApiClient.zzb((zzqo.zza)new GetServerAuthCodeImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(string, (zzqo.zzb<GetServerAuthCodeResult>)this);
            }
        });
    }

    public static String getAppId(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzup();
    }

    public static Intent getSettingsIntent(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzbkb();
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzqo.zza)new SignOutImpl(googleApiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzh((zzqo.zzb<Status>)this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient googleApiClient) {
        return Games.zzi(googleApiClient).zzbkc();
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class GetServerAuthCodeImpl
    extends BaseGamesApiMethodImpl<GetServerAuthCodeResult> {
        private GetServerAuthCodeImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public GetServerAuthCodeResult zzbk(final Status status) {
            return new GetServerAuthCodeResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getCode() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzbk(status);
        }
    }

    private static abstract class GetTokenImpl
    extends BaseGamesApiMethodImpl<GetTokenResult> {
        public GetTokenResult zzbl(final Status status) {
            return new GetTokenResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzbl(status);
        }
    }

    @Deprecated
    public static interface GetServerAuthCodeResult
    extends Result {
        public String getCode();
    }

    public static interface GetTokenResult
    extends Result {
    }

    public static abstract class StatusImpl
    extends BaseGamesApiMethodImpl<Status> {
        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends zzqo.zza<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl(GoogleApiClient googleApiClient) {
            super(hg, googleApiClient);
        }
    }

    private static abstract class GamesClientBuilder
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private GamesClientBuilder() {
        }

        public GamesClientImpl zza(Context context, Looper looper, zzf zzf2, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, zzf2, gamesOptions, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 1;
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        public final boolean Xp;
        public final boolean Xq;
        public final int Xr;
        public final boolean Xs;
        public final int Xt;
        public final String Xu;
        public final ArrayList<String> Xv;
        public final boolean Xw;
        public final boolean Xx;

        private GamesOptions() {
            this.Xp = false;
            this.Xq = true;
            this.Xr = 17;
            this.Xs = false;
            this.Xt = 4368;
            this.Xu = null;
            this.Xv = new ArrayList();
            this.Xw = false;
            this.Xx = false;
        }

        private GamesOptions(Builder builder) {
            this.Xp = false;
            this.Xq = builder.Xq;
            this.Xr = builder.Xr;
            this.Xs = false;
            this.Xt = builder.Xt;
            this.Xu = null;
            this.Xv = builder.Xv;
            this.Xw = builder.Xw;
            this.Xx = false;
        }

        public Bundle zzbhp() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.Xp);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.Xq);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.Xr);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.Xs);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.Xt);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.Xu);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.Xv);
            bundle.putBoolean("com.google.android.gms.games.key.requireGooglePlus", this.Xw);
            bundle.putBoolean("com.google.android.gms.games.key.unauthenticated", this.Xx);
            return bundle;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean Xp = false;
            boolean Xq = true;
            int Xr = 17;
            boolean Xs = false;
            int Xt = 4368;
            String Xu = null;
            ArrayList<String> Xv = new ArrayList();
            boolean Xw = false;
            boolean Xx = false;

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean bl) {
                this.Xq = bl;
                this.Xr = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean bl, int n) {
                this.Xq = bl;
                this.Xr = n;
                return this;
            }

            @Deprecated
            public Builder setRequireGooglePlus(boolean bl) {
                this.Xw = bl;
                return this;
            }

            public Builder setSdkVariant(int n) {
                this.Xt = n;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

