/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.player.ProfileSettingsEntity;
import com.google.android.gms.games.internal.player.StockProfileImageBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.OnSocialInviteUpdateReceivedListener;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.social.SocialInvite;
import com.google.android.gms.games.social.SocialInviteBuffer;
import com.google.android.gms.games.social.SocialInviteEntity;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.signin.internal.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends zzj<IGamesService> {
    EventIncrementManager YL = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzbkn() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String YM;
    private PlayerEntity YN;
    private GameEntity YO;
    private final PopupManager YP;
    private boolean YQ = false;
    private final Binder YR;
    private final long YS;
    private final Games.GamesOptions YT;

    public GamesClientImpl(Context context, Looper looper, zzf zzf2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.YM = zzf2.zzavs();
        this.YR = new Binder();
        this.YP = PopupManager.zza(this, zzf2.zzavo());
        this.zzw(zzf2.zzavu());
        this.YS = ((Object)((Object)this)).hashCode();
        this.YT = gamesOptions;
    }

    public boolean zzain() {
        return true;
    }

    public void zza(@NonNull IGamesService iGamesService) {
        super.zza((IInterface)iGamesService);
        if (this.YQ) {
            this.YP.zzblb();
            this.YQ = false;
        }
        if (!this.YT.Xp && !this.YT.Xx) {
            this.zzb(iGamesService);
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.YQ = false;
    }

    public void zzrs(int n) {
        this.YP.setGravity(n);
    }

    public void zzw(View view) {
        this.YP.zzx(view);
    }

    protected Set<Scope> zzc(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzaa.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzaa.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(zze.zzf zzf2) {
        this.zzbjo();
        super.zza(zzf2);
    }

    public void disconnect() {
        this.YQ = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzavg();
                iGamesService.zzbkm();
                this.YL.flush();
                iGamesService.zzam(this.YS);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzae("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzjx() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzjy() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzgn(IBinder iBinder) {
        return IGamesService.Stub.zzgq(iBinder);
    }

    public Bundle zzapn() {
        try {
            Bundle bundle = ((IGamesService)this.zzavg()).zzapn();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zzbjo() {
        this.YN = null;
        this.YO = null;
    }

    protected Bundle zzahv() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.YT.zzbhp();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.YM);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.YP.zzbld()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 4);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzg.zza((zzf)this.zzawb()));
        return bundle;
    }

    public void zzb(IGamesService iGamesService) {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.YP);
            iGamesService.zza(popupLocationInfoBinderCallbacks, this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zzbjp() {
        try {
            return ((IGamesService)this.zzavg()).zzbjp();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzf(zzqo.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzj(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public void zzb(String string, zzqo.zzb<Games.GetServerAuthCodeResult> zzb2) throws RemoteException {
        zzaa.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((IGamesService)this.zzavg()).zza(string, new GetServerAuthCodeBinderCallbacks(zzb2));
    }

    public String zzby(boolean bl) {
        if (bl && this.YN != null) {
            return this.YN.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzavg()).zzbko();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzbjq() {
        this.zzavf();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.YN == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzavg()).zzbkp());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.YN = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.YN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzbjr() {
        this.zzavf();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.YO == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzavg()).zzbkr());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.YO = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.YO;
    }

    public void zza(zzqo.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzqo.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zzqo.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zzqo.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzavg()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zzqo.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                String string3 = String.valueOf(string);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid player collection: ".concat(string3) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zzqo.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzbjs() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzbjs();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zzqo.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zzqo.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzqo.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zzqo.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zzqo.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zzqo.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzbmn().asBundle(), n, n2);
    }

    public void zza(zzqo.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzbjt() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzbjt();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzqo.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzqo.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.YP.zzbld(), this.YP.zzblc());
    }

    public void zzb(zzqo.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.YP.zzbld(), this.YP.zzblc());
    }

    public void zza(zzqo.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.YP.zzbld(), this.YP.zzblc());
    }

    public void zzb(zzqo.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.YP.zzbld(), this.YP.zzblc());
    }

    public void zzd(zzqo.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzqo.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzo(String string, int n) {
        this.YL.zzo(string, n);
    }

    public Intent zzbju() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzbju();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbjv() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzbjv();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzrr<OnInvitationReceivedListener> zzrr2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzrr2);
            ((IGamesService)this.zzavg()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbjw() {
        try {
            ((IGamesService)this.zzavg()).zzan(this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzrr<OnTurnBasedMatchUpdateReceivedListener> zzrr2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzrr2);
            ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbjx() {
        try {
            ((IGamesService)this.zzavg()).zzao(this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzrr<QuestUpdateListener> zzrr2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzrr2);
            ((IGamesService)this.zzavg()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbjy() {
        try {
            ((IGamesService)this.zzavg()).zzaq(this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzrr<OnRequestReceivedListener> zzrr2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzrr2);
            ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzbjz() {
        try {
            ((IGamesService)this.zzavg()).zzap(this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbka() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzbka();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzbkb() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzbkb();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzg(zzqo.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzh(zzqo.zzb<Status> zzb2) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzbkc() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzavg()).zzbkc();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zzup() {
        try {
            return ((IGamesService)this.zzavg()).zzup();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zza(zzqo.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzp(String string, int n) {
        try {
            ((IGamesService)this.zzavg()).zzp(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzq(String string, int n) {
        try {
            ((IGamesService)this.zzavg()).zzq(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzqo.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzbmt(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zzqo.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzk((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zzqo.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzl((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzbkd() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzavg()).zzbkd();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zzqo.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zzqo.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zzqo.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzn(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zzqo.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzqo.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzm((IGamesCallbacks)new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzjw(String string) {
        try {
            ((IGamesService)this.zzavg()).zzke(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzqo.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zzqo.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzo(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzrr<RoomUpdateListener> zzrr2, zzrr<RoomStatusUpdateListener> zzrr3, zzrr<RealTimeMessageReceivedListener> zzrr4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzrr2, zzrr3, zzrr4);
            ((IGamesService)this.zzavg()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.YR, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzrr<RoomUpdateListener> zzrr2, zzrr<RoomStatusUpdateListener> zzrr3, zzrr<RealTimeMessageReceivedListener> zzrr4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzrr2, zzrr3, zzrr4);
            ((IGamesService)this.zzavg()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.YR, roomConfig.getInvitationId(), false, this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzrr<RoomUpdateListener> zzrr2, String string) {
        try {
            ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzrr2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzrr<RealTimeMultiplayer.ReliableMessageSentCallback> zzrr2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzrr2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzaa.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzavg()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zze(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzavg()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzrt(int n) {
        try {
            ((IGamesService)this.zzavg()).zzrt(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzbke() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzbke();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zza(n, byArray, n2, string);
            zzaa.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzbkf() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzavg()).zzbkf();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzbkg() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzavg()).zzbkg();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zzqo.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zzqo.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zzqo.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zzqo.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zzqo.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzc(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzc(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzjx(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzjx(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zzqo.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zzt(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zzqo.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zzqo.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zzqo.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzjy(String string) {
        try {
            ((IGamesService)this.zzavg()).zza(string, this.YP.zzbld(), this.YP.zzblc());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzqo.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zzqo.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.YL.flush();
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzbkh() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzavg()).zzbkh();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzbki() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzavg()).zzbki();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzqo.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zzqo.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zzqo.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzaa.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzbmy();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzbar();
        snapshotContents.close();
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzaa.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzbar();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzavg()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zzqo.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzq(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zzqo.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzaa.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzbmy();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzbar();
        snapshotContents.close();
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zzi(zzqo.zzb<Videos.CaptureCapabilitiesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzl(new CaptureCapabilitiesBinderCallback(zzb2));
    }

    public Intent zzbkj() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzavg()).zzbkx();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzj(zzqo.zzb<Videos.CaptureStateResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzv(new CaptureStateBinderCallbacks(zzb2));
    }

    public void zzk(zzqo.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzs(new CaptureStreamingAvailabilityBinderCallback(zzb2));
    }

    public void zzl(zzqo.zzb<Videos.CaptureStreamingMetadataResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzq(new CaptureStreamingMetadataBinderCallback(zzb2));
    }

    public void zzm(zzqo.zzb<Videos.CaptureStreamingUrlResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzr(new CaptureStreamingUrlBinderCallback(zzb2));
    }

    public void zzn(zzqo.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzt(new HeadlessCaptureEnabledBinderCallback(zzb2));
    }

    public void zzb(zzqo.zzb<Videos.CaptureAvailableResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new CaptureAvailableBinderCallback(zzb2), n);
    }

    public boolean zzbkk() {
        boolean bl = false;
        try {
            bl = ((IGamesService)this.zzavg()).zzbkk();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return bl;
    }

    public void zzo(zzqo.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzo(new CaptureStreamingEnabledBinderCallback(zzb2));
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new CaptureLaunchGameAndOverlayBinderCallback(baseGamesApiMethodImpl), string, videoConfiguration);
    }

    public void zzp(zzqo.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzk(new ListVideosBinderCallback(zzb2));
    }

    public void zzc(zzqo.zzb<Videos.ListVideosResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zzd((IGamesCallbacks)new ListVideosBinderCallback(zzb2), string, n);
    }

    public void zze(zzrr<Videos.CaptureOverlayStateListener> zzrr2) {
        try {
            CaptureOverlayStateBinderCallback captureOverlayStateBinderCallback = new CaptureOverlayStateBinderCallback(zzrr2);
            ((IGamesService)this.zzavg()).zzf((IGamesCallbacks)captureOverlayStateBinderCallback, this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzg(zzqo.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzm((IGamesCallbacks)new CapturePausedBinderCallback(zzb2), bl);
    }

    public void zza(zzqo.zzb<Status> zzb2, VideoConfiguration videoConfiguration, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new CaptureStartedBinderCallbacks(zzb2, captureRuntimeErrorCallback), videoConfiguration);
    }

    public void zzq(zzqo.zzb<Videos.CaptureStoppedResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzu(new CaptureStoppedBinderCallbacks(zzb2));
    }

    public void zzbkl() {
        try {
            ((IGamesService)this.zzavg()).zzat(this.YS);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzqo.zzb<Status> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzh(new UpdateHeadlessCapturePermissionBinderCallback(zzb2), string, bl);
    }

    public void zzj(zzqo.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zzqo.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzp(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzqo.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzqo.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zzqo.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzqo.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzqo.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zzqo.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zzqo.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzavg()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zzqo.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zzqo.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zzqo.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzr(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzqo.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zze(zzqo.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zza(zzqo.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl, bl2);
    }

    public void zzh(zzqo.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zza(zzqo.zzb<Players.LoadPlayersResult> zzb2, Account account) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), account);
    }

    public void zzr(zzqo.zzb<Players.LoadStockProfileImagesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzp(new StockProfileImagesLoadedBinderCallback(zzb2));
    }

    public void zza(zzqo.zzb<Players.UpdateGamerProfileResult> zzb2, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new GamerProfileUpdatedBinderCallback(zzb2), string, bl, string2, bl2, bl3);
    }

    public void zzi(zzqo.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzj((IGamesCallbacks)new DeletePlayerBinderCallback(zzb2), bl);
    }

    public void zzj(zzqo.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzk((IGamesCallbacks)new UpdateAutoSignInBinderCallback(zzb2), bl);
    }

    public void zzk(zzqo.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzl((IGamesCallbacks)new UpdateProfileDiscoverabilityBinderCallback(zzb2), bl);
    }

    public void zzb(zzqo.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zzqo.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zzqo.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzavg()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzqo.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zzqo.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzj((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zzqo.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zze(zzqo.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzn(zzqo.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzl(zzqo.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzqo.zzb<Status> zzb2, boolean bl, boolean bl2, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bl2, bundle);
    }

    public void zzs(zzqo.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzs(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zzqo.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zzqo.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zzqo.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzg(zzqo.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zzqo.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzavg()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzbkm() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzavg()).zzbkm();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzbi(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.YQ = bundle.getBoolean("show_welcome_popup");
            this.YN = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.YO = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zzo(zzqo.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzu(new SendFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzp(zzqo.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzv(new AcceptFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzq(zzqo.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzw(new IgnoreFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzr(zzqo.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzx(new CancelFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zze(zzqo.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzavg()).zzf(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzs(zzqo.zzb<Players.LoadPlayersResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzavg()).zzy(new PlayerUnfriendedBinderCallback(zzb2), string);
    }

    public void zzf(zzqo.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzavg()).zzg(new SetPlayerMutedBinderCallback(zzb2), string, bl);
    }

    public void zzc(zzqo.zzb<Social.LoadInvitesResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzavg()).zzb((IGamesCallbacks)new InvitesLoadedBinderCallback(zzb2), n);
    }

    public void zza(Account account, byte[] byArray) throws RemoteException {
        ((IGamesService)this.zzavg()).zza(account, byArray);
    }

    public void zzf(Account account) throws RemoteException {
        ((IGamesService)this.zzavg()).zzf(account);
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzgn(iBinder);
    }

    private static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer Zr;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zr = new VideoBuffer(dataHolder);
        }
    }

    private static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status hv;
        private final String zzae;

        CaptureStreamingUrlResultImpl(Status status, String string) {
            this.hv = status;
            this.zzae = string;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public String getUrl() {
            return this.zzae;
        }
    }

    private static final class CaptureStreamingMetadataResultImpl
    implements Videos.CaptureStreamingMetadataResult {
        private final Status hv;
        private final String JB;
        private final String cg;

        CaptureStreamingMetadataResultImpl(Status status, String string, String string2) {
            this.hv = status;
            this.JB = string;
            this.cg = string2;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class CaptureStreamingEnabledResultImpl
    implements Result {
        private final Status hv;

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class CaptureStreamingAvailabilityResultImpl
    implements Videos.CaptureStreamingAvailabilityResult {
        private final Status hv;
        private final boolean YZ;
        private final boolean Zg;

        CaptureStreamingAvailabilityResultImpl(Status status, boolean bl, boolean bl2) {
            this.hv = status;
            this.YZ = bl;
            this.Zg = bl2;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class CaptureStoppedResultImpl
    implements Videos.CaptureStoppedResult {
        private final Status hv;
        private final Uri Zf;

        CaptureStoppedResultImpl(Status status, Uri uri) {
            this.hv = status;
            this.Zf = uri;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class CaptureStateResultImpl
    implements Videos.CaptureStateResult {
        private final Status hv;
        private final CaptureState Ze;

        CaptureStateResultImpl(Status status, CaptureState captureState) {
            this.hv = status;
            this.Ze = captureState;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public CaptureState getCaptureState() {
            return this.Ze;
        }
    }

    private static final class CaptureCapabilitiesResultImpl
    implements Videos.CaptureCapabilitiesResult {
        private final Status hv;
        private final VideoCapabilities Za;

        CaptureCapabilitiesResultImpl(Status status, VideoCapabilities videoCapabilities) {
            this.hv = status;
            this.Za = videoCapabilities;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public VideoCapabilities getCapabilities() {
            return this.Za;
        }
    }

    private static final class CaptureAvailableResultImpl
    implements Videos.CaptureAvailableResult {
        private final Status hv;
        private final boolean YZ;

        CaptureAvailableResultImpl(Status status, boolean bl) {
            this.hv = status;
            this.YZ = bl;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public boolean isAvailable() {
            return this.YZ;
        }
    }

    private static final class InviteUpdateResultImpl
    extends GamesDataHolderResult
    implements Social.InviteUpdateResult {
        private final SocialInvite Zo;

        InviteUpdateResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            try {
                this.Zo = socialInviteBuffer.getCount() > 0 ? new SocialInviteEntity((SocialInvite)socialInviteBuffer.get(0)) : null;
            }
            finally {
                socialInviteBuffer.release();
            }
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status hv;
        private final String Zj;

        DeleteSnapshotResultImpl(int n, String string) {
            this.hv = GamesStatusCodes.zzqv(n);
            this.Zj = string;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public String getSnapshotId() {
            return this.Zj;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata Zi;

        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.Zi = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.Zi;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot ZP;
        private final String ZQ;
        private final Snapshot ZR;
        private final Contents ZS;
        private final SnapshotContents ZT;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents contents) {
            this(dataHolder, null, contents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.ZP = null;
                    this.ZR = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzc.zzbs((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.ZP = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    this.ZR = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.ZP = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(contents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.ZR = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(contents2));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.ZQ = string;
            this.ZS = contents3;
            this.ZT = new SnapshotContentsEntity(contents3);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.ZP;
        }

        @Override
        public String getConflictId() {
            return this.ZQ;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.ZR;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.ZT;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zy);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats ZC;

        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.ZC = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity((PlayerStats)playerStatsBuffer.get(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.ZC;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> Zt;

        LoadAppContentsResultImpl(DataHolder[] dataHolderArray) {
            super(dataHolderArray[0]);
            this.Zt = new ArrayList<DataHolder>(Arrays.asList(dataHolderArray));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone Zh;
        private final Quest YW;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.YW = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.YW.zzbmv();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.Zh = list.get(i);
                        return;
                    }
                    this.Zh = null;
                } else {
                    this.Zh = null;
                    this.YW = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.Zh;
        }

        @Override
        public Quest getQuest() {
            return this.YW;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest YW;

        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.YW = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.YW;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zy;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zy = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zy);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status hv;
        private final Bundle ZE;

        LoadRequestsResultImpl(Status status, Bundle bundle) {
            this.hv = status;
            this.ZE = bundle;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public GameRequestBuffer getRequests(int n) {
            String string = RequestType.zzrw(n);
            if (!this.ZE.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.ZE.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.ZE.keySet()) {
                DataHolder dataHolder = (DataHolder)this.ZE.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes aaw;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.aaw = RequestUpdateOutcomes.zzbl(dataHolder);
        }

        @Override
        public int getRequestOutcome(String string) {
            return this.aaw.getRequestOutcome(string);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.aaw.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest aac;

        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.aac = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status hv;
        private final Bundle Zm;

        InboxCountResultImpl(Status status, Bundle bundle) {
            this.hv = status;
            this.Zm = bundle;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class GetServerAuthCodeResultImpl
    implements Games.GetServerAuthCodeResult {
        private final Status hv;
        private final String Zl;

        GetServerAuthCodeResultImpl(Status status, String string) {
            this.hv = status;
            this.Zl = string;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public String getCode() {
            return this.Zl;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status hv;
        private final String hN;

        GetTokenResultImpl(Status status, String string) {
            this.hv = status;
            this.hN = string;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status hv;
        private final String Zk;
        private final boolean C;

        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.hv = GamesStatusCodes.zzqv(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.Zk = dataHolder.zzd("external_game_id", 0, 0);
                    this.C = dataHolder.zze("muted", 0, 0);
                } else {
                    this.Zk = null;
                    this.C = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status hv;
        private final String Zk;
        private final boolean C;

        public GameMuteStatusChangeResultImpl(int n, String string, boolean bl) {
            this.hv = GamesStatusCodes.zzqv(n);
            this.Zk = string;
            this.C = bl;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status hv;
        private final String YY;

        CancelMatchResultImpl(Status status, String string) {
            this.hv = status;
            this.YY = string;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public String getMatchId() {
            return this.YY;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch ZM;

        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.ZM = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.ZM;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData aao;

        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.aao = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.aao;
        }
    }

    private static final class UpdateGamerProfileResultImpl
    implements Players.UpdateGamerProfileResult {
        private final Status hv;
        private final Bundle aav;

        UpdateGamerProfileResultImpl(int n, Bundle bundle) {
            this.hv = new Status(n);
            this.aav = bundle;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class LoadStockProfileImagesResultImpl
    extends GamesDataHolderResult
    implements Players.LoadStockProfileImagesResult {
        private final StockProfileImageBuffer ZH;

        LoadStockProfileImagesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.ZH = new StockProfileImageBuffer(dataHolder);
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer ZK;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.ZK = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status hv;
        private final List<String> ZI;
        private final Bundle ZJ;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle bundle) {
            this.hv = status;
            this.ZI = bundle.getStringArrayList("game_category_list");
            this.ZJ = bundle;
        }

        public Status getStatus() {
            return this.hv;
        }
    }

    private static final class LoadInvitesResultImpl
    extends GamesDataHolderResult
    implements Social.LoadInvitesResult {
        private final SocialInviteBuffer Zz;

        LoadInvitesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zz = new SocialInviteBuffer(dataHolder);
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer ZD;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.ZD = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.ZD;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status hv;
        private final LoadMatchesResponse ZA;

        LoadMatchesResultImpl(Status status, Bundle bundle) {
            this.hv = status;
            this.ZA = new LoadMatchesResponse(bundle);
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.ZA;
        }

        public void release() {
            this.ZA.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer Zy;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zy = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.Zy;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity ZB;

        LoadPlayerScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.ZB = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.ZB;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity ZF;
        private final LeaderboardScoreBuffer ZG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.ZF = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.ZG = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.ZF;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.ZG;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer Zp;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zp = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.Zp;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer Zw;

        LoadGameSearchSuggestionsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zw = new GameSearchSuggestionBuffer(dataHolder);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer Zv;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zv = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer Zx;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zx = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.Zx;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer Zu;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zu = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.Zu;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status hv;
        private final String XX;

        UpdateAchievementResultImpl(int n, String string) {
            this.hv = GamesStatusCodes.zzqv(n);
            this.XX = string;
        }

        public Status getStatus() {
            return this.hv;
        }

        @Override
        public String getAchievementId() {
            return this.XX;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer Zs;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Zs = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.Zs;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzqy {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzqv(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzrr.zzc<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int uo;
        private final String ZZ;
        private final int aaa;

        RealTimeMessageSentNotifier(int n, int n2, String string) {
            this.uo = n;
            this.aaa = n2;
            this.ZZ = string;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.uo, this.aaa, this.ZZ);
            }
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzrr.zzc<RealTimeMessageReceivedListener> {
        private final RealTimeMessage ZN;

        MessageReceivedNotifier(RealTimeMessage realTimeMessage) {
            this.ZN = realTimeMessage;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.ZN);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzrr.zzc<RoomStatusUpdateListener> {
        private final String ZU;

        P2PDisconnectedNotifier(String string) {
            this.ZU = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.ZU);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzrr.zzc<RoomStatusUpdateListener> {
        private final String ZU;

        P2PConnectedNotifier(String string) {
            this.ZU = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.ZU);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzrr.zzc<RoomUpdateListener> {
        private final int uo;
        private final String Zq;

        LeftRoomNotifier(int n, String string) {
            this.uo = n;
            this.Zq = string;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.uo, this.Zq);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> YV = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.YV.add(stringArray[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.YV);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzqx<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzbi(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzqx<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzbi(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzrr.zzc<OnNearbyPlayerDetectedListener> {
        private final Player ZO;

        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(this.ZO);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class SocialInviteRemovedNotifier
    implements zzrr.zzc<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite aan;

        SocialInviteRemovedNotifier(SocialInvite socialInvite) {
            this.aan = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zzb(this.aan);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class SocialInviteUpdateReceivedNotifier
    implements zzrr.zzc<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite aan;

        SocialInviteUpdateReceivedNotifier(SocialInvite socialInvite) {
            this.aan = socialInvite;
        }

        public void zza(OnSocialInviteUpdateReceivedListener onSocialInviteUpdateReceivedListener) {
            onSocialInviteUpdateReceivedListener.zza(this.aan);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnSocialInviteUpdateReceivedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzrr.zzc<OnRequestReceivedListener> {
        private final String zzcec;

        RequestRemovedNotifier(String string) {
            this.zzcec = string;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzcec);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzrr.zzc<OnRequestReceivedListener> {
        private final GameRequest aac;

        RequestReceivedNotifier(GameRequest gameRequest) {
            this.aac = gameRequest;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.aac);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzrr.zzc<QuestUpdateListener> {
        private final Quest YW;

        QuestCompletedNotifier(Quest quest) {
            this.YW = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.YW);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzrr.zzc<OnTurnBasedMatchUpdateReceivedListener> {
        private final String ZL;

        MatchRemovedNotifier(String string) {
            this.ZL = string;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.ZL);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzrr.zzc<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch ZM;

        MatchUpdateReceivedNotifier(TurnBasedMatch turnBasedMatch) {
            this.ZM = turnBasedMatch;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.ZM);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzrr.zzc<OnInvitationReceivedListener> {
        private final String hm;

        InvitationRemovedNotifier(String string) {
            this.hm = string;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.hm);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzrr.zzc<OnInvitationReceivedListener> {
        private final Invitation Zn;

        InvitationReceivedNotifier(Invitation invitation) {
            this.Zn = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.Zn);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class CaptureOverlayStateChangedNotifier
    implements zzrr.zzc<Videos.CaptureOverlayStateListener> {
        private final int Zc;

        CaptureOverlayStateChangedNotifier(int n) {
            this.Zc = n;
        }

        public void zza(Videos.CaptureOverlayStateListener captureOverlayStateListener) {
            captureOverlayStateListener.onCaptureOverlayStateChanged(this.Zc);
        }

        public void zzasm() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((Videos.CaptureOverlayStateListener)object);
        }
    }

    private static final class SetPlayerMutedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Players.LoadPlayersResult> EW;

        SetPlayerMutedBinderCallback(zzqo.zzb<Players.LoadPlayersResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbg(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class PlayerUnfriendedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Players.LoadPlayersResult> EW;

        PlayerUnfriendedBinderCallback(zzqo.zzb<Players.LoadPlayersResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbf(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class CancelFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Social.InviteUpdateResult> EW;

        CancelFriendInviteFirstPartyBinderCallback(zzqo.zzb<Social.InviteUpdateResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbe(DataHolder dataHolder) {
            this.EW.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class IgnoreFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Social.InviteUpdateResult> EW;

        IgnoreFriendInviteFirstPartyBinderCallback(zzqo.zzb<Social.InviteUpdateResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbd(DataHolder dataHolder) {
            this.EW.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class AcceptFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Social.InviteUpdateResult> EW;

        AcceptFriendInviteFirstPartyBinderCallback(zzqo.zzb<Social.InviteUpdateResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzba(DataHolder dataHolder) {
            this.EW.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class SendFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Social.InviteUpdateResult> EW;

        SendFriendInviteFirstPartyBinderCallback(zzqo.zzb<Social.InviteUpdateResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaz(DataHolder dataHolder) {
            this.EW.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class UpdateHeadlessCapturePermissionBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        UpdateHeadlessCapturePermissionBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbo(Status status) {
            this.EW.setResult((Object)status);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Videos.ListVideosResult> EW;

        ListVideosBinderCallback(zzqo.zzb<Videos.ListVideosResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzax(DataHolder dataHolder) {
            this.EW.setResult((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class CaptureStreamingUrlBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Videos.CaptureStreamingUrlResult> EW;

        CaptureStreamingUrlBinderCallback(zzqo.zzb<Videos.CaptureStreamingUrlResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(int n, String string) {
            this.EW.setResult((Object)new CaptureStreamingUrlResultImpl(new Status(n), string));
        }
    }

    private static final class CaptureStreamingMetadataBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Videos.CaptureStreamingMetadataResult> EW;

        CaptureStreamingMetadataBinderCallback(zzqo.zzb<Videos.CaptureStreamingMetadataResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, String string, String string2) {
            this.EW.setResult((Object)new CaptureStreamingMetadataResultImpl(new Status(n), string, string2));
        }
    }

    private static final class CaptureStreamingEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        CaptureStreamingEnabledBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzrl(int n) {
            this.EW.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureStreamingAvailabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Videos.CaptureStreamingAvailabilityResult> EW;

        CaptureStreamingAvailabilityBinderCallback(zzqo.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, boolean bl, boolean bl2) {
            this.EW.setResult((Object)new CaptureStreamingAvailabilityResultImpl(new Status(n), bl, bl2));
        }
    }

    private static final class CaptureStoppedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Videos.CaptureStoppedResult> EW;

        public CaptureStoppedBinderCallbacks(zzqo.zzb<Videos.CaptureStoppedResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, Uri uri) {
            this.EW.setResult((Object)new CaptureStoppedResultImpl(new Status(n), uri));
        }
    }

    private static final class CaptureStateBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Videos.CaptureStateResult> EW;

        public CaptureStateBinderCallbacks(zzqo.zzb<Videos.CaptureStateResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            this.EW.setResult((Object)new CaptureStateResultImpl(new Status(n), CaptureState.zzab(bundle)));
        }
    }

    private static final class CaptureStartedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;
        private final Videos.CaptureRuntimeErrorCallback Zd;

        public CaptureStartedBinderCallbacks(zzqo.zzb<Status> zzb2, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
            this.Zd = (Videos.CaptureRuntimeErrorCallback)zzaa.zzb((Object)captureRuntimeErrorCallback, (Object)"Callback must not be null");
        }

        @Override
        public void zzbp(Status status) {
            this.EW.setResult((Object)status);
        }

        @Override
        public void zzrp(int n) {
            this.Zd.zzth(n);
        }
    }

    private static final class CapturePausedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        public CapturePausedBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzrq(int n) {
            this.EW.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureOverlayStateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrr<Videos.CaptureOverlayStateListener> LE;

        CaptureOverlayStateBinderCallback(zzrr<Videos.CaptureOverlayStateListener> zzrr2) {
            this.LE = (zzrr)zzaa.zzb(zzrr2, (Object)"Callback must not be null");
        }

        @Override
        public void onCaptureOverlayStateChanged(int n) {
            this.LE.zza((zzrr.zzc)new CaptureOverlayStateChangedNotifier(n));
        }
    }

    private static final class CaptureLaunchGameAndOverlayBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> Zb;

        CaptureLaunchGameAndOverlayBinderCallback(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl) {
            this.Zb = (Games.BaseGamesApiMethodImpl)((Object)zzaa.zzb(baseGamesApiMethodImpl, (Object)"Holder must not be null"));
        }

        @Override
        public void zzrk(int n) {
            this.Zb.zzc((Result)new Status(n));
        }

        @Override
        public void zzbm(Status status) {
            this.Zb.zzc((Result)status);
        }
    }

    private static final class CaptureCapabilitiesBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Videos.CaptureCapabilitiesResult> EW;

        CaptureCapabilitiesBinderCallback(zzqo.zzb<Videos.CaptureCapabilitiesResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, VideoCapabilities videoCapabilities) {
            this.EW.setResult((Object)new CaptureCapabilitiesResultImpl(new Status(n), videoCapabilities));
        }
    }

    private static final class CaptureAvailableBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Videos.CaptureAvailableResult> EW;

        CaptureAvailableBinderCallback(zzqo.zzb<Videos.CaptureAvailableResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, boolean bl) {
            this.EW.setResult((Object)new CaptureAvailableResultImpl(new Status(n), bl));
        }
    }

    private static final class HeadlessCaptureEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        HeadlessCaptureEnabledBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbn(Status status) {
            this.EW.setResult((Object)status);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Snapshots.DeleteSnapshotResult> EW;

        public SnapshotDeletedBinderCallbacks(zzqo.zzb<Snapshots.DeleteSnapshotResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(int n, String string) {
            this.EW.setResult((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Snapshots.CommitSnapshotResult> aak;

        public SnapshotCommittedBinderCallbacks(zzqo.zzb<Snapshots.CommitSnapshotResult> zzb2) {
            this.aak = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzao(DataHolder dataHolder) {
            this.aak.setResult((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Snapshots.OpenSnapshotResult> aal;

        public SnapshotOpenedBinderCallbacks(zzqo.zzb<Snapshots.OpenSnapshotResult> zzb2) {
            this.aal = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.aal.setResult((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.aal.setResult((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Snapshots.LoadSnapshotsResult> aam;

        public SnapshotsLoadedBinderCallbacks(zzqo.zzb<Snapshots.LoadSnapshotsResult> zzb2) {
            this.aam = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzan(DataHolder dataHolder) {
            this.aam.setResult((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Stats.LoadPlayerStatsResult> EW;

        public PlayerStatsLoadedBinderCallbacks(zzqo.zzb<Stats.LoadPlayerStatsResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaw(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<AppContents.LoadAppContentResult> YX;

        public AppContentLoadedBinderCallbacks(zzqo.zzb<AppContents.LoadAppContentResult> zzb2) {
            this.YX = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.YX.setResult((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Quests.LoadQuestsResult> ZY;

        public QuestsLoadedBinderCallbacks(zzqo.zzb<Quests.LoadQuestsResult> zzb2) {
            this.ZY = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzat(DataHolder dataHolder) {
            this.ZY.setResult((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Quests.ClaimMilestoneResult> ZW;
        private final String ZX;

        public QuestMilestoneClaimBinderCallbacks(zzqo.zzb<Quests.ClaimMilestoneResult> zzb2, String string) {
            this.ZW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
            this.ZX = (String)zzaa.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzap(DataHolder dataHolder) {
            this.ZW.setResult((Object)new ClaimMilestoneResultImpl(dataHolder, this.ZX));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Quests.AcceptQuestResult> ZV;

        public QuestAcceptedBinderCallbacks(zzqo.zzb<Quests.AcceptQuestResult> zzb2) {
            this.ZV = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaq(DataHolder dataHolder) {
            this.ZV.setResult((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Requests.LoadRequestSummariesResult> aae;

        public RequestSummariesLoadedBinderCallbacks(zzqo.zzb<Requests.LoadRequestSummariesResult> zzb2) {
            this.aae = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzam(DataHolder dataHolder) {
            this.aae.setResult((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Requests.LoadRequestsResult> aaf;

        public RequestsLoadedBinderCallbacks(zzqo.zzb<Requests.LoadRequestsResult> zzb2) {
            this.aaf = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzqv(n);
            this.aaf.setResult((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Requests.SendRequestResult> aad;

        public RequestSentBinderCallbacks(zzqo.zzb<Requests.SendRequestResult> zzb2) {
            this.aad = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzal(DataHolder dataHolder) {
            this.aad.setResult((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Requests.UpdateRequestsResult> aag;

        public RequestsUpdatedBinderCallbacks(zzqo.zzb<Requests.UpdateRequestsResult> zzb2) {
            this.aag = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzak(DataHolder dataHolder) {
            this.aag.setResult((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager YP;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.YP = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzbjl() {
            return new PopupLocationInfoParcelable(this.YP.zzble());
        }
    }

    private static final class GetServerAuthCodeBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Games.GetServerAuthCodeResult> EW;

        public GetServerAuthCodeBinderCallbacks(zzqo.zzb<Games.GetServerAuthCodeResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzqv(n);
            this.EW.setResult((Object)new GetServerAuthCodeResultImpl(status, string));
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Games.GetTokenResult> EW;

        public GetAuthTokenBinderCallbacks(zzqo.zzb<Games.GetTokenResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzqv(n);
            this.EW.setResult((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        public SignOutCompleteBinderCallbacks(zzqo.zzb<Status> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbjk() {
            Status status = GamesStatusCodes.zzqv(0);
            this.EW.setResult((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Notifications.InboxCountResult> EW;

        InboxCountsLoadedBinderCallback(zzqo.zzb<Notifications.InboxCountResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzqv(n);
            this.EW.setResult((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        ContactSettingsUpdatedBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzri(int n) {
            this.EW.setResult((Object)GamesStatusCodes.zzqv(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Notifications.ContactSettingLoadResult> EW;

        ContactSettingsLoadedBinderCallback(zzqo.zzb<Notifications.ContactSettingLoadResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzai(DataHolder dataHolder) {
            this.EW.setResult((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Notifications.GameMuteStatusLoadResult> EW;

        GameMuteStatusLoadedBinderCallback(zzqo.zzb<Notifications.GameMuteStatusLoadResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzag(DataHolder dataHolder) {
            this.EW.setResult((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Notifications.GameMuteStatusChangeResult> EW;

        GameMuteStatusChangedBinderCallback(zzqo.zzb<Notifications.GameMuteStatusChangeResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.EW.setResult((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzrr<RealTimeMultiplayer.ReliableMessageSentCallback> aab;

        public RealTimeReliableMessageBinderCallbacks(zzrr<RealTimeMultiplayer.ReliableMessageSentCallback> zzrr2) {
            this.aab = zzrr2;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.aab != null) {
                this.aab.zza((zzrr.zzc)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzrr<? extends RoomUpdateListener> aah;
        private final zzrr<? extends RoomStatusUpdateListener> aai;
        private final zzrr<RealTimeMessageReceivedListener> aaj;

        public RoomBinderCallbacks(zzrr<RoomUpdateListener> zzrr2) {
            this.aah = (zzrr)zzaa.zzb(zzrr2, (Object)"Callbacks must not be null");
            this.aai = null;
            this.aaj = null;
        }

        public RoomBinderCallbacks(zzrr<? extends RoomUpdateListener> zzrr2, zzrr<? extends RoomStatusUpdateListener> zzrr3, zzrr<RealTimeMessageReceivedListener> zzrr4) {
            this.aah = (zzrr)zzaa.zzb(zzrr2, (Object)"Callbacks must not be null");
            this.aai = zzrr3;
            this.aaj = zzrr4;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.aah.zza((zzrr.zzc)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzaa(DataHolder dataHolder) {
            this.aah.zza((zzrr.zzc)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int n, String string) {
            this.aah.zza((zzrr.zzc)new LeftRoomNotifier(n, string));
        }

        @Override
        public void zzad(DataHolder dataHolder) {
            this.aah.zza((zzrr.zzc)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzab(DataHolder dataHolder) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzac(DataHolder dataHolder) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzae(DataHolder dataHolder) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzaf(DataHolder dataHolder) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String string) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new P2PConnectedNotifier(string));
            }
        }

        @Override
        public void onP2PDisconnected(String string) {
            if (this.aai != null) {
                this.aai.zza((zzrr.zzc)new P2PDisconnectedNotifier(string));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.aaj != null) {
                this.aaj.zza((zzrr.zzc)new MessageReceivedNotifier(realTimeMessage));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<TurnBasedMultiplayer.CancelMatchResult> aap;

        public TurnBasedMatchCanceledBinderCallbacks(zzqo.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2) {
            this.aap = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            Status status = GamesStatusCodes.zzqv(n);
            this.aap.setResult((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<TurnBasedMultiplayer.LeaveMatchResult> aar;

        public TurnBasedMatchLeftBinderCallbacks(zzqo.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2) {
            this.aar = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.aar.setResult((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<TurnBasedMultiplayer.UpdateMatchResult> aat;

        public TurnBasedMatchUpdatedBinderCallbacks(zzqo.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2) {
            this.aat = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.aat.setResult((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<TurnBasedMultiplayer.InitiateMatchResult> aaq;

        public TurnBasedMatchInitiatedBinderCallbacks(zzqo.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2) {
            this.aaq = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.aaq.setResult((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<TurnBasedMultiplayer.LoadMatchResult> aas;

        public TurnBasedMatchLoadedBinderCallbacks(zzqo.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2) {
            this.aas = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.aas.setResult((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<TurnBasedMultiplayer.LoadMatchesResult> aau;

        public TurnBasedMatchesLoadedBinderCallbacks(zzqo.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2) {
            this.aau = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzqv(n);
            this.aau.setResult((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Leaderboards.SubmitScoreResult> EW;

        public SubmitScoreBinderCallbacks(zzqo.zzb<Leaderboards.SubmitScoreResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.EW.setResult((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class UpdateProfileDiscoverabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        UpdateProfileDiscoverabilityBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = zzb2;
        }

        @Override
        public void zzro(int n) {
            this.EW.setResult((Object)new Status(n));
        }
    }

    private static final class UpdateAutoSignInBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        UpdateAutoSignInBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = zzb2;
        }

        @Override
        public void zzrn(int n) {
            this.EW.setResult((Object)new Status(n));
        }
    }

    private static final class DeletePlayerBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        DeletePlayerBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = zzb2;
        }

        @Override
        public void zzrm(int n) {
            this.EW.setResult((Object)new Status(n));
        }
    }

    private static final class GamerProfileUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Players.UpdateGamerProfileResult> EW;

        GamerProfileUpdatedBinderCallback(zzqo.zzb<Players.UpdateGamerProfileResult> zzb2) {
            this.EW = zzb2;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            this.EW.setResult((Object)new UpdateGamerProfileResultImpl(n, bundle));
        }
    }

    private static final class StockProfileImagesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Players.LoadStockProfileImagesResult> EW;

        StockProfileImagesLoadedBinderCallback(zzqo.zzb<Players.LoadStockProfileImagesResult> zzb2) {
            this.EW = zzb2;
        }

        @Override
        public void zzay(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadStockProfileImagesResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Status> EW;

        ProfileSettingsUpdatedBinderCallback(zzqo.zzb<Status> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzrj(int n) {
            this.EW.setResult((Object)GamesStatusCodes.zzqv(n));
        }
    }

    private static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Players.LoadProfileSettingsResult> EW;

        ProfileSettingsLoadedBinderCallback(zzqo.zzb<Players.LoadProfileSettingsResult> zzb2) {
            this.EW = zzb2;
        }

        @Override
        public void zzav(DataHolder dataHolder) {
            this.EW.setResult((Object)new ProfileSettingsEntity(dataHolder));
            dataHolder.close();
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Players.LoadXpStreamResult> EW;

        PlayerXpStreamLoadedBinderCallback(zzqo.zzb<Players.LoadXpStreamResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzau(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Players.LoadXpForGameCategoriesResult> EW;

        PlayerXpForGameCategoriesLoadedBinderCallback(zzqo.zzb<Players.LoadXpForGameCategoriesResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzqv(n);
            this.EW.setResult((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class InvitesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Social.LoadInvitesResult> EW;

        InvitesLoadedBinderCallback(zzqo.zzb<Social.LoadInvitesResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzbh(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadInvitesResultImpl(dataHolder));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Players.LoadPlayersResult> EW;

        PlayersLoadedBinderCallback(zzqo.zzb<Players.LoadPlayersResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class SocialInviteUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbb(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzrr.zzc)new SocialInviteUpdateReceivedNotifier(socialInvite));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbc(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzrr.zzc)new SocialInviteRemovedNotifier(socialInvite));
            }
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrr<OnRequestReceivedListener> LE;

        RequestReceivedBinderCallback(zzrr<OnRequestReceivedListener> zzrr2) {
            this.LE = zzrr2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.LE.zza((zzrr.zzc)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String string) {
            this.LE.zza((zzrr.zzc)new RequestRemovedNotifier(string));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrr<QuestUpdateListener> LE;

        QuestUpdateBinderCallback(zzrr<QuestUpdateListener> zzrr2) {
            this.LE = zzrr2;
        }

        @Override
        public void zzar(DataHolder dataHolder) {
            Quest quest = this.zzbk(dataHolder);
            if (quest != null) {
                this.LE.zza((zzrr.zzc)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzbk(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrr<OnTurnBasedMatchUpdateReceivedListener> LE;

        MatchUpdateReceivedBinderCallback(zzrr<OnTurnBasedMatchUpdateReceivedListener> zzrr2) {
            this.LE = zzrr2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.LE.zza((zzrr.zzc)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String string) {
            this.LE.zza((zzrr.zzc)new MatchRemovedNotifier(string));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzrr<OnInvitationReceivedListener> LE;

        InvitationReceivedBinderCallback(zzrr<OnInvitationReceivedListener> zzrr2) {
            this.LE = zzrr2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.LE.zza((zzrr.zzc)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String string) {
            this.LE.zza((zzrr.zzc)new InvitationRemovedNotifier(string));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Invitations.LoadInvitationsResult> EW;

        InvitationsLoadedBinderCallback(zzqo.zzb<Invitations.LoadInvitationsResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Leaderboards.LoadPlayerScoreResult> EW;

        PlayerLeaderboardScoreLoadedBinderCallback(zzqo.zzb<Leaderboards.LoadPlayerScoreResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaj(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Leaderboards.LoadScoresResult> EW;

        LeaderboardScoresLoadedBinderCallback(zzqo.zzb<Leaderboards.LoadScoresResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.EW.setResult((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Leaderboards.LeaderboardMetadataResult> EW;

        LeaderboardsLoadedBinderCallback(zzqo.zzb<Leaderboards.LeaderboardMetadataResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.EW.setResult((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> EW;

        GameSearchSuggestionsLoadedBinderCallback(zzqo.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<GamesMetadata.LoadGameInstancesResult> EW;

        GameInstancesLoadedBinderCallback(zzqo.zzb<GamesMetadata.LoadGameInstancesResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Events.LoadEventsResult> EW;

        EventsLoadedBinderCallback(zzqo.zzb<Events.LoadEventsResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<GamesMetadata.LoadGamesResult> EW;

        GamesLoadedBinderCallback(zzqo.zzb<GamesMetadata.LoadGamesResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Achievements.UpdateAchievementResult> EW;

        AchievementUpdatedBinderCallback(zzqo.zzb<Achievements.UpdateAchievementResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            this.EW.setResult((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzqo.zzb<Achievements.LoadAchievementsResult> EW;

        AchievementsLoadedBinderCallback(zzqo.zzb<Achievements.LoadAchievementsResult> zzb2) {
            this.EW = (zzqo.zzb)zzaa.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.EW.setResult((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzr(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzavg()).zzo(string, n);
                } else {
                    GamesLog.zzaf("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

